﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/payment-cryptography-data/PaymentCryptographyData_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace PaymentCryptographyData {
namespace Model {

/**
 * <p>Parameters to derive session key for Visa payment card for ARQC
 * verification.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-data-2022-02-03/SessionKeyVisa">AWS
 * API Reference</a></p>
 */
class SessionKeyVisa {
 public:
  AWS_PAYMENTCRYPTOGRAPHYDATA_API SessionKeyVisa() = default;
  AWS_PAYMENTCRYPTOGRAPHYDATA_API SessionKeyVisa(Aws::Utils::Json::JsonView jsonValue);
  AWS_PAYMENTCRYPTOGRAPHYDATA_API SessionKeyVisa& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_PAYMENTCRYPTOGRAPHYDATA_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The Primary Account Number (PAN) of the cardholder. A PAN is a unique
   * identifier for a payment credit or debit card and associates the card to a
   * specific account holder.</p>
   */
  inline const Aws::String& GetPrimaryAccountNumber() const { return m_primaryAccountNumber; }
  inline bool PrimaryAccountNumberHasBeenSet() const { return m_primaryAccountNumberHasBeenSet; }
  template <typename PrimaryAccountNumberT = Aws::String>
  void SetPrimaryAccountNumber(PrimaryAccountNumberT&& value) {
    m_primaryAccountNumberHasBeenSet = true;
    m_primaryAccountNumber = std::forward<PrimaryAccountNumberT>(value);
  }
  template <typename PrimaryAccountNumberT = Aws::String>
  SessionKeyVisa& WithPrimaryAccountNumber(PrimaryAccountNumberT&& value) {
    SetPrimaryAccountNumber(std::forward<PrimaryAccountNumberT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A number that identifies and differentiates payment cards with the same
   * Primary Account Number (PAN).</p>
   */
  inline const Aws::String& GetPanSequenceNumber() const { return m_panSequenceNumber; }
  inline bool PanSequenceNumberHasBeenSet() const { return m_panSequenceNumberHasBeenSet; }
  template <typename PanSequenceNumberT = Aws::String>
  void SetPanSequenceNumber(PanSequenceNumberT&& value) {
    m_panSequenceNumberHasBeenSet = true;
    m_panSequenceNumber = std::forward<PanSequenceNumberT>(value);
  }
  template <typename PanSequenceNumberT = Aws::String>
  SessionKeyVisa& WithPanSequenceNumber(PanSequenceNumberT&& value) {
    SetPanSequenceNumber(std::forward<PanSequenceNumberT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_primaryAccountNumber;

  Aws::String m_panSequenceNumber;
  bool m_primaryAccountNumberHasBeenSet = false;
  bool m_panSequenceNumberHasBeenSet = false;
};

}  // namespace Model
}  // namespace PaymentCryptographyData
}  // namespace Aws
