/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.software.internal;

import com.google.common.collect.ImmutableList;
import java.util.Objects;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Named;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.plugins.BuildModel;
import org.gradle.api.internal.plugins.Definition;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.plugins.PluginManagerInternal;
import org.gradle.api.internal.plugins.ProjectFeatureApplicationContext;
import org.gradle.api.internal.plugins.software.SoftwareType;
import org.gradle.api.internal.tasks.properties.InspectionScheme;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.GradleCoreProblemGroup;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.internal.Cast;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.properties.PropertyValue;
import org.gradle.internal.properties.PropertyVisitor;
import org.gradle.internal.reflect.DefaultTypeValidationContext;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.internal.reflect.validation.TypeValidationProblemRenderer;
import org.gradle.model.internal.type.ModelType;
import org.gradle.plugin.software.internal.BoundProjectFeatureImplementation;
import org.gradle.plugin.software.internal.ModelDefaultsApplicator;
import org.gradle.plugin.software.internal.ProjectFeatureApplicationContextInternal;
import org.gradle.plugin.software.internal.ProjectFeatureApplicator;
import org.gradle.plugin.software.internal.ProjectFeatureDeclarations;
import org.gradle.plugin.software.internal.ProjectFeatureImplementation;
import org.gradle.plugin.software.internal.ProjectFeatureSupportInternal;
import org.jspecify.annotations.NullMarked;

public class DefaultProjectFeatureApplicator
implements ProjectFeatureApplicator {
    private final ProjectFeatureDeclarations projectFeatureDeclarations;
    private final ModelDefaultsApplicator modelDefaultsApplicator;
    private final InspectionScheme inspectionScheme;
    private final InternalProblems problems;
    private final PluginManagerInternal pluginManager;
    private final ClassLoaderScope classLoaderScope;
    private final ObjectFactory objectFactory;

    public DefaultProjectFeatureApplicator(ProjectFeatureDeclarations projectFeatureDeclarations, ModelDefaultsApplicator modelDefaultsApplicator, InspectionScheme inspectionScheme, InternalProblems problems, PluginManagerInternal pluginManager, ClassLoaderScope classLoaderScope, ObjectFactory objectFactory) {
        this.projectFeatureDeclarations = projectFeatureDeclarations;
        this.modelDefaultsApplicator = modelDefaultsApplicator;
        this.inspectionScheme = inspectionScheme;
        this.problems = problems;
        this.pluginManager = pluginManager;
        this.classLoaderScope = classLoaderScope;
        this.objectFactory = objectFactory;
    }

    public <T, V> T applyFeatureTo(DynamicObjectAware parentDefinition, ProjectFeatureImplementation<T, V> projectFeature) {
        ProjectFeatureSupportInternal.ProjectFeatureDefinitionContext parentDefinitionContext = ProjectFeatureSupportInternal.getContext((DynamicObjectAware)parentDefinition);
        ProjectFeatureSupportInternal.ProjectFeatureDefinitionContext.ChildDefinitionAdditionResult result = parentDefinitionContext.getOrAddChildDefinition(projectFeature, () -> {
            if (parentDefinition instanceof Project) {
                DefaultProjectFeatureApplicator.checkSingleProjectTypeApplication(parentDefinitionContext, projectFeature);
            }
            this.pluginManager.apply(projectFeature.getPluginClass());
            Plugin plugin = this.pluginManager.getPluginContainer().getPlugin(projectFeature.getPluginClass());
            Object definition = projectFeature instanceof BoundProjectFeatureImplementation ? this.instantiateBoundFeatureObjectsAndApply(parentDefinition, (BoundProjectFeatureImplementation)Cast.uncheckedCast((Object)projectFeature)) : this.instantiateLegacyProjectTypeDefinition(parentDefinition, projectFeature, plugin);
            return Cast.uncheckedNonnullCast((Object)definition);
        });
        if (result.isNew) {
            Plugin plugin = this.pluginManager.getPluginContainer().getPlugin(projectFeature.getPluginClass());
            this.modelDefaultsApplicator.applyDefaultsTo((Object)parentDefinition, result.definition, (ModelDefaultsApplicator.ClassLoaderContext)new ClassLoaderContextFromScope(this.classLoaderScope), plugin, projectFeature);
        }
        return (T)Cast.uncheckedNonnullCast((Object)result.definition);
    }

    private static <T, V> void checkSingleProjectTypeApplication(ProjectFeatureSupportInternal.ProjectFeatureDefinitionContext context, ProjectFeatureImplementation<T, V> projectFeature) {
        context.childrenDefinitions().keySet().stream().findFirst().ifPresent(projectTypeAlreadyApplied -> {
            throw new IllegalStateException("The project has already applied the '" + projectTypeAlreadyApplied.getFeatureName() + "' project type and is also attempting to apply the '" + projectFeature.getFeatureName() + "' project type.  Only one project type can be applied to a project.");
        });
    }

    private Object instantiateLegacyProjectTypeDefinition(Object parentDefinition, ProjectFeatureImplementation<?, ?> projectFeature, Plugin<?> plugin) {
        this.applyAndMaybeRegisterExtension(parentDefinition, projectFeature, plugin);
        return ((ExtensionAware)parentDefinition).getExtensions().getByName(projectFeature.getFeatureName());
    }

    private <T extends Definition<V>, V extends BuildModel> T instantiateBoundFeatureObjectsAndApply(Object parentDefinition, BoundProjectFeatureImplementation<T, V> projectFeature) {
        Definition definition = (Definition)this.instantiateDefinitionObject(parentDefinition, (ProjectFeatureImplementation<T, V>)projectFeature);
        BuildModel buildModelInstance = ProjectFeatureSupportInternal.createBuildModelInstance((ObjectFactory)this.objectFactory, (Definition)definition, projectFeature);
        ProjectFeatureSupportInternal.attachDefinitionContext((Object)definition, (BuildModel)buildModelInstance, (ProjectFeatureApplicator)this, (ProjectFeatureDeclarations)this.projectFeatureDeclarations, (ObjectFactory)this.objectFactory);
        ProjectFeatureApplicationContext applyActionContext = (ProjectFeatureApplicationContext)this.objectFactory.newInstance(ProjectFeatureApplicationContextInternal.class, new Object[0]);
        projectFeature.getBindingTransform().transform(applyActionContext, (Object)definition, (Object)buildModelInstance, Cast.uncheckedCast((Object)parentDefinition));
        return (T)definition;
    }

    private <T, V> T instantiateDefinitionObject(Object target, ProjectFeatureImplementation<T, V> projectFeature) {
        Class dslType = projectFeature.getDefinitionImplementationType();
        if (Named.class.isAssignableFrom(dslType)) {
            if (target instanceof Named) {
                return (T)this.objectFactory.newInstance(projectFeature.getDefinitionPublicType(), new Object[]{((Named)target).getName()});
            }
            throw new IllegalArgumentException("Cannot infer a name for definition " + dslType.getSimpleName() + " because the parent definition of type " + target.getClass().getSimpleName() + " does not implement Named.");
        }
        return (T)this.objectFactory.newInstance(dslType, new Object[0]);
    }

    private <T, V> void applyAndMaybeRegisterExtension(Object target, ProjectFeatureImplementation<T, V> projectFeature, Plugin<?> plugin) {
        DefaultTypeValidationContext typeValidationContext = DefaultTypeValidationContext.withRootType((Class)projectFeature.getPluginClass(), (boolean)false, (InternalProblems)this.problems);
        ExtensionAddingVisitor extensionAddingVisitor = new ExtensionAddingVisitor((ExtensionAware)target, typeValidationContext, this.projectFeatureDeclarations, this, this.objectFactory);
        this.inspectionScheme.getPropertyWalker().visitProperties(plugin, (TypeValidationContext)typeValidationContext, extensionAddingVisitor);
        if (!typeValidationContext.getProblems().isEmpty()) {
            throw new DefaultMultiCauseException(String.format(typeValidationContext.getProblems().size() == 1 ? "A problem was found with the %s plugin." : "Some problems were found with the %s plugin.", DefaultProjectFeatureApplicator.getPluginObjectDisplayName(plugin)), (Iterable)typeValidationContext.getProblems().stream().map(TypeValidationProblemRenderer::renderMinimalInformationAbout).sorted().map(InvalidUserDataException::new).collect(ImmutableList.toImmutableList()));
        }
    }

    private static String getPluginObjectDisplayName(Object parameterObject) {
        return ModelType.of((Class)new DslObject(parameterObject).getDeclaredType()).getDisplayName();
    }

    private static class ClassLoaderContextFromScope
    implements ModelDefaultsApplicator.ClassLoaderContext {
        private final ClassLoaderScope scope;

        public ClassLoaderContextFromScope(ClassLoaderScope scope) {
            this.scope = scope;
        }

        public ClassLoader getClassLoader() {
            return this.scope.getLocalClassLoader();
        }

        public ClassLoader getParentClassLoader() {
            return this.scope.getParent().getLocalClassLoader();
        }
    }

    @NullMarked
    public static class ExtensionAddingVisitor<T>
    implements PropertyVisitor {
        private final ExtensionAware target;
        private final DefaultTypeValidationContext validationContext;
        private final ProjectFeatureApplicator applicator;
        private final ProjectFeatureDeclarations projectFeatureDeclarations;
        private final ObjectFactory objectFactory;

        public ExtensionAddingVisitor(ExtensionAware target, DefaultTypeValidationContext validationContext, ProjectFeatureDeclarations projectFeatureDeclarations, ProjectFeatureApplicator applicator, ObjectFactory objectFactory) {
            this.target = target;
            this.validationContext = validationContext;
            this.projectFeatureDeclarations = projectFeatureDeclarations;
            this.applicator = applicator;
            this.objectFactory = objectFactory;
        }

        public void visitSoftwareTypeProperty(String propertyName, PropertyValue value, Class<?> declaredPropertyType, SoftwareType softwareType) {
            Object publicModelObject = Cast.uncheckedNonnullCast((Object)Objects.requireNonNull(value.call()));
            ProjectFeatureSupportInternal.attachLegacyDefinitionContext((Object)publicModelObject, (ProjectFeatureApplicator)this.applicator, (ProjectFeatureDeclarations)this.projectFeatureDeclarations, (ObjectFactory)this.objectFactory);
            if (softwareType.disableModelManagement()) {
                Object extension = this.target.getExtensions().findByName(softwareType.name());
                if (extension == null) {
                    this.validationContext.visitPropertyProblem(problem -> problem.forProperty(propertyName).id("extension-not-registered-for-software-type", "was not registered as an extension", GradleCoreProblemGroup.validation().property()).contextualLabel("has @SoftwareType annotation with 'disableModelManagement' set to true, but no extension with name '" + softwareType.name() + "' was registered").severity(Severity.ERROR).details("When 'disableModelManagement' is set, the plugin must register the '" + propertyName + "' property as an extension with the same name as the software type.").solution("During plugin application, register the '" + propertyName + "' property as an extension with the name '" + softwareType.name() + "'.").solution("Set 'disableModelManagement' to false or remove the parameter from the @SoftwareType annotation."));
                } else if (extension != publicModelObject) {
                    this.validationContext.visitPropertyProblem(problem -> problem.forProperty(propertyName).id("mismatched-extension-registered-for-software-type", "does not match the extension registered as '" + softwareType.name(), GradleCoreProblemGroup.validation().property()).contextualLabel("has @SoftwareType annotation with 'disableModelManagement' set to true, but the extension with name '" + softwareType.name() + "' does not match the value of the property").severity(Severity.ERROR).details("When 'disableModelManagement' is set, the plugin must register the '" + propertyName + "' property as an extension with the same name as the software type.").solution("During plugin application, register the '" + propertyName + "' property as an extension with the name '" + softwareType.name() + "'."));
                }
            } else {
                this.target.getExtensions().add(this.publicTypeFrom(softwareType.modelPublicType(), declaredPropertyType), softwareType.name(), publicModelObject);
            }
        }

        private Class<? super T> publicTypeFrom(Class<?> fromAnnotation, Class<?> declaredPropertyType) {
            return (Class)Cast.uncheckedCast(fromAnnotation == Void.class ? declaredPropertyType : fromAnnotation);
        }
    }
}

