/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.chart;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.chart.ChartAnnotation;
import net.sourceforge.plantuml.chart.ChartAxis;
import net.sourceforge.plantuml.chart.ChartRenderer;
import net.sourceforge.plantuml.chart.ChartSeries;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.preproc.PreprocessingArtifact;
import net.sourceforge.plantuml.skin.UmlDiagramType;

public class ChartDiagram
extends UmlDiagram {
    private final List<String> xAxisLabels = new ArrayList<String>();
    private String xAxisTitle;
    private Integer xAxisTickSpacing;
    private ChartAxis.LabelPosition xAxisLabelPosition = ChartAxis.LabelPosition.DEFAULT;
    private final ChartAxis xAxis = new ChartAxis();
    private final List<String> yAxisLabels = new ArrayList<String>();
    private final List<ChartSeries> series = new ArrayList<ChartSeries>();
    private final ChartAxis yAxis = new ChartAxis();
    private ChartAxis y2Axis;
    private LegendPosition legendPosition = LegendPosition.NONE;
    private GridMode xGridMode = GridMode.OFF;
    private GridMode yGridMode = GridMode.OFF;
    private StackMode stackMode = StackMode.GROUPED;
    private Orientation orientation = Orientation.VERTICAL;
    private final List<ChartAnnotation> annotations = new ArrayList<ChartAnnotation>();

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("Chart Diagram");
    }

    public ChartDiagram(UmlSource source, PreprocessingArtifact preprocessing) {
        super(source, UmlDiagramType.CHART, null, preprocessing);
    }

    @Override
    protected ImageData exportDiagramInternal(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        return this.createImageBuilder(fileFormatOption).drawable(this.getTextMainBlock(fileFormatOption)).write(os);
    }

    @Override
    protected TextBlock getTextMainBlock(FileFormatOption fileFormatOption) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                ChartDiagram.this.drawMe(ug);
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return ChartDiagram.this.getRenderer().calculateDimension(stringBounder);
            }
        };
    }

    private void drawMe(UGraphic ug) {
        ChartRenderer renderer = this.getRenderer();
        renderer.drawU(ug);
    }

    private ChartRenderer getRenderer() {
        if (this.orientation == Orientation.HORIZONTAL) {
            return new ChartRenderer(this.getSkinParam(), this.yAxisLabels, this.yAxis.getTitle(), null, this.xAxisLabelPosition, this.series, this.xAxis, this.xAxis, null, this.legendPosition, this.yGridMode, this.xGridMode, this.stackMode, this.orientation, this.annotations);
        }
        String hAxisTitle = this.xAxis != null && this.xAxis.getTitle() != null && !this.xAxis.getTitle().isEmpty() ? this.xAxis.getTitle() : this.xAxisTitle;
        return new ChartRenderer(this.getSkinParam(), this.xAxisLabels, hAxisTitle, this.xAxisTickSpacing, this.xAxisLabelPosition, this.series, this.xAxis, this.yAxis, this.y2Axis, this.legendPosition, this.xGridMode, this.yGridMode, this.stackMode, this.orientation, this.annotations);
    }

    public CommandExecutionResult setXAxisLabels(List<String> labels) {
        this.xAxisLabels.clear();
        this.xAxisLabels.addAll(labels);
        return CommandExecutionResult.ok();
    }

    public void setXAxisTitle(String title) {
        this.xAxisTitle = title;
    }

    public void setXAxisLabelPosition(ChartAxis.LabelPosition position) {
        this.xAxisLabelPosition = position;
    }

    public ChartAxis.LabelPosition getXAxisLabelPosition() {
        return this.xAxisLabelPosition;
    }

    public void setXAxisTickSpacing(Integer spacing) {
        this.xAxisTickSpacing = spacing;
    }

    public Integer getXAxisTickSpacing() {
        return this.xAxisTickSpacing;
    }

    public CommandExecutionResult setXAxis(String title, Double min, Double max) {
        if (title != null) {
            this.xAxis.setTitle(title);
        }
        if (min != null) {
            this.xAxis.setMin(min);
        }
        if (max != null) {
            this.xAxis.setMax(max);
        }
        return CommandExecutionResult.ok();
    }

    public ChartAxis getXAxis() {
        return this.xAxis;
    }

    public CommandExecutionResult setYAxis(String title, Double min, Double max) {
        if (title != null) {
            this.yAxis.setTitle(title);
        }
        if (min != null) {
            this.yAxis.setMin(min);
        }
        if (max != null) {
            this.yAxis.setMax(max);
        }
        return CommandExecutionResult.ok();
    }

    public CommandExecutionResult setYAxisLabels(List<String> labels) {
        this.yAxisLabels.clear();
        this.yAxisLabels.addAll(labels);
        return CommandExecutionResult.ok();
    }

    public CommandExecutionResult setY2Axis(String title, Double min, Double max) {
        if (this.y2Axis == null) {
            this.y2Axis = new ChartAxis();
        }
        if (title != null) {
            this.y2Axis.setTitle(title);
        }
        if (min != null) {
            this.y2Axis.setMin(min);
        }
        if (max != null) {
            this.y2Axis.setMax(max);
        }
        return CommandExecutionResult.ok();
    }

    public CommandExecutionResult addSeries(ChartSeries series) {
        boolean firstHasX;
        if (series.hasExplicitXValues()) {
            boolean firstHasX2;
            if (series.getType() != ChartSeries.SeriesType.LINE && series.getType() != ChartSeries.SeriesType.SCATTER) {
                return CommandExecutionResult.error("Coordinate pair notation (x:y) is only supported for line and scatter charts");
            }
            if (!this.xAxisLabels.isEmpty()) {
                return CommandExecutionResult.error("Coordinate pair notation requires numeric h-axis (e.g., h-axis \"x\" -5 --> 5), not categorical labels");
            }
            if (this.xAxis.isAutoScale() || this.xAxis.getMax() == this.xAxis.getMin()) {
                return CommandExecutionResult.error("Coordinate pair notation requires explicit h-axis range (e.g., h-axis \"x\" -5 --> 5)");
            }
            if (!this.series.isEmpty() && (firstHasX2 = this.series.get(0).hasExplicitXValues()) != series.hasExplicitXValues()) {
                return CommandExecutionResult.error("All series must use the same data format (either all coordinate pairs or all index-based)");
            }
            for (double x : series.getXValues()) {
                if (!(x < this.xAxis.getMin()) && !(x > this.xAxis.getMax())) continue;
                return CommandExecutionResult.error("X-coordinate " + x + " is outside h-axis range [" + this.xAxis.getMin() + ", " + this.xAxis.getMax() + "]");
            }
            for (double x : series.getXValues()) {
                this.xAxis.includeValue(x);
            }
        } else if (!this.series.isEmpty() && (firstHasX = this.series.get(0).hasExplicitXValues()) != series.hasExplicitXValues()) {
            return CommandExecutionResult.error("All series must use the same data format (either all coordinate pairs or all index-based)");
        }
        this.series.add(series);
        ChartAxis axis = series.isUseSecondaryAxis() && this.y2Axis != null ? this.y2Axis : this.yAxis;
        for (double value : series.getValues()) {
            axis.includeValue(value);
        }
        return CommandExecutionResult.ok();
    }

    public List<String> getXAxisLabels() {
        return this.xAxisLabels;
    }

    public List<ChartSeries> getSeries() {
        return this.series;
    }

    public ChartAxis getYAxis() {
        return this.yAxis;
    }

    public ChartAxis getY2Axis() {
        return this.y2Axis;
    }

    public CommandExecutionResult setLegendPosition(LegendPosition position) {
        this.legendPosition = position;
        return CommandExecutionResult.ok();
    }

    public LegendPosition getLegendPosition() {
        return this.legendPosition;
    }

    public CommandExecutionResult setGridMode(GridMode mode) {
        this.xGridMode = mode;
        this.yGridMode = mode;
        return CommandExecutionResult.ok();
    }

    public CommandExecutionResult setXGridMode(GridMode mode) {
        this.xGridMode = mode;
        return CommandExecutionResult.ok();
    }

    public CommandExecutionResult setYGridMode(GridMode mode) {
        this.yGridMode = mode;
        return CommandExecutionResult.ok();
    }

    public GridMode getXGridMode() {
        return this.xGridMode;
    }

    public GridMode getYGridMode() {
        return this.yGridMode;
    }

    public CommandExecutionResult setStackMode(StackMode mode) {
        this.stackMode = mode;
        return CommandExecutionResult.ok();
    }

    public StackMode getStackMode() {
        return this.stackMode;
    }

    public CommandExecutionResult setOrientation(Orientation orientation) {
        this.orientation = orientation;
        return CommandExecutionResult.ok();
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public CommandExecutionResult addAnnotation(ChartAnnotation annotation) {
        this.annotations.add(annotation);
        return CommandExecutionResult.ok();
    }

    public List<ChartAnnotation> getAnnotations() {
        return this.annotations;
    }

    public static enum LegendPosition {
        NONE,
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;

    }

    public static enum GridMode {
        OFF,
        MAJOR,
        BOTH;

    }

    public static enum StackMode {
        GROUPED,
        STACKED;

    }

    public static enum Orientation {
        VERTICAL,
        HORIZONTAL;

    }
}

