/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.chart.command;

import net.sourceforge.plantuml.chart.ChartDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandChartOrientation
extends SingleLineCommand2<ChartDiagram> {
    public CommandChartOrientation() {
        super(false, CommandChartOrientation.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandChartOrientation.class.getName(), RegexLeaf.start(), new RegexLeaf("orientation"), RegexLeaf.spaceOneOrMore(), new RegexLeaf(1, "ORIENTATION", "(vertical|horizontal)"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(ChartDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) {
        ChartDiagram.Orientation orientation;
        String orientationStr = arg.get("ORIENTATION", 0);
        switch (orientationStr.toLowerCase()) {
            case "vertical": {
                orientation = ChartDiagram.Orientation.VERTICAL;
                break;
            }
            case "horizontal": {
                orientation = ChartDiagram.Orientation.HORIZONTAL;
                break;
            }
            default: {
                return CommandExecutionResult.error("Invalid orientation: " + orientationStr);
            }
        }
        return diagram.setOrientation(orientation);
    }
}

