/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera;

import net.sf.mpxj.Duration;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;

public final class ExternalRelation {
    private Integer m_uniqueID;
    private final Integer m_externalTaskUniqueID;
    private final Task m_targetTask;
    private final RelationType m_type;
    private final Duration m_lag;
    private final boolean m_predecessor;

    public ExternalRelation(Integer sourceUniqueID, Task targetTask, RelationType type, Duration lag, boolean predecessor) {
        this.m_externalTaskUniqueID = sourceUniqueID;
        this.m_targetTask = targetTask;
        this.m_type = type == null ? RelationType.FINISH_START : type;
        this.m_lag = lag == null ? Duration.getInstance(0, TimeUnit.DAYS) : lag;
        this.m_predecessor = predecessor;
    }

    public RelationType getType() {
        return this.m_type;
    }

    public Duration getLag() {
        return this.m_lag;
    }

    public Integer externalTaskUniqueID() {
        return this.m_externalTaskUniqueID;
    }

    public Task getTargetTask() {
        return this.m_targetTask;
    }

    public Integer getUniqueID() {
        return this.m_uniqueID;
    }

    public void setUniqueID(Integer uniqueID) {
        this.m_uniqueID = uniqueID;
    }

    public boolean getPredecessor() {
        return this.m_predecessor;
    }

    public String toString() {
        return "[ExternalPredecessor " + this.m_externalTaskUniqueID + " -> " + this.m_targetTask + "]";
    }
}

