/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.bridge.Messages;
import io.sf.carte.echosvg.bridge.ScriptSecurity;
import io.sf.carte.echosvg.util.ParsedURL;
import java.net.URI;
import java.net.URISyntaxException;

public class DefaultScriptSecurity
implements ScriptSecurity {
    public static final String DATA_PROTOCOL = "data";
    public static final String ERROR_CANNOT_ACCESS_DOCUMENT_URL = "DefaultScriptSecurity.error.cannot.access.document.url";
    public static final String ERROR_SCRIPT_FROM_DIFFERENT_URL = "DefaultScriptSecurity.error.script.from.different.url";
    protected SecurityException se;

    @Override
    public void checkLoadScript() {
        if (this.se != null) {
            throw this.se;
        }
    }

    public DefaultScriptSecurity(String scriptType, ParsedURL scriptURL, ParsedURL docURL) {
        if (docURL == null || "application/java-archive".equals(scriptType)) {
            this.se = new SecurityException(Messages.formatMessage(ERROR_CANNOT_ACCESS_DOCUMENT_URL, new Object[]{scriptURL}));
        } else {
            String externalPath;
            String scriptHost;
            String docHost = docURL.getHost();
            String string = scriptHost = scriptURL != null ? scriptURL.getHost() : null;
            if (scriptHost == null && !DATA_PROTOCOL.equals(scriptURL.getProtocol()) && (externalPath = scriptURL.getPath()) != null) {
                try {
                    scriptHost = new URI(externalPath).getHost();
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!(docHost == scriptHost || docHost != null && docHost.equals(scriptHost) || docURL.equals((Object)scriptURL) || scriptURL != null && DATA_PROTOCOL.equals(scriptURL.getProtocol()))) {
                this.se = new SecurityException(Messages.formatMessage(ERROR_SCRIPT_FROM_DIFFERENT_URL, new Object[]{scriptURL}));
            }
        }
    }
}

