/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandSetter;
import io.sf.carte.doc.style.css.property.InheritValue;
import io.sf.carte.doc.style.css.property.KeywordValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import java.util.Locale;
import org.w3c.dom.DOMException;

class BoxShorthandSetter
extends ShorthandSetter {
    boolean nonmixed = true;

    BoxShorthandSetter(BaseCSSStyleDeclaration style, String shorthand) {
        super(style, shorthand);
    }

    boolean scanForInherited(LexicalUnit lunit) {
        while (lunit != null) {
            if (lunit.getLexicalUnitType() != LexicalUnit.LexicalType.INHERIT) {
                return false;
            }
            lunit = lunit.getNextLexicalUnit();
        }
        KeywordValue inherit = InheritValue.getValue().asSubproperty();
        this.setSubpropertiesToKeyword(inherit);
        this.initValueString();
        this.appendValueItemString(inherit);
        return true;
    }

    @Override
    public short assignSubproperties() {
        if (this.scanForInherited(this.currentValue)) {
            return 0;
        }
        String[] subparray = this.getShorthandSubproperties();
        short vcount = this.boxValueCount(this.currentValue);
        if (vcount == 0 || vcount > 4) {
            StyleDeclarationErrorHandler errHandler = this.styleDeclaration.getStyleDeclarationErrorHandler();
            if (errHandler != null && !this.hasCompatValue()) {
                errHandler.wrongSubpropertyCount(this.getShorthandName(), vcount);
            }
            return 2;
        }
        switch (vcount) {
            case 1: {
                StyleValue cssValue = this.createCSSValue(this.getShorthandName(), this.currentValue);
                for (String property : subparray) {
                    this.setSubpropertyValue(property, cssValue);
                }
                break;
            }
            case 2: {
                StyleValue top = this.createCSSValue(subparray[0], this.currentValue);
                this.nextCurrentValue();
                StyleValue right_left = this.createCSSValue(subparray[1], this.currentValue);
                this.setSubpropertyValue(subparray[0], top);
                this.setSubpropertyValue(subparray[1], right_left);
                this.setSubpropertyValue(subparray[2], top);
                this.setSubpropertyValue(subparray[3], right_left);
                break;
            }
            case 3: {
                StyleValue top = this.createCSSValue(subparray[0], this.currentValue);
                this.nextCurrentValue();
                StyleValue right_left = this.createCSSValue(subparray[1], this.currentValue);
                this.nextCurrentValue();
                StyleValue bottom = this.createCSSValue(subparray[2], this.currentValue);
                this.setSubpropertyValue(subparray[0], top);
                this.setSubpropertyValue(subparray[1], right_left);
                this.setSubpropertyValue(subparray[2], bottom);
                this.setSubpropertyValue(subparray[3], right_left);
                break;
            }
            case 4: {
                for (String property : subparray) {
                    StyleValue cssValue = this.createCSSValue(property, this.currentValue);
                    this.setSubpropertyValue(property, cssValue);
                    this.nextCurrentValue();
                }
                break;
            }
        }
        if (!this.nonmixed) {
            this.initValueString();
        }
        return 0;
    }

    short boxValueCount(LexicalUnit topLevelUnit) {
        int valueCount = 0;
        for (LexicalUnit value = topLevelUnit; value != null; value = value.getNextLexicalUnit()) {
            if (this.isValueOfType(value)) {
                valueCount = (short)(valueCount + 1);
                continue;
            }
            LexicalUnit.LexicalType lutype = value.getLexicalUnitType();
            if (lutype == LexicalUnit.LexicalType.IDENT) {
                String sv = value.getStringValue();
                String lcsv = sv.toLowerCase(Locale.ROOT).intern();
                if (this.isIdentifierValue(lcsv)) {
                    valueCount = (short)(valueCount + 1);
                    continue;
                }
            } else if (lutype == LexicalUnit.LexicalType.INHERIT || lutype == LexicalUnit.LexicalType.INITIAL || lutype == LexicalUnit.LexicalType.UNSET || lutype == LexicalUnit.LexicalType.REVERT) {
                this.nonmixed = false;
                valueCount = (short)(valueCount + 1);
                continue;
            }
            valueCount = 5;
            break;
        }
        if (!this.nonmixed && valueCount == 1) {
            this.nonmixed = true;
        }
        return (short)valueCount;
    }

    boolean isValueOfType(LexicalUnit value) {
        return ValueFactory.isLengthPercentageSACUnit(value);
    }

    boolean isIdentifierValue(String lcIdent) {
        return "auto".equals(lcIdent);
    }

    @Override
    protected StyleValue createCSSValue(String propertyName, LexicalUnit lunit) throws DOMException {
        return this.createCSSValue(propertyName, lunit, this.nonmixed);
    }

    @Override
    protected void setSubpropertyValue(String subproperty, StyleValue cssValue) {
        this.styleDeclaration.setProperty(subproperty, cssValue, this.isPriorityImportant());
    }
}

