/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.plugin.file.spreadsheet.process;

import org.gephi.io.importer.api.ContainerLoader;
import org.gephi.io.importer.plugin.file.spreadsheet.process.AbstractImportProcess;
import org.gephi.io.importer.plugin.file.spreadsheet.process.SpreadsheetGeneralConfiguration;
import org.gephi.io.importer.plugin.file.spreadsheet.sheet.SheetParser;
import org.gephi.io.importer.plugin.file.spreadsheet.sheet.SheetRow;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;

public class ImportAdjacencyListProcess
extends AbstractImportProcess {
    public ImportAdjacencyListProcess(SpreadsheetGeneralConfiguration generalConfig, ContainerLoader container, ProgressTicket progressTicket, SheetParser parser) {
        super(generalConfig, container, progressTicket, parser);
    }

    @Override
    public boolean execute() {
        this.container.setFillLabelWithId(true);
        Progress.start((ProgressTicket)this.progressTicket);
        for (SheetRow row : this.parser) {
            if (this.cancel) break;
            int size = row.size();
            if (size <= 0) continue;
            String source = row.get(0);
            if (source != null) {
                for (int i = 1; i < size; ++i) {
                    String target = row.get(i);
                    if (target != null) {
                        this.addEdge(source.trim(), target.trim());
                        continue;
                    }
                    this.logError(this.getMessage("ImportAdjacencyListProcess.error.missingTarget", i));
                }
                continue;
            }
            this.logError(this.getMessage("ImportAdjacencyListProcess.error.missingSource"));
        }
        Progress.finish((ProgressTicket)this.progressTicket);
        return !this.cancel;
    }

    @Override
    protected void addColumn(String name, Class type) {
    }
}

