/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.filesleuth.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import tim.prune.I18nManager;
import tim.prune.data.Coordinate;
import tim.prune.data.DataPoint;
import tim.prune.data.Unit;
import tim.prune.data.UnitSetLibrary;
import tim.prune.function.filesleuth.data.LocationFilter;
import tim.prune.function.filesleuth.gui.LocationFilterUser;
import tim.prune.gui.GuiGridLayout;
import tim.prune.gui.RadioButtonGroup;
import tim.prune.gui.WholeNumberField;

public class LocationFilterEditor
extends JDialog {
    private final LocationFilterUser _parent;
    private DataPoint _selectedPoint;
    private JRadioButton _noFilterRadio = null;
    private JRadioButton _pointFilterRadio = null;
    private JComboBox<String> _unitsDropdown = null;
    private WholeNumberField _distanceField = null;
    private JTextField _pointField = null;
    private JButton _okButton = null;

    public LocationFilterEditor(JDialog jDialog, LocationFilterUser locationFilterUser) {
        super(jDialog, I18nManager.getText("dialog.findfile.locationfilter"), true);
        this._parent = locationFilterUser;
        this.setLocationRelativeTo(jDialog);
        this.setDefaultCloseOperation(2);
        this.getContentPane().add(this.makeDialogComponents());
        this.pack();
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 10));
        jPanel.add((Component)new JLabel(I18nManager.getText("dialog.locationfilter.desc")), "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        GuiGridLayout guiGridLayout = new GuiGridLayout(jPanel2, new double[]{0.5, 1.0}, new boolean[2]);
        this._noFilterRadio = new JRadioButton(I18nManager.getText("dialog.locationfilter.nofilter"));
        this._noFilterRadio.setSelected(true);
        this._pointFilterRadio = new JRadioButton(String.valueOf(I18nManager.getText("dialog.locationfilter.distance")) + ": ");
        new RadioButtonGroup(this._noFilterRadio, this._pointFilterRadio);
        this._noFilterRadio.addItemListener(itemEvent -> this.preview());
        this._pointFilterRadio.addItemListener(itemEvent -> this.preview());
        guiGridLayout.add(this._noFilterRadio);
        guiGridLayout.nextRow();
        guiGridLayout.add(this._pointFilterRadio);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout());
        this._distanceField = new WholeNumberField(3);
        this._distanceField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                super.keyReleased(keyEvent);
                LocationFilterEditor.this._pointFilterRadio.setSelected(true);
                LocationFilterEditor.this.preview();
            }
        });
        jPanel3.add(this._distanceField);
        String[] stringArray = new String[]{I18nManager.getText("units.kilometres"), I18nManager.getText("units.metres"), I18nManager.getText("units.miles")};
        this._unitsDropdown = new JComboBox<String>(stringArray);
        jPanel3.add(this._unitsDropdown);
        guiGridLayout.add(jPanel3);
        guiGridLayout.add(new JLabel(""));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout());
        jPanel4.add(new JLabel(I18nManager.getText("dialog.locationfilter.frompoint")));
        this._pointField = new JTextField(15);
        this._pointField.setEditable(false);
        jPanel4.add(this._pointField);
        guiGridLayout.add(jPanel4);
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        ActionListener actionListener = actionEvent -> this.finish();
        this._okButton.addActionListener(actionListener);
        this._okButton.setEnabled(false);
        jPanel5.add(this._okButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(actionEvent -> this.dispose());
        jPanel5.add(jButton);
        jPanel.add((Component)jPanel5, "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        return jPanel;
    }

    public void show(LocationFilter locationFilter, DataPoint dataPoint) {
        this._selectedPoint = dataPoint;
        boolean bl = locationFilter != null && dataPoint != null;
        this._noFilterRadio.setSelected(!bl);
        this._pointFilterRadio.setSelected(bl);
        this._pointField.setText(LocationFilterEditor.describePoint(dataPoint));
        this.preview();
        this.setVisible(true);
    }

    private void preview() {
        boolean bl = this._selectedPoint != null;
        this._pointFilterRadio.setEnabled(bl);
        this._distanceField.setEnabled(bl);
        this._unitsDropdown.setEnabled(bl);
        this._pointField.setEnabled(bl);
        if (!bl) {
            this._noFilterRadio.setSelected(true);
        }
        boolean bl2 = this._noFilterRadio.isSelected() || bl && this._distanceField.getValue() > 0;
        this._okButton.setEnabled(bl2);
    }

    private LocationFilter getFilter() {
        if (this._noFilterRadio.isSelected() || this._selectedPoint == null) {
            return null;
        }
        Unit[] unitArray = new Unit[]{UnitSetLibrary.UNITS_KILOMETRES, UnitSetLibrary.UNITS_METRES, UnitSetLibrary.UNITS_MILES};
        Unit unit = unitArray[this._unitsDropdown.getSelectedIndex()];
        return new LocationFilter(this._selectedPoint, LocationFilterEditor.describePoint(this._selectedPoint), this._distanceField.getValue(), unit);
    }

    private void finish() {
        this._parent.updateLocationFilter(this.getFilter());
        this.dispose();
    }

    static String describePoint(DataPoint dataPoint) {
        if (dataPoint == null) {
            return "";
        }
        if (dataPoint.isWaypoint()) {
            return dataPoint.getWaypointName();
        }
        return String.valueOf(dataPoint.getLatitude().output(Coordinate.Format.DEG, 3)) + ", " + dataPoint.getLongitude().output(Coordinate.Format.DEG, 3);
    }
}

