/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui;

import java.awt.Toolkit;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import tim.prune.App;
import tim.prune.DataSubscriber;
import tim.prune.FunctionLibrary;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.config.Config;
import tim.prune.data.AudioClip;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.GeocacheCode;
import tim.prune.data.Photo;
import tim.prune.data.RecentFile;
import tim.prune.data.RecentFileList;
import tim.prune.data.Selection;
import tim.prune.data.Track;
import tim.prune.data.TrackInfo;
import tim.prune.function.AverageSelection;
import tim.prune.function.ChooseSingleParameter;
import tim.prune.function.CutAndMoveFunction;
import tim.prune.function.DeleteCurrentPoint;
import tim.prune.function.InterpolateTimestamps;
import tim.prune.function.PasteCoordinateList;
import tim.prune.function.PasteCoordinates;
import tim.prune.function.PlusCodeFunction;
import tim.prune.function.ProjectRange;
import tim.prune.function.ReverseSelectedRange;
import tim.prune.function.SelectExtremePoint;
import tim.prune.function.browser.OpenCachePageFunction;
import tim.prune.function.browser.UrlGenerator;
import tim.prune.function.browser.WebMapFunction;
import tim.prune.function.comparesegments.CompareSegmentsFunction;
import tim.prune.function.edit.PointEditor;
import tim.prune.function.filesleuth.StartFindFilesFunction;
import tim.prune.function.search.SearchOpenCachingDeFunction;
import tim.prune.function.segments.MergeSegmentsFunction;
import tim.prune.function.settings.SaveConfig;
import tim.prune.function.srtm.ConfigureSrtmSources;
import tim.prune.gui.FunctionLauncher;
import tim.prune.gui.RecentFileTrigger;
import tim.prune.threedee.WindowFactory;

public class MenuManager
implements DataSubscriber {
    private final App _app;
    private final Track _track;
    private final Selection _selection;
    private final boolean _threeDAvailable;
    private JMenuItem _sendGpsItem = null;
    private JMenuItem _saveItem = null;
    private JMenuItem _exportGpxItem = null;
    private JMenuItem _exportKmlItem = null;
    private JMenuItem _exportPovItem = null;
    private JMenuItem _exportImageItem = null;
    private JMenu _recentFileMenu = null;
    private JMenuItem _undoItem = null;
    private JMenuItem _clearUndoItem = null;
    private JMenuItem _redoItem = null;
    private JMenuItem _editPointItem = null;
    private JMenuItem _editWaypointNameItem = null;
    private JMenuItem _togglePointSegmentItem = null;
    private JMenuItem _deletePointItem = null;
    private JMenuItem _truncatePointCoordsItem = null;
    private JMenuItem _deleteRangeItem = null;
    private JMenuItem _cropTrackItem = null;
    private JMenuItem _compressItem = null;
    private JMenuItem _markRectangleInsideItem = null;
    private JMenuItem _markRectangleOutsideItem = null;
    private JMenuItem _deleteMarkedPointsItem = null;
    private JMenuItem _deleteByDateItem = null;
    private JMenuItem _interpolateItem = null;
    private JMenuItem _interpolateTimestampsItem = null;
    private JMenuItem _averageItem = null;
    private JMenuItem _selectAllItem = null;
    private JMenuItem _selectNoneItem = null;
    private JMenuItem _selectSegmentItem = null;
    private JMenuItem _selectStartItem = null;
    private JMenuItem _selectEndItem = null;
    private JMenuItem _findWaypointItem = null;
    private JMenu _gotoPointMenu = null;
    private JMenuItem _highestPointItem = null;
    private JMenuItem _lowestPointItem = null;
    private JMenuItem _fastestPointItem = null;
    private JMenuItem _duplicatePointItem = null;
    private JMenuItem _projectPointItem = null;
    private JMenuItem _projectCircleItem = null;
    private JMenuItem _reverseItem = null;
    private JMenuItem _addTimeOffsetItem = null;
    private JMenuItem _addAltitudeOffsetItem = null;
    private JMenuItem _projectRangeItem = null;
    private JMenuItem _mergeSegmentsItem = null;
    private JMenuItem _rearrangeWaypointsItem = null;
    private JMenuItem _dedupeWaypointsItem = null;
    private JMenuItem _splitSegmentsItem = null;
    private JMenuItem _sewSegmentsItem = null;
    private JMenuItem _createMarkerWaypointsItem = null;
    private JMenuItem _cutAndMoveItem = null;
    private JMenuItem _deleteFieldValuesItem = null;
    private JCheckBoxMenuItem _mapCheckbox = null;
    private JMenuItem _show3dItem = null;
    private JMenu _browserMapMenu = null;
    private JMenuItem _routingGraphHopperItem = null;
    private JMenuItem _chartItem = null;
    private JMenuItem _lookupSrtmItem = null;
    private JMenuItem _nearbyWikipediaItem = null;
    private JMenuItem _nearbyOsmPoiItem = null;
    private JMenuItem _showPeakfinderItem = null;
    private JMenuItem _showGeohackItem = null;
    private JMenuItem _searchOpencachingDeItem = null;
    private JMenuItem _openCachePageItem = null;
    private JMenuItem _downloadOsmItem = null;
    private JMenuItem _getWeatherItem = null;
    private JMenuItem _distanceItem = null;
    private JMenuItem _viewFullDetailsItem = null;
    private JMenuItem _estimateTimeItem = null;
    private JMenuItem _learnEstimationParams = null;
    private JMenuItem _compareSegmentsItem = null;
    private JMenuItem _autoplayTrack = null;
    private JMenuItem _saveExifItem = null;
    private JMenuItem _photoPopupItem = null;
    private JMenuItem _selectNoPhotoItem = null;
    private JMenuItem _connectPhotoItem = null;
    private JMenuItem _removePhotoItem = null;
    private JMenuItem _disconnectPhotoItem = null;
    private JMenuItem _correlatePhotosItem = null;
    private JMenuItem _rearrangePhotosItem = null;
    private JMenuItem _rotatePhotoLeft = null;
    private JMenuItem _rotatePhotoRight = null;
    private JMenuItem _ignoreExifThumb = null;
    private JMenuItem _connectAudioItem = null;
    private JMenuItem _disconnectAudioItem = null;
    private JMenuItem _removeAudioItem = null;
    private JMenuItem _correlateAudiosItem = null;
    private JMenuItem _selectNoAudioItem = null;
    private JCheckBoxMenuItem _onlineCheckbox = null;
    private JCheckBoxMenuItem _autosaveSettingsCheckbox = null;
    private JButton _saveButton = null;
    private JButton _undoButton = null;
    private JButton _redoButton = null;
    private JButton _editPointButton = null;
    private JButton _viewInfoButton = null;
    private JButton _deletePointButton = null;
    private JButton _deleteRangeButton = null;
    private JButton _cutAndMoveButton = null;
    private JButton _selectStartButton = null;
    private JButton _selectEndButton = null;
    private JButton _connectButton = null;
    private JButton _threeDeeButton = null;
    private static final int[] KEY_EVENTS = new int[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90};

    public MenuManager(App app, TrackInfo trackInfo) {
        this._app = app;
        this._track = trackInfo.getTrack();
        this._selection = trackInfo.getSelection();
        this._threeDAvailable = WindowFactory.isJava3dEnabled();
    }

    private Config getConfig() {
        return this._app.getConfig();
    }

    public JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(I18nManager.getText("menu.file"));
        MenuManager.setAltKey(jMenu, "altkey.menu.file");
        JMenuItem jMenuItem = new JMenuItem(I18nManager.getText("function.open"));
        MenuManager.setShortcut(jMenuItem, "shortcut.menu.file.open");
        jMenuItem.addActionListener(actionEvent -> this._app.openFile());
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_IMPORTBABEL);
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem(I18nManager.getText("menu.file.addphotos"));
        jMenuItem3.addActionListener(actionEvent -> this._app.addPhotos());
        jMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_LOAD_AUDIO);
        jMenu.add(jMenuItem4);
        JMenuItem jMenuItem5 = MenuManager.makeMenuItem(new StartFindFilesFunction(this._app));
        jMenu.add(jMenuItem5);
        this._recentFileMenu = new JMenu(I18nManager.getText("menu.file.recentfiles"));
        this._recentFileMenu.setEnabled(false);
        jMenu.add(this._recentFileMenu);
        jMenu.addSeparator();
        JMenuItem jMenuItem6 = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_GPSLOAD);
        MenuManager.setShortcut(jMenuItem6, "shortcut.menu.file.load");
        jMenu.add(jMenuItem6);
        this._sendGpsItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_GPSSAVE, false);
        jMenu.add(this._sendGpsItem);
        jMenu.addSeparator();
        this._saveItem = new JMenuItem(I18nManager.getText("menu.file.save"), 83);
        MenuManager.setShortcut(this._saveItem, "shortcut.menu.file.save");
        this._saveItem.addActionListener(actionEvent -> this._app.saveFile());
        this._saveItem.setEnabled(false);
        jMenu.add(this._saveItem);
        this._exportGpxItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_GPXEXPORT, false);
        jMenu.add(this._exportGpxItem);
        this._exportKmlItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_KMLEXPORT, false);
        jMenu.add(this._exportKmlItem);
        this._exportPovItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_POVEXPORT, false);
        jMenu.add(this._exportPovItem);
        this._exportImageItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_IMAGEEXPORT, false);
        jMenu.add(this._exportImageItem);
        jMenu.addSeparator();
        JMenuItem jMenuItem7 = new JMenuItem(I18nManager.getText("menu.file.exit"));
        jMenuItem7.addActionListener(actionEvent -> this._app.exit());
        jMenu.add(jMenuItem7);
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu(I18nManager.getText("menu.online"));
        MenuManager.setAltKey(jMenu2, "altkey.menu.online");
        this._lookupSrtmItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_LOOKUP_SRTM, false);
        jMenu2.add(this._lookupSrtmItem);
        JMenuItem jMenuItem8 = MenuManager.makeMenuItem(new ConfigureSrtmSources(this._app), true);
        jMenu2.add(jMenuItem8);
        jMenu2.addSeparator();
        this._browserMapMenu = new JMenu(I18nManager.getText("menu.view.browser"));
        this._browserMapMenu.setEnabled(false);
        JMenuItem jMenuItem9 = MenuManager.makeMenuItem(new WebMapFunction(this._app, UrlGenerator.WebService.MAP_SOURCE_GOOGLE, "menu.view.browser.google"));
        this._browserMapMenu.add(jMenuItem9);
        JMenuItem jMenuItem10 = MenuManager.makeMenuItem(new WebMapFunction(this._app, UrlGenerator.WebService.MAP_SOURCE_OSM, "menu.view.browser.openstreetmap"));
        this._browserMapMenu.add(jMenuItem10);
        JMenuItem jMenuItem11 = MenuManager.makeMenuItem(new WebMapFunction(this._app, UrlGenerator.WebService.MAP_SOURCE_MAPQUEST, "menu.view.browser.mapquest"));
        this._browserMapMenu.add(jMenuItem11);
        JMenuItem jMenuItem12 = MenuManager.makeMenuItem(new WebMapFunction(this._app, UrlGenerator.WebService.MAP_SOURCE_BING, "menu.view.browser.bing"));
        this._browserMapMenu.add(jMenuItem12);
        JMenuItem jMenuItem13 = MenuManager.makeMenuItem(new WebMapFunction(this._app, UrlGenerator.WebService.MAP_SOURCE_MAPILLARY, "menu.view.browser.mapillary"));
        this._browserMapMenu.add(jMenuItem13);
        this._routingGraphHopperItem = MenuManager.makeMenuItem(new WebMapFunction(this._app, UrlGenerator.WebService.MAP_SOURCE_GRAPHHOPPER, "menu.view.browser.graphhopper"));
        this._browserMapMenu.add(this._routingGraphHopperItem);
        jMenu2.add(this._browserMapMenu);
        this._nearbyWikipediaItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_NEARBY_WIKIPEDIA, false);
        jMenu2.add(this._nearbyWikipediaItem);
        JMenuItem jMenuItem14 = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_SEARCH_WIKIPEDIA);
        jMenu2.add(jMenuItem14);
        this._nearbyOsmPoiItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_SEARCH_OSMPOIS);
        jMenu2.add(this._nearbyOsmPoiItem);
        this._showPeakfinderItem = MenuManager.makeMenuItem(new WebMapFunction(this._app, UrlGenerator.WebService.MAP_SOURCE_PEAKFINDER, "webservice.peakfinder"), false);
        jMenu2.add(this._showPeakfinderItem);
        this._showGeohackItem = MenuManager.makeMenuItem(new WebMapFunction(this._app, UrlGenerator.WebService.MAP_SOURCE_GEOHACK, "webservice.geohack"), false);
        jMenu2.add(this._showGeohackItem);
        jMenu2.addSeparator();
        this._searchOpencachingDeItem = MenuManager.makeMenuItem(new SearchOpenCachingDeFunction(this._app), false);
        jMenu2.add(this._searchOpencachingDeItem);
        this._openCachePageItem = MenuManager.makeMenuItem(new OpenCachePageFunction(this._app), false);
        jMenu2.add(this._openCachePageItem);
        this._downloadOsmItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_DOWNLOAD_OSM, false);
        jMenu2.add(this._downloadOsmItem);
        this._getWeatherItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_GET_WEATHER_FORECAST, false);
        jMenu2.add(this._getWeatherItem);
        jMenuBar.add(jMenu2);
        JMenu jMenu3 = new JMenu(I18nManager.getText("menu.track"));
        MenuManager.setAltKey(jMenu3, "altkey.menu.track");
        this._undoItem = new JMenuItem(I18nManager.getText("menu.track.undo"));
        MenuManager.setShortcut(this._undoItem, "shortcut.menu.track.undo");
        this._undoItem.addActionListener(actionEvent -> this._app.beginUndo());
        this._undoItem.setEnabled(false);
        jMenu3.add(this._undoItem);
        this._clearUndoItem = new JMenuItem(I18nManager.getText("menu.track.clearundo"));
        this._clearUndoItem.addActionListener(actionEvent -> this._app.clearUndo());
        this._clearUndoItem.setEnabled(false);
        jMenu3.add(this._clearUndoItem);
        this._redoItem = new JMenuItem(I18nManager.getText("menu.track.redo"));
        this._redoItem.addActionListener(actionEvent -> this._app.beginRedo());
        this._redoItem.setEnabled(false);
        jMenu3.add(this._redoItem);
        jMenu3.addSeparator();
        this._compressItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_COMPRESS, false);
        MenuManager.setShortcut(this._compressItem, "shortcut.menu.track.compress");
        jMenu3.add(this._compressItem);
        this._markRectangleInsideItem = new JMenuItem(I18nManager.getText("menu.track.markinsiderectangle"));
        this._markRectangleInsideItem.addActionListener(actionEvent -> {
            this._app.setCurrentMode(App.AppMode.DRAWRECT_INSIDE);
            UpdateMessageBroker.informSubscribers();
        });
        this._markRectangleInsideItem.setEnabled(false);
        jMenu3.add(this._markRectangleInsideItem);
        this._markRectangleOutsideItem = new JMenuItem(I18nManager.getText("menu.track.markoutsiderectangle"));
        this._markRectangleOutsideItem.addActionListener(actionEvent -> {
            this._app.setCurrentMode(App.AppMode.DRAWRECT_OUTSIDE);
            UpdateMessageBroker.informSubscribers();
        });
        this._markRectangleOutsideItem.setEnabled(false);
        jMenu3.add(this._markRectangleOutsideItem);
        this._deleteMarkedPointsItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_DELETE_MARKED_POINTS, false);
        jMenu3.add(this._deleteMarkedPointsItem);
        this._deleteByDateItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_DELETE_BY_DATE, false);
        jMenu3.add(this._deleteByDateItem);
        jMenu3.addSeparator();
        this._rearrangeWaypointsItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_REARRANGE_WAYPOINTS, false);
        jMenu3.add(this._rearrangeWaypointsItem);
        this._dedupeWaypointsItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_DEDUPE_WAYPOINTS, false);
        jMenu3.add(this._dedupeWaypointsItem);
        this._splitSegmentsItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_SPLIT_SEGMENTS, false);
        jMenu3.add(this._splitSegmentsItem);
        this._sewSegmentsItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_SEW_SEGMENTS, false);
        jMenu3.add(this._sewSegmentsItem);
        this._createMarkerWaypointsItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_CREATE_MARKER_WAYPOINTS, false);
        jMenu3.add(this._createMarkerWaypointsItem);
        jMenu3.addSeparator();
        this._learnEstimationParams = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_LEARN_ESTIMATION_PARAMS, false);
        jMenu3.add(this._learnEstimationParams);
        jMenuBar.add(jMenu3);
        JMenu jMenu4 = new JMenu(I18nManager.getText("menu.range"));
        MenuManager.setAltKey(jMenu4, "altkey.menu.range");
        this._selectAllItem = new JMenuItem(I18nManager.getText("menu.range.all"));
        MenuManager.setShortcut(this._selectAllItem, "shortcut.menu.range.all");
        this._selectAllItem.setEnabled(false);
        this._selectAllItem.addActionListener(actionEvent -> this._selection.selectRange(0, this._track.getNumPoints() - 1));
        jMenu4.add(this._selectAllItem);
        this._selectNoneItem = new JMenuItem(I18nManager.getText("menu.range.none"));
        this._selectNoneItem.setEnabled(false);
        this._selectNoneItem.addActionListener(actionEvent -> this._app.selectNone());
        jMenu4.add(this._selectNoneItem);
        this._selectSegmentItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_SELECT_SEGMENT);
        jMenu4.add(this._selectSegmentItem);
        jMenu4.addSeparator();
        this._selectStartItem = new JMenuItem(I18nManager.getText("menu.range.start"));
        this._selectStartItem.setEnabled(false);
        this._selectStartItem.addActionListener(actionEvent -> this._selection.selectRangeStart());
        jMenu4.add(this._selectStartItem);
        this._selectEndItem = new JMenuItem(I18nManager.getText("menu.range.end"));
        this._selectEndItem.setEnabled(false);
        this._selectEndItem.addActionListener(actionEvent -> this._selection.selectRangeEnd());
        jMenu4.add(this._selectEndItem);
        jMenu4.addSeparator();
        this._deleteRangeItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_DELETE_RANGE, false);
        jMenu4.add(this._deleteRangeItem);
        this._cropTrackItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_CROP_TRACK, false);
        jMenu4.add(this._cropTrackItem);
        this._reverseItem = MenuManager.makeMenuItem(new ReverseSelectedRange(this._app), false);
        jMenu4.add(this._reverseItem);
        this._addTimeOffsetItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_ADD_TIME_OFFSET, false);
        jMenu4.add(this._addTimeOffsetItem);
        this._addAltitudeOffsetItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_ADD_ALTITUDE_OFFSET, false);
        jMenu4.add(this._addAltitudeOffsetItem);
        this._projectRangeItem = MenuManager.makeMenuItem(new ProjectRange(this._app), false);
        jMenu4.add(this._projectRangeItem);
        this._mergeSegmentsItem = MenuManager.makeMenuItem(new MergeSegmentsFunction(this._app), false);
        jMenu4.add(this._mergeSegmentsItem);
        this._deleteFieldValuesItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_DELETE_FIELD_VALUES, false);
        jMenu4.add(this._deleteFieldValuesItem);
        this._interpolateTimestampsItem = MenuManager.makeMenuItem(new InterpolateTimestamps(this._app), false);
        jMenu4.add(this._interpolateTimestampsItem);
        jMenu4.addSeparator();
        this._interpolateItem = MenuManager.makeMenuItem(new ChooseSingleParameter(this._app, FunctionLibrary.FUNCTION_INTERPOLATE), false);
        jMenu4.add(this._interpolateItem);
        this._averageItem = MenuManager.makeMenuItem(new AverageSelection(this._app), false);
        this._averageItem.setEnabled(false);
        jMenu4.add(this._averageItem);
        this._cutAndMoveItem = MenuManager.makeMenuItem(new CutAndMoveFunction(this._app), false);
        jMenu4.add(this._cutAndMoveItem);
        jMenuBar.add(jMenu4);
        JMenu jMenu5 = new JMenu(I18nManager.getText("menu.point"));
        MenuManager.setAltKey(jMenu5, "altkey.menu.point");
        this._editPointItem = MenuManager.makeMenuItem(new PointEditor(this._app), false);
        MenuManager.setShortcut(this._editPointItem, "shortcut.menu.point.edit");
        jMenu5.add(this._editPointItem);
        this._editWaypointNameItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_EDIT_WAYPOINT_NAME, false);
        jMenu5.add(this._editWaypointNameItem);
        this._togglePointSegmentItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_TOGGLE_POINT_SEGMENT, false);
        jMenu5.add(this._togglePointSegmentItem);
        this._deletePointItem = MenuManager.makeMenuItem(new DeleteCurrentPoint(this._app), false);
        this._deletePointItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        jMenu5.add(this._deletePointItem);
        this._truncatePointCoordsItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_TRUNCATE_POINT_COORDS, false);
        jMenu5.add(this._truncatePointCoordsItem);
        jMenu5.addSeparator();
        this._findWaypointItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_FIND_WAYPOINT, false);
        jMenu5.add(this._findWaypointItem);
        this._gotoPointMenu = new JMenu(I18nManager.getText("menu.point.goto"));
        this._highestPointItem = MenuManager.makeMenuItem(new SelectExtremePoint(this._app, SelectExtremePoint.Extreme.HIGHEST), false);
        this._gotoPointMenu.add(this._highestPointItem);
        this._lowestPointItem = MenuManager.makeMenuItem(new SelectExtremePoint(this._app, SelectExtremePoint.Extreme.LOWEST), false);
        this._gotoPointMenu.add(this._lowestPointItem);
        this._fastestPointItem = MenuManager.makeMenuItem(new SelectExtremePoint(this._app, SelectExtremePoint.Extreme.FASTEST), false);
        this._gotoPointMenu.add(this._fastestPointItem);
        jMenu5.add(this._gotoPointMenu);
        this._duplicatePointItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_DUPLICATE_POINT, false);
        jMenu5.add(this._duplicatePointItem);
        this._projectPointItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_PROJECT_POINT, false);
        jMenu5.add(this._projectPointItem);
        this._projectCircleItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_PROJECT_CIRCLE, false);
        jMenu5.add(this._projectCircleItem);
        jMenu5.addSeparator();
        JMenuItem jMenuItem15 = MenuManager.makeMenuItem(new PasteCoordinates(this._app));
        jMenu5.add(jMenuItem15);
        JMenuItem jMenuItem16 = MenuManager.makeMenuItem(new PasteCoordinateList(this._app));
        jMenu5.add(jMenuItem16);
        JMenuItem jMenuItem17 = MenuManager.makeMenuItem(new PlusCodeFunction(this._app));
        jMenu5.add(jMenuItem17);
        jMenuBar.add(jMenu5);
        JMenu jMenu6 = new JMenu(I18nManager.getText("menu.view"));
        MenuManager.setAltKey(jMenu6, "altkey.menu.view");
        this._mapCheckbox = new JCheckBoxMenuItem(I18nManager.getText("menu.map.showmap"), false);
        this._mapCheckbox.addActionListener(actionEvent -> {
            this.getConfig().setConfigBoolean("prune.showmap", this._mapCheckbox.isSelected());
            UpdateMessageBroker.informSubscribers(128);
        });
        jMenu6.add(this._mapCheckbox);
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(I18nManager.getText("menu.view.showsidebars"));
        jCheckBoxMenuItem.setSelected(true);
        jCheckBoxMenuItem.addActionListener(actionEvent -> this._app.toggleSidebars());
        jCheckBoxMenuItem.setAccelerator(KeyStroke.getKeyStroke(122, 0));
        jMenu6.add(jCheckBoxMenuItem);
        this._show3dItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_3D_VIEW, false);
        jMenu6.add(this._show3dItem);
        this._chartItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_CHARTS, false);
        jMenu6.add(this._chartItem);
        jMenu6.addSeparator();
        this._distanceItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_DISTANCES, false);
        jMenu6.add(this._distanceItem);
        this._viewFullDetailsItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_FULL_DETAILS, false);
        MenuManager.setShortcut(this._viewFullDetailsItem, "shortcut.menu.view.details");
        jMenu6.add(this._viewFullDetailsItem);
        this._estimateTimeItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_ESTIMATE_TIME, false);
        jMenu6.add(this._estimateTimeItem);
        this._compareSegmentsItem = MenuManager.makeMenuItem(new CompareSegmentsFunction(this._app), false);
        jMenu6.add(this._compareSegmentsItem);
        jMenu6.addSeparator();
        this._autoplayTrack = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_AUTOPLAY_TRACK, false);
        jMenu6.add(this._autoplayTrack);
        jMenuBar.add(jMenu6);
        JMenu jMenu7 = new JMenu(I18nManager.getText("menu.photo"));
        MenuManager.setAltKey(jMenu7, "altkey.menu.photo");
        jMenuItem3 = new JMenuItem(I18nManager.getText("menu.file.addphotos"));
        jMenuItem3.addActionListener(actionEvent -> this._app.addPhotos());
        jMenu7.add(jMenuItem3);
        this._saveExifItem = new JMenuItem(I18nManager.getText("menu.photo.saveexif"));
        this._saveExifItem.addActionListener(actionEvent -> this._app.saveExif());
        this._saveExifItem.setEnabled(false);
        jMenu7.add(this._saveExifItem);
        this._selectNoPhotoItem = new JMenuItem(I18nManager.getText("menu.range.none"));
        this._selectNoPhotoItem.setEnabled(false);
        this._selectNoPhotoItem.addActionListener(actionEvent -> this._app.getTrackInfo().selectPhoto(-1));
        jMenu7.add(this._selectNoPhotoItem);
        jMenu7.addSeparator();
        this._connectPhotoItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_CONNECT_TO_POINT, false);
        jMenu7.add(this._connectPhotoItem);
        this._disconnectPhotoItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_DISCONNECT_PHOTO, false);
        jMenu7.add(this._disconnectPhotoItem);
        this._removePhotoItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_REMOVE_PHOTO, false);
        jMenu7.add(this._removePhotoItem);
        this._rotatePhotoLeft = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_ROTATE_PHOTO_LEFT, false);
        jMenu7.add(this._rotatePhotoLeft);
        this._rotatePhotoRight = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_ROTATE_PHOTO_RIGHT, false);
        jMenu7.add(this._rotatePhotoRight);
        this._photoPopupItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_PHOTO_POPUP, false);
        jMenu7.add(this._photoPopupItem);
        this._ignoreExifThumb = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_IGNORE_EXIF_THUMB, false);
        jMenu7.add(this._ignoreExifThumb);
        jMenu7.addSeparator();
        this._correlatePhotosItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_CORRELATE_PHOTOS, false);
        jMenu7.add(this._correlatePhotosItem);
        this._rearrangePhotosItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_REARRANGE_PHOTOS, false);
        jMenu7.add(this._rearrangePhotosItem);
        jMenuBar.add(jMenu7);
        JMenu jMenu8 = new JMenu(I18nManager.getText("menu.audio"));
        MenuManager.setAltKey(jMenu8, "altkey.menu.audio");
        jMenuItem4 = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_LOAD_AUDIO);
        jMenu8.add(jMenuItem4);
        this._selectNoAudioItem = new JMenuItem(I18nManager.getText("menu.range.none"));
        this._selectNoAudioItem.setEnabled(false);
        this._selectNoAudioItem.addActionListener(actionEvent -> this._app.getTrackInfo().selectAudio(-1));
        jMenu8.add(this._selectNoAudioItem);
        jMenu8.addSeparator();
        this._connectAudioItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_CONNECT_TO_POINT, false);
        jMenu8.add(this._connectAudioItem);
        this._disconnectAudioItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_DISCONNECT_AUDIO, false);
        jMenu8.add(this._disconnectAudioItem);
        this._removeAudioItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_REMOVE_AUDIO, false);
        jMenu8.add(this._removeAudioItem);
        jMenu8.addSeparator();
        this._correlateAudiosItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_CORRELATE_AUDIOS, false);
        jMenu8.add(this._correlateAudiosItem);
        jMenuBar.add(jMenu8);
        JMenu jMenu9 = new JMenu(I18nManager.getText("menu.settings"));
        MenuManager.setAltKey(jMenu9, "altkey.menu.settings");
        JMenuItem jMenuItem18 = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_SET_MAP_BG);
        jMenu9.add(jMenuItem18);
        this._onlineCheckbox = new JCheckBoxMenuItem(I18nManager.getText("menu.settings.onlinemode"));
        this._onlineCheckbox.setSelected(this.getConfig().getConfigBoolean("prune.onlinemode"));
        this._onlineCheckbox.addActionListener(actionEvent -> {
            boolean bl = this._onlineCheckbox.isSelected();
            this.getConfig().setConfigBoolean("prune.onlinemode", bl);
            if (bl) {
                UpdateMessageBroker.informSubscribers();
            }
        });
        jMenu9.add(this._onlineCheckbox);
        jMenu9.add(MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_SET_DISK_CACHE));
        jMenu9.addSeparator();
        jMenu9.add(MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_SET_PATHS));
        jMenu9.add(MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_SET_COLOURS));
        jMenu9.add(MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_SET_DISPLAY_SETTINGS));
        jMenu9.add(MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_SET_WAYPOINT_DISPLAY));
        jMenu9.add(MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_SET_LANGUAGE));
        jMenu9.add(MenuManager.makeMenuItem(new ChooseSingleParameter(this._app, FunctionLibrary.FUNCTION_SET_ALTITUDE_TOLERANCE)));
        jMenu9.add(MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_SET_TIMEZONE));
        jMenu9.addSeparator();
        jMenu9.add(MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_SAVECONFIG));
        this._autosaveSettingsCheckbox = new JCheckBoxMenuItem(I18nManager.getText("menu.settings.autosave"), false);
        this._autosaveSettingsCheckbox.setSelected(this.getConfig().getConfigBoolean("prune.autosavesettings"));
        this._autosaveSettingsCheckbox.addActionListener(actionEvent -> {
            boolean bl = this._autosaveSettingsCheckbox.isSelected();
            this.getConfig().setConfigBoolean("prune.autosavesettings", bl);
            new SaveConfig(this._app).autosaveSwitched(bl);
        });
        jMenu9.add(this._autosaveSettingsCheckbox);
        jMenuBar.add(jMenu9);
        JMenu jMenu10 = new JMenu(I18nManager.getText("menu.help"));
        MenuManager.setAltKey(jMenu10, "altkey.menu.help");
        JMenuItem jMenuItem19 = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_HELP);
        MenuManager.setShortcut(jMenuItem19, "shortcut.menu.help.help");
        jMenu10.add(jMenuItem19);
        jMenu10.add(MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_SHOW_KEYS));
        jMenu10.add(MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_ABOUT));
        jMenu10.add(MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_CHECK_VERSION));
        jMenuBar.add(jMenu10);
        return jMenuBar;
    }

    private static JMenuItem makeMenuItem(GenericFunction genericFunction, boolean bl) {
        JMenuItem jMenuItem = MenuManager.makeMenuItem(genericFunction);
        jMenuItem.setEnabled(bl);
        return jMenuItem;
    }

    private static JMenuItem makeMenuItem(GenericFunction genericFunction) {
        JMenuItem jMenuItem = new JMenuItem(genericFunction.getName());
        jMenuItem.addActionListener(new FunctionLauncher(genericFunction));
        return jMenuItem;
    }

    private static void setAltKey(JMenu jMenu, String string) {
        int n;
        String string2 = I18nManager.getText(string);
        if (string2 != null && string2.length() == 1 && (n = string2.charAt(0) - 65) >= 0 && n < 26) {
            jMenu.setMnemonic(KEY_EVENTS[n]);
        }
    }

    private static void setShortcut(JMenuItem jMenuItem, String string) {
        int n;
        String string2 = I18nManager.getText(string);
        if (string2 != null && string2.length() == 1 && (n = string2.charAt(0) - 65) >= 0 && n < 26) {
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(KEY_EVENTS[n], Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        }
    }

    public JToolBar createToolBar() {
        JToolBar jToolBar = new JToolBar();
        JButton jButton = this.makeToolbarButton("toolbar/import-file", "function.open", actionEvent -> this._app.openFile());
        jButton.setEnabled(true);
        jToolBar.add(jButton);
        JButton jButton2 = this.makeToolbarButton("toolbar/add-image", "menu.file.addphotos", actionEvent -> this._app.addPhotos());
        jButton2.setEnabled(true);
        jToolBar.add(jButton2);
        this._saveButton = this.makeToolbarButton("toolbar/export-file", "menu.file.export", actionEvent -> this.showExportMenu());
        jToolBar.add(this._saveButton);
        this._undoButton = this.makeToolbarButton("toolbar/undo", "menu.track.undo", actionEvent -> this._app.beginUndo());
        jToolBar.add(this._undoButton);
        this._redoButton = this.makeToolbarButton("toolbar/redo", "menu.track.redo", actionEvent -> this._app.beginRedo());
        jToolBar.add(this._redoButton);
        this._editPointButton = this.makeToolbarButton("toolbar/edit-details", new PointEditor(this._app));
        jToolBar.add(this._editPointButton);
        this._deletePointButton = this.makeToolbarButton("toolbar/delete-point", new DeleteCurrentPoint(this._app));
        jToolBar.add(this._deletePointButton);
        this._deleteRangeButton = this.makeToolbarButton("toolbar/delete-range", FunctionLibrary.FUNCTION_DELETE_RANGE);
        jToolBar.add(this._deleteRangeButton);
        this._cutAndMoveButton = this.makeToolbarButton("toolbar/cut-and-move", new CutAndMoveFunction(this._app));
        jToolBar.add(this._cutAndMoveButton);
        this._selectStartButton = this.makeToolbarButton("toolbar/set-range-start", "menu.range.start", actionEvent -> this._selection.selectRangeStart());
        jToolBar.add(this._selectStartButton);
        this._selectEndButton = this.makeToolbarButton("toolbar/set-range-end", "menu.range.end", actionEvent -> this._selection.selectRangeEnd());
        jToolBar.add(this._selectEndButton);
        this._viewInfoButton = this.makeToolbarButton("toolbar/view-info", FunctionLibrary.FUNCTION_FULL_DETAILS);
        jToolBar.add(this._viewInfoButton);
        this._connectButton = this.makeToolbarButton("toolbar/link", FunctionLibrary.FUNCTION_CONNECT_TO_POINT);
        jToolBar.add(this._connectButton);
        this._threeDeeButton = this.makeToolbarButton("toolbar/view-3d", FunctionLibrary.FUNCTION_3D_VIEW);
        jToolBar.add(this._threeDeeButton);
        jToolBar.setFloatable(false);
        return jToolBar;
    }

    private JButton makeToolbarButton(String string, GenericFunction genericFunction) {
        return this.makeToolbarButton(string, genericFunction.getNameKey(), actionEvent -> genericFunction.begin());
    }

    private JButton makeToolbarButton(String string, String string2, ActionListener actionListener) {
        JButton jButton = new JButton(this._app.getIconManager().getImageIcon(string));
        jButton.setEnabled(false);
        jButton.setBorder(BorderFactory.createEmptyBorder(3, 8, 3, 8));
        jButton.setBorder(BorderFactory.createEmptyBorder(3, 8, 3, 8));
        jButton.setToolTipText(I18nManager.getText(string2));
        jButton.addActionListener(actionListener);
        return jButton;
    }

    @Override
    public void dataUpdated(int n) {
        block6: {
            RecentFileList recentFileList;
            int n2;
            boolean bl = this._track != null && this._track.getNumPoints() > 0;
            boolean bl2 = bl && this._track.getNumPoints() > 1;
            this._sendGpsItem.setEnabled(bl);
            this._saveItem.setEnabled(bl);
            this._saveButton.setEnabled(bl);
            this._exportGpxItem.setEnabled(bl);
            this._exportKmlItem.setEnabled(bl);
            this._exportPovItem.setEnabled(bl2);
            this._exportImageItem.setEnabled(bl2);
            this._compressItem.setEnabled(bl);
            this._markRectangleInsideItem.setEnabled(bl);
            this._markRectangleOutsideItem.setEnabled(bl);
            this._deleteMarkedPointsItem.setEnabled(bl && this._app.getTrackInfo().hasPointsMarkedForDeletion());
            this._rearrangeWaypointsItem.setEnabled(bl && this._track.hasWaypoints() && this._track.getNumPoints() > 1);
            this._dedupeWaypointsItem.setEnabled(bl && this._track.hasWaypoints() && this._track.getNumPoints() > 1);
            this._viewFullDetailsItem.setEnabled(bl);
            this._viewInfoButton.setEnabled(bl);
            boolean bl3 = bl && this._track.hasTrackPoints() && this._track.getNumPoints() > 3;
            this._splitSegmentsItem.setEnabled(bl3);
            this._sewSegmentsItem.setEnabled(bl3);
            this._createMarkerWaypointsItem.setEnabled(bl3);
            this._compareSegmentsItem.setEnabled(bl3);
            this._selectAllItem.setEnabled(bl);
            this._selectNoneItem.setEnabled(bl);
            this._show3dItem.setEnabled(bl2 && this._threeDAvailable);
            this._threeDeeButton.setEnabled(bl2 && this._threeDAvailable);
            this._chartItem.setEnabled(bl);
            this._browserMapMenu.setEnabled(bl);
            this._distanceItem.setEnabled(bl);
            this._autoplayTrack.setEnabled(bl && this._track.getNumPoints() > 3);
            this._lookupSrtmItem.setEnabled(bl);
            this._nearbyWikipediaItem.setEnabled(bl);
            this._nearbyOsmPoiItem.setEnabled(bl);
            this._downloadOsmItem.setEnabled(bl);
            this._getWeatherItem.setEnabled(bl);
            this._findWaypointItem.setEnabled(bl && this._track.hasWaypoints());
            this._gotoPointMenu.setEnabled(bl);
            this._highestPointItem.setEnabled(bl2 && this._track.hasAltitudeData());
            this._lowestPointItem.setEnabled(bl2 && this._track.hasAltitudeData());
            this._deleteByDateItem.setEnabled(bl && this._track.hasData(Field.TIMESTAMP));
            this._fastestPointItem.setEnabled(bl2 && (this._track.hasData(Field.TIMESTAMP) || this._track.hasData(Field.SPEED)));
            boolean bl4 = !this._app.getUndoStack().isEmpty();
            this._undoItem.setEnabled(bl4);
            this._undoButton.setEnabled(bl4);
            this._clearUndoItem.setEnabled(bl4);
            boolean bl5 = !this._app.getRedoStack().isEmpty();
            this._redoButton.setEnabled(bl5);
            this._redoItem.setEnabled(bl5);
            DataPoint dataPoint = this._app.getTrackInfo().getCurrentPoint();
            boolean bl6 = dataPoint != null;
            this._editPointItem.setEnabled(bl6);
            this._editPointButton.setEnabled(bl6);
            this._editWaypointNameItem.setEnabled(bl6);
            this._togglePointSegmentItem.setEnabled(bl6 && !dataPoint.isWaypoint() && this._app.getTrackInfo().getSelection().getCurrentPointIndex() > 0);
            this._deletePointItem.setEnabled(bl6);
            this._deletePointButton.setEnabled(bl6);
            this._truncatePointCoordsItem.setEnabled(bl6);
            this._selectStartItem.setEnabled(bl6);
            this._selectStartButton.setEnabled(bl6);
            this._selectEndItem.setEnabled(bl6);
            this._selectEndButton.setEnabled(bl6);
            this._duplicatePointItem.setEnabled(bl6);
            this._projectPointItem.setEnabled(bl6);
            this._projectCircleItem.setEnabled(bl6);
            this._showPeakfinderItem.setEnabled(bl6);
            this._showGeohackItem.setEnabled(bl6);
            this._searchOpencachingDeItem.setEnabled(bl6);
            this._openCachePageItem.setEnabled(bl6 && GeocacheCode.isValidCode(dataPoint.getWaypointName()));
            this._selectSegmentItem.setEnabled(bl6 && !dataPoint.isWaypoint());
            boolean bl7 = this._app.getTrackInfo().getPhotoList().hasAny();
            this._saveExifItem.setEnabled(bl7 && this._app.getTrackInfo().getPhotoList().hasMediaWithFile());
            Photo photo = this._app.getTrackInfo().getCurrentPhoto();
            boolean bl8 = photo != null;
            AudioClip audioClip = this._app.getTrackInfo().getCurrentAudio();
            boolean bl9 = audioClip != null;
            boolean bl10 = bl8 && bl6 && photo.getDataPoint() == null || bl9 && bl6 && audioClip.getDataPoint() == null;
            this._connectPhotoItem.setEnabled(bl8 && bl6 && photo.getDataPoint() == null);
            this._connectButton.setEnabled(bl10);
            this._disconnectPhotoItem.setEnabled(bl8 && photo.getDataPoint() != null);
            this._correlatePhotosItem.setEnabled(bl7 && bl);
            this._rearrangePhotosItem.setEnabled(bl7 && bl2);
            this._removePhotoItem.setEnabled(bl8);
            this._rotatePhotoLeft.setEnabled(bl8);
            this._rotatePhotoRight.setEnabled(bl8);
            this._photoPopupItem.setEnabled(bl8);
            this._ignoreExifThumb.setEnabled(bl8 && photo.getExifThumbnail() != null);
            this._selectNoPhotoItem.setEnabled(bl8);
            boolean bl11 = this._app.getTrackInfo().getAudioList().hasAny();
            this._selectNoAudioItem.setEnabled(bl9);
            this._removeAudioItem.setEnabled(bl9);
            this._connectAudioItem.setEnabled(bl9 && bl6 && audioClip.getDataPoint() == null);
            this._disconnectAudioItem.setEnabled(bl9 && audioClip.getDataPoint() != null);
            this._correlateAudiosItem.setEnabled(bl11 && bl);
            boolean bl12 = bl && this._selection.hasRangeSelected();
            this._deleteRangeItem.setEnabled(bl12);
            this._deleteRangeButton.setEnabled(bl12);
            this._cropTrackItem.setEnabled(bl12);
            boolean bl13 = bl && this._track.hasData(Field.TIMESTAMP, this._selection.getStart(), this._selection.getEnd());
            this._interpolateTimestampsItem.setEnabled(bl12 && bl13 && this._track.hasTrackPoints());
            this._interpolateItem.setEnabled(bl12);
            this._averageItem.setEnabled(bl12);
            this._mergeSegmentsItem.setEnabled(bl12);
            this._reverseItem.setEnabled(bl12);
            this._addTimeOffsetItem.setEnabled(bl12);
            this._addAltitudeOffsetItem.setEnabled(bl12);
            this._projectRangeItem.setEnabled(bl12);
            this._deleteFieldValuesItem.setEnabled(bl12);
            this._estimateTimeItem.setEnabled(bl12 && this._track.hasTrackPoints());
            this._learnEstimationParams.setEnabled(bl && this._track.hasTrackPoints() && this._track.hasData(Field.TIMESTAMP) && this._track.hasAltitudeData());
            boolean bl14 = bl12 && bl6 && (this._selection.getCurrentPointIndex() < this._selection.getStart() || this._selection.getCurrentPointIndex() > this._selection.getEnd() + 1);
            this._cutAndMoveItem.setEnabled(bl14);
            this._cutAndMoveButton.setEnabled(bl14);
            boolean bl15 = bl && this._track.getNumPoints() == 2;
            this._routingGraphHopperItem.setEnabled(bl15 || bl && bl12);
            boolean bl16 = this.getConfig().getConfigBoolean("prune.showmap");
            if (this._mapCheckbox.isSelected() != bl16) {
                this._mapCheckbox.setSelected(bl16);
            }
            boolean bl17 = (n2 = (recentFileList = this.getConfig().getRecentFileList()).getNumEntries()) > 0;
            this._recentFileMenu.setEnabled(bl17);
            if (!bl17) break block6;
            int n3 = this._recentFileMenu.getMenuComponentCount();
            if (n3 == n2) {
                int n4 = 0;
                while (n4 < n2) {
                    JMenuItem jMenuItem = this._recentFileMenu.getItem(n4);
                    RecentFile recentFile = recentFileList.getFile(n4);
                    jMenuItem.setText(recentFile == null ? "" : recentFile.getFile().getName());
                    jMenuItem.setToolTipText(recentFile == null ? null : recentFile.getFile().getAbsolutePath());
                    ++n4;
                }
            } else {
                recentFileList.verifyAll();
                this._recentFileMenu.removeAll();
                int n5 = 0;
                while (n5 < recentFileList.getCapacity()) {
                    RecentFile recentFile = recentFileList.getFile(n5);
                    if (recentFile != null && recentFile.isValid()) {
                        JMenuItem jMenuItem = new JMenuItem(recentFile.getFile().getName());
                        jMenuItem.setToolTipText(recentFile.getFile().getAbsolutePath());
                        jMenuItem.addActionListener(new RecentFileTrigger(this._app, n5));
                        this._recentFileMenu.add(jMenuItem);
                    }
                    ++n5;
                }
            }
        }
    }

    private void showExportMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(I18nManager.getText("menu.file.save"));
        jMenuItem.addActionListener(actionEvent -> this._app.saveFile());
        jPopupMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(I18nManager.getText("function.exportgpx"));
        jMenuItem2.addActionListener(actionEvent -> FunctionLibrary.FUNCTION_GPXEXPORT.begin());
        jPopupMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem(I18nManager.getText("function.exportkml"));
        jMenuItem3.addActionListener(actionEvent -> FunctionLibrary.FUNCTION_KMLEXPORT.begin());
        jPopupMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem(I18nManager.getText("function.exportimage"));
        jMenuItem4.addActionListener(actionEvent -> FunctionLibrary.FUNCTION_IMAGEEXPORT.begin());
        jPopupMenu.add(jMenuItem4);
        jPopupMenu.show(this._saveButton, 20, 15);
    }

    @Override
    public void actionCompleted(String string) {
    }
}

