/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.VolatileNullableLazyValue;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NullableLazyValue<T> {
    private boolean myComputed;
    @Nullable
    private T myValue;

    @Nullable
    protected abstract T compute();

    @Nullable
    public T getValue() {
        T value2 = this.myValue;
        if (!this.myComputed) {
            RecursionGuard.StackStamp stamp = RecursionManager.markStack();
            value2 = this.compute();
            if (stamp.mayCacheNow()) {
                this.myValue = value2;
                this.myComputed = true;
            }
        }
        return value2;
    }

    @NotNull
    public static <T> NullableLazyValue<T> atomicLazyNullable(final @NotNull Supplier<? extends T> value2) {
        if (value2 == null) {
            NullableLazyValue.$$$reportNull$$$0(1);
        }
        return new AtomicNullableLazyValue<T>(){

            @Override
            @Nullable
            protected T compute() {
                return value2.get();
            }
        };
    }

    @NotNull
    public static <T> NullableLazyValue<T> volatileLazyNullable(final @NotNull Supplier<? extends T> value2) {
        if (value2 == null) {
            NullableLazyValue.$$$reportNull$$$0(2);
        }
        return new VolatileNullableLazyValue<T>(){

            @Override
            @Nullable
            protected T compute() {
                return value2.get();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "value";
        objectArray2[1] = "com/intellij/openapi/util/NullableLazyValue";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "lazyNullable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "atomicLazyNullable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "volatileLazyNullable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

