/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.protocol.MessageUtil;

public class RegisterBrokerRecordJsonConverter {
    public static RegisterBrokerRecord read(JsonNode _node, short _version) {
        RegisterBrokerRecord.BrokerFeatureCollection _collection;
        RegisterBrokerRecord.BrokerEndpointCollection _collection2;
        RegisterBrokerRecord _object = new RegisterBrokerRecord();
        JsonNode _brokerIdNode = _node.get("brokerId");
        if (_brokerIdNode == null) {
            throw new RuntimeException("RegisterBrokerRecord: unable to locate field 'brokerId', which is mandatory in version " + _version);
        }
        _object.brokerId = MessageUtil.jsonNodeToInt((JsonNode)_brokerIdNode, (String)"RegisterBrokerRecord");
        JsonNode _isMigratingZkBrokerNode = _node.get("isMigratingZkBroker");
        if (_isMigratingZkBrokerNode == null) {
            if (_version >= 2) {
                throw new RuntimeException("RegisterBrokerRecord: unable to locate field 'isMigratingZkBroker', which is mandatory in version " + _version);
            }
            _object.isMigratingZkBroker = false;
        } else {
            if (!_isMigratingZkBrokerNode.isBoolean()) {
                throw new RuntimeException("RegisterBrokerRecord expected Boolean type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.isMigratingZkBroker = _isMigratingZkBrokerNode.asBoolean();
        }
        JsonNode _incarnationIdNode = _node.get("incarnationId");
        if (_incarnationIdNode == null) {
            throw new RuntimeException("RegisterBrokerRecord: unable to locate field 'incarnationId', which is mandatory in version " + _version);
        }
        if (!_incarnationIdNode.isTextual()) {
            throw new RuntimeException("RegisterBrokerRecord expected a JSON string type, but got " + String.valueOf(_node.getNodeType()));
        }
        _object.incarnationId = Uuid.fromString((String)_incarnationIdNode.asText());
        JsonNode _brokerEpochNode = _node.get("brokerEpoch");
        if (_brokerEpochNode == null) {
            throw new RuntimeException("RegisterBrokerRecord: unable to locate field 'brokerEpoch', which is mandatory in version " + _version);
        }
        _object.brokerEpoch = MessageUtil.jsonNodeToLong((JsonNode)_brokerEpochNode, (String)"RegisterBrokerRecord");
        JsonNode _endPointsNode = _node.get("endPoints");
        if (_endPointsNode == null) {
            throw new RuntimeException("RegisterBrokerRecord: unable to locate field 'endPoints', which is mandatory in version " + _version);
        }
        if (!_endPointsNode.isArray()) {
            throw new RuntimeException("RegisterBrokerRecord expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
        }
        _object.endPoints = _collection2 = new RegisterBrokerRecord.BrokerEndpointCollection(_endPointsNode.size());
        for (Object _element : _endPointsNode) {
            _collection2.add(BrokerEndpointJsonConverter.read((JsonNode)_element, _version));
        }
        JsonNode _featuresNode = _node.get("features");
        if (_featuresNode == null) {
            throw new RuntimeException("RegisterBrokerRecord: unable to locate field 'features', which is mandatory in version " + _version);
        }
        if (!_featuresNode.isArray()) {
            throw new RuntimeException("RegisterBrokerRecord expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
        }
        _object.features = _collection = new RegisterBrokerRecord.BrokerFeatureCollection(_featuresNode.size());
        for (JsonNode _element : _featuresNode) {
            _collection.add(BrokerFeatureJsonConverter.read(_element, _version));
        }
        JsonNode _rackNode = _node.get("rack");
        if (_rackNode == null) {
            throw new RuntimeException("RegisterBrokerRecord: unable to locate field 'rack', which is mandatory in version " + _version);
        }
        if (_rackNode.isNull()) {
            _object.rack = null;
        } else {
            if (!_rackNode.isTextual()) {
                throw new RuntimeException("RegisterBrokerRecord expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.rack = _rackNode.asText();
        }
        JsonNode _fencedNode = _node.get("fenced");
        if (_fencedNode == null) {
            throw new RuntimeException("RegisterBrokerRecord: unable to locate field 'fenced', which is mandatory in version " + _version);
        }
        if (!_fencedNode.isBoolean()) {
            throw new RuntimeException("RegisterBrokerRecord expected Boolean type, but got " + String.valueOf(_node.getNodeType()));
        }
        _object.fenced = _fencedNode.asBoolean();
        JsonNode _inControlledShutdownNode = _node.get("inControlledShutdown");
        if (_inControlledShutdownNode == null) {
            if (_version >= 1) {
                throw new RuntimeException("RegisterBrokerRecord: unable to locate field 'inControlledShutdown', which is mandatory in version " + _version);
            }
            _object.inControlledShutdown = false;
        } else {
            if (!_inControlledShutdownNode.isBoolean()) {
                throw new RuntimeException("RegisterBrokerRecord expected Boolean type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.inControlledShutdown = _inControlledShutdownNode.asBoolean();
        }
        JsonNode _logDirsNode = _node.get("logDirs");
        if (_logDirsNode == null) {
            _object.logDirs = new ArrayList<Uuid>(0);
        } else {
            if (!_logDirsNode.isArray()) {
                throw new RuntimeException("RegisterBrokerRecord expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            ArrayList<Uuid> _collection3 = new ArrayList<Uuid>(_logDirsNode.size());
            _object.logDirs = _collection3;
            for (JsonNode _element : _logDirsNode) {
                if (!_element.isTextual()) {
                    throw new RuntimeException("RegisterBrokerRecord element expected a JSON string type, but got " + String.valueOf(_node.getNodeType()));
                }
                _collection3.add(Uuid.fromString((String)_element.asText()));
            }
        }
        return _object;
    }

    public static JsonNode write(RegisterBrokerRecord _object, short _version, boolean _serializeRecords) {
        Object _element;
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("brokerId", (JsonNode)new IntNode(_object.brokerId));
        if (_version >= 2) {
            _node.set("isMigratingZkBroker", (JsonNode)BooleanNode.valueOf((boolean)_object.isMigratingZkBroker));
        } else if (_object.isMigratingZkBroker) {
            throw new UnsupportedVersionException("Attempted to write a non-default isMigratingZkBroker at version " + _version);
        }
        _node.set("incarnationId", (JsonNode)new TextNode(_object.incarnationId.toString()));
        _node.set("brokerEpoch", (JsonNode)new LongNode(_object.brokerEpoch));
        ArrayNode _endPointsArray = new ArrayNode(JsonNodeFactory.instance);
        Iterator iterator = _object.endPoints.iterator();
        while (iterator.hasNext()) {
            _element = (RegisterBrokerRecord.BrokerEndpoint)iterator.next();
            _endPointsArray.add(BrokerEndpointJsonConverter.write((RegisterBrokerRecord.BrokerEndpoint)_element, _version, _serializeRecords));
        }
        _node.set("endPoints", (JsonNode)_endPointsArray);
        ArrayNode _featuresArray = new ArrayNode(JsonNodeFactory.instance);
        _element = _object.features.iterator();
        while (_element.hasNext()) {
            RegisterBrokerRecord.BrokerFeature _element2 = (RegisterBrokerRecord.BrokerFeature)_element.next();
            _featuresArray.add(BrokerFeatureJsonConverter.write(_element2, _version, _serializeRecords));
        }
        _node.set("features", (JsonNode)_featuresArray);
        if (_object.rack == null) {
            _node.set("rack", (JsonNode)NullNode.instance);
        } else {
            _node.set("rack", (JsonNode)new TextNode(_object.rack));
        }
        _node.set("fenced", (JsonNode)BooleanNode.valueOf((boolean)_object.fenced));
        if (_version >= 1) {
            _node.set("inControlledShutdown", (JsonNode)BooleanNode.valueOf((boolean)_object.inControlledShutdown));
        } else if (_object.inControlledShutdown) {
            throw new UnsupportedVersionException("Attempted to write a non-default inControlledShutdown at version " + _version);
        }
        if (_version >= 3) {
            if (!_object.logDirs.isEmpty()) {
                ArrayNode _logDirsArray = new ArrayNode(JsonNodeFactory.instance);
                for (Uuid _element3 : _object.logDirs) {
                    _logDirsArray.add((JsonNode)new TextNode(_element3.toString()));
                }
                _node.set("logDirs", (JsonNode)_logDirsArray);
            }
        } else if (!_object.logDirs.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default logDirs at version " + _version);
        }
        return _node;
    }

    public static JsonNode write(RegisterBrokerRecord _object, short _version) {
        return RegisterBrokerRecordJsonConverter.write(_object, _version, true);
    }

    public static class BrokerEndpointJsonConverter {
        public static RegisterBrokerRecord.BrokerEndpoint read(JsonNode _node, short _version) {
            RegisterBrokerRecord.BrokerEndpoint _object = new RegisterBrokerRecord.BrokerEndpoint();
            JsonNode _nameNode = _node.get("name");
            if (_nameNode == null) {
                throw new RuntimeException("BrokerEndpoint: unable to locate field 'name', which is mandatory in version " + _version);
            }
            if (!_nameNode.isTextual()) {
                throw new RuntimeException("BrokerEndpoint expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.name = _nameNode.asText();
            JsonNode _hostNode = _node.get("host");
            if (_hostNode == null) {
                throw new RuntimeException("BrokerEndpoint: unable to locate field 'host', which is mandatory in version " + _version);
            }
            if (!_hostNode.isTextual()) {
                throw new RuntimeException("BrokerEndpoint expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.host = _hostNode.asText();
            JsonNode _portNode = _node.get("port");
            if (_portNode == null) {
                throw new RuntimeException("BrokerEndpoint: unable to locate field 'port', which is mandatory in version " + _version);
            }
            _object.port = MessageUtil.jsonNodeToUnsignedShort((JsonNode)_portNode, (String)"BrokerEndpoint");
            JsonNode _securityProtocolNode = _node.get("securityProtocol");
            if (_securityProtocolNode == null) {
                throw new RuntimeException("BrokerEndpoint: unable to locate field 'securityProtocol', which is mandatory in version " + _version);
            }
            _object.securityProtocol = MessageUtil.jsonNodeToShort((JsonNode)_securityProtocolNode, (String)"BrokerEndpoint");
            return _object;
        }

        public static JsonNode write(RegisterBrokerRecord.BrokerEndpoint _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("name", (JsonNode)new TextNode(_object.name));
            _node.set("host", (JsonNode)new TextNode(_object.host));
            _node.set("port", (JsonNode)new IntNode(_object.port));
            _node.set("securityProtocol", (JsonNode)new ShortNode(_object.securityProtocol));
            return _node;
        }

        public static JsonNode write(RegisterBrokerRecord.BrokerEndpoint _object, short _version) {
            return BrokerEndpointJsonConverter.write(_object, _version, true);
        }
    }

    public static class BrokerFeatureJsonConverter {
        public static RegisterBrokerRecord.BrokerFeature read(JsonNode _node, short _version) {
            RegisterBrokerRecord.BrokerFeature _object = new RegisterBrokerRecord.BrokerFeature();
            JsonNode _nameNode = _node.get("name");
            if (_nameNode == null) {
                throw new RuntimeException("BrokerFeature: unable to locate field 'name', which is mandatory in version " + _version);
            }
            if (!_nameNode.isTextual()) {
                throw new RuntimeException("BrokerFeature expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.name = _nameNode.asText();
            JsonNode _minSupportedVersionNode = _node.get("minSupportedVersion");
            if (_minSupportedVersionNode == null) {
                throw new RuntimeException("BrokerFeature: unable to locate field 'minSupportedVersion', which is mandatory in version " + _version);
            }
            _object.minSupportedVersion = MessageUtil.jsonNodeToShort((JsonNode)_minSupportedVersionNode, (String)"BrokerFeature");
            JsonNode _maxSupportedVersionNode = _node.get("maxSupportedVersion");
            if (_maxSupportedVersionNode == null) {
                throw new RuntimeException("BrokerFeature: unable to locate field 'maxSupportedVersion', which is mandatory in version " + _version);
            }
            _object.maxSupportedVersion = MessageUtil.jsonNodeToShort((JsonNode)_maxSupportedVersionNode, (String)"BrokerFeature");
            return _object;
        }

        public static JsonNode write(RegisterBrokerRecord.BrokerFeature _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("name", (JsonNode)new TextNode(_object.name));
            _node.set("minSupportedVersion", (JsonNode)new ShortNode(_object.minSupportedVersion));
            _node.set("maxSupportedVersion", (JsonNode)new ShortNode(_object.maxSupportedVersion));
            return _node;
        }

        public static JsonNode write(RegisterBrokerRecord.BrokerFeature _object, short _version) {
            return BrokerFeatureJsonConverter.write(_object, _version, true);
        }
    }
}

