/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class CollectionHelper {
    public static final int DEFAULT_LIST_CAPACITY = 10;
    public static final int MINIMUM_INITIAL_CAPACITY = 16;
    public static final float LOAD_FACTOR = 0.75f;

    public static boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection collection) {
        return !CollectionHelper.isEmpty(collection);
    }

    public static boolean isEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmpty(Map map) {
        return !CollectionHelper.isEmpty(map);
    }

    public static boolean isEmpty(Object[] objects) {
        return objects == null || objects.length == 0;
    }

    public static boolean isNotEmpty(Object[] objects) {
        return objects != null && objects.length > 0;
    }

    public static int size(Collection collection) {
        return collection == null ? 0 : collection.size();
    }

    public static int size(Map map) {
        return map == null ? 0 : map.size();
    }

    public static int length(Object[] array) {
        return array == null ? 0 : array.length;
    }

    public static <T> ArrayList<T> arrayList(int expectedNumberOfElements) {
        return new ArrayList(Math.max(expectedNumberOfElements + 1, 10));
    }

    public static <E> List<E> join(List<E> first, List<E> second) {
        int totalCount = (first == null ? 0 : first.size()) + (second == null ? 0 : second.size());
        if (totalCount == 0) {
            return Collections.emptyList();
        }
        ArrayList<E> joined = new ArrayList<E>(totalCount);
        if (first != null) {
            joined.addAll(first);
        }
        if (second != null) {
            joined.addAll(second);
        }
        return joined;
    }

    public static <T> void forEach(T[] values, Consumer<T> consumer) {
        if (CollectionHelper.isNotEmpty(values)) {
            for (int i = 0; i < values.length; ++i) {
                consumer.accept(values[i]);
            }
        }
    }

    public static int determineProperSizing(int numberOfElements) {
        int actual = (int)((float)numberOfElements / 0.75f) + 1;
        return Math.max(actual, 16);
    }

    public static <K, V> LinkedHashMap<K, V> linkedMapOfSize(int size) {
        return new LinkedHashMap(CollectionHelper.determineProperSizing(size), 0.75f);
    }
}

