/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.json;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.dialect.function.json.JsonPathHelper;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.function.FunctionKind;
import org.hibernate.query.sqm.function.FunctionRenderer;
import org.hibernate.query.sqm.function.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.ArgumentTypesValidator;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmJsonQueryExpression;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JsonPathPassingClause;
import org.hibernate.sql.ast.tree.expression.JsonQueryEmptyBehavior;
import org.hibernate.sql.ast.tree.expression.JsonQueryErrorBehavior;
import org.hibernate.sql.ast.tree.expression.JsonQueryWrapMode;
import org.hibernate.type.spi.TypeConfiguration;

public class JsonQueryFunction
extends AbstractSqmSelfRenderingFunctionDescriptor {
    protected final boolean supportsJsonPathExpression;
    protected final boolean supportsJsonPathPassingClause;

    public JsonQueryFunction(TypeConfiguration typeConfiguration, boolean supportsJsonPathExpression, boolean supportsJsonPathPassingClause) {
        super("json_query", FunctionKind.NORMAL, StandardArgumentsValidators.composite(new ArgumentTypesValidator(StandardArgumentsValidators.between(2, 3), FunctionParameterType.IMPLICIT_JSON, FunctionParameterType.STRING, FunctionParameterType.ANY)), StandardFunctionReturnTypeResolvers.invariant(typeConfiguration.getBasicTypeRegistry().resolve(String.class, 3001)), StandardFunctionArgumentTypeResolvers.invariant(typeConfiguration, FunctionParameterType.JSON, FunctionParameterType.STRING));
        this.supportsJsonPathExpression = supportsJsonPathExpression;
        this.supportsJsonPathPassingClause = supportsJsonPathPassingClause;
    }

    @Override
    protected <T> SelfRenderingSqmFunction<T> generateSqmFunctionExpression(List<? extends SqmTypedNode<?>> arguments, ReturnableType<T> impliedResultType, QueryEngine queryEngine) {
        return new SqmJsonQueryExpression((SqmFunctionDescriptor)this, (FunctionRenderer)this, arguments, impliedResultType, this.getArgumentsValidator(), this.getReturnTypeResolver(), queryEngine.getCriteriaBuilder(), this.getName());
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        this.render(sqlAppender, JsonQueryArguments.extract(sqlAstArguments), returnType, walker);
    }

    protected void render(SqlAppender sqlAppender, JsonQueryArguments arguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        sqlAppender.appendSql("json_query(");
        arguments.jsonDocument().accept(walker);
        sqlAppender.appendSql(',');
        JsonPathPassingClause passingClause = arguments.passingClause();
        if (this.supportsJsonPathPassingClause || passingClause == null) {
            if (this.supportsJsonPathExpression) {
                arguments.jsonPath().accept(walker);
            } else {
                walker.getSessionFactory().getJdbcServices().getDialect().appendLiteral(sqlAppender, (String)walker.getLiteralValue(arguments.jsonPath()));
            }
            if (passingClause != null) {
                sqlAppender.appendSql(" passing ");
                Map<String, Expression> passingExpressions = passingClause.getPassingExpressions();
                Iterator<Map.Entry<String, Expression>> iterator = passingExpressions.entrySet().iterator();
                Map.Entry<String, Expression> entry = iterator.next();
                entry.getValue().accept(walker);
                sqlAppender.appendSql(" as ");
                sqlAppender.appendDoubleQuoteEscapedString(entry.getKey());
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    sqlAppender.appendSql(',');
                    entry.getValue().accept(walker);
                    sqlAppender.appendSql(" as ");
                    sqlAppender.appendDoubleQuoteEscapedString(entry.getKey());
                }
            }
        } else {
            JsonPathHelper.appendInlinedJsonPathIncludingPassingClause(sqlAppender, "", arguments.jsonPath(), passingClause, walker);
        }
        if (arguments.wrapMode() != null) {
            switch (arguments.wrapMode()) {
                case WITH_WRAPPER: {
                    sqlAppender.appendSql(" with wrapper");
                    break;
                }
                case WITHOUT_WRAPPER: {
                    sqlAppender.appendSql(" without wrapper");
                    break;
                }
                case WITH_CONDITIONAL_WRAPPER: {
                    sqlAppender.appendSql(" with conditional wrapper");
                }
            }
        }
        if (arguments.errorBehavior() != null) {
            switch (arguments.errorBehavior()) {
                case ERROR: {
                    sqlAppender.appendSql(" error on error");
                    break;
                }
                case NULL: {
                    sqlAppender.appendSql(" null on error");
                    break;
                }
                case EMPTY_OBJECT: {
                    sqlAppender.appendSql(" empty object on error");
                    break;
                }
                case EMPTY_ARRAY: {
                    sqlAppender.appendSql(" empty array on error");
                }
            }
        }
        if (arguments.emptyBehavior() != null) {
            switch (arguments.emptyBehavior()) {
                case ERROR: {
                    sqlAppender.appendSql(" error on empty");
                    break;
                }
                case NULL: {
                    sqlAppender.appendSql(" null on empty");
                    break;
                }
                case EMPTY_OBJECT: {
                    sqlAppender.appendSql(" empty object on empty");
                    break;
                }
                case EMPTY_ARRAY: {
                    sqlAppender.appendSql(" empty array on empty");
                }
            }
        }
        sqlAppender.appendSql(')');
    }

    protected record JsonQueryArguments(Expression jsonDocument, Expression jsonPath, boolean isJsonType, @Nullable JsonPathPassingClause passingClause, @Nullable JsonQueryWrapMode wrapMode, @Nullable JsonQueryErrorBehavior errorBehavior, @Nullable JsonQueryEmptyBehavior emptyBehavior) {
        public static JsonQueryArguments extract(List<? extends SqlAstNode> sqlAstArguments) {
            SqlAstNode node;
            int nextIndex = 2;
            JsonPathPassingClause passingClause = null;
            JsonQueryWrapMode wrapMode = null;
            JsonQueryErrorBehavior errorBehavior = null;
            JsonQueryEmptyBehavior emptyBehavior = null;
            if (nextIndex < sqlAstArguments.size() && (node = sqlAstArguments.get(nextIndex)) instanceof JsonPathPassingClause) {
                JsonPathPassingClause jsonPathPassingClause;
                passingClause = jsonPathPassingClause = (JsonPathPassingClause)node;
                ++nextIndex;
            }
            if (nextIndex < sqlAstArguments.size() && (node = sqlAstArguments.get(nextIndex)) instanceof JsonQueryWrapMode) {
                JsonQueryWrapMode jsonQueryWrapMode;
                wrapMode = jsonQueryWrapMode = (JsonQueryWrapMode)node;
                ++nextIndex;
            }
            if (nextIndex < sqlAstArguments.size() && (node = sqlAstArguments.get(nextIndex)) instanceof JsonQueryErrorBehavior) {
                JsonQueryErrorBehavior jsonQueryErrorBehavior;
                errorBehavior = jsonQueryErrorBehavior = (JsonQueryErrorBehavior)node;
                ++nextIndex;
            }
            if (nextIndex < sqlAstArguments.size() && (node = sqlAstArguments.get(nextIndex)) instanceof JsonQueryEmptyBehavior) {
                JsonQueryEmptyBehavior jsonQueryEmptyBehavior;
                emptyBehavior = jsonQueryEmptyBehavior = (JsonQueryEmptyBehavior)node;
            }
            Expression jsonDocument = (Expression)sqlAstArguments.get(0);
            return new JsonQueryArguments(jsonDocument, (Expression)sqlAstArguments.get(1), jsonDocument.getExpressionType() != null && jsonDocument.getExpressionType().getSingleJdbcMapping().getJdbcType().isJson(), passingClause, wrapMode, errorBehavior, emptyBehavior);
        }
    }
}

