/*
 * Decompiled with CFR 0.152.
 */
package mediathek.mainwindow;

import java.awt.Font;
import java.util.concurrent.TimeUnit;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mediathek.daten.Country;
import mediathek.gui.actions.UrlHyperlinkAction;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.timer.TimerPool;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\rH\u0002J\u0006\u0010\u000e\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lmediathek/mainwindow/AustrianVlcCheck;", "", "owner", "Ljavax/swing/JFrame;", "<init>", "(Ljavax/swing/JFrame;)V", "getOwner", "()Ljavax/swing/JFrame;", "getFontWeight", "", "font", "Ljava/awt/Font;", "showSwingMessage", "", "perform", "Companion", "MediathekView"})
public final class AustrianVlcCheck {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JFrame owner;
    private static final Logger logger = LogManager.getLogger();

    public AustrianVlcCheck(@NotNull JFrame owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        this.owner = owner;
    }

    @NotNull
    public final JFrame getOwner() {
        return this.owner;
    }

    private final String getFontWeight(Font font) {
        return font.isBold() ? "bold" : "normal";
    }

    private final void showSwingMessage() {
        Font font = UIManager.getFont("Label.font");
        Intrinsics.checkNotNull((Object)font);
        String boldFont = this.getFontWeight(font);
        String style = "font-family:" + font.getFamily() + ";font-weight:" + boldFont + ";font-size: " + font.getSize() + "pt;";
        String msg = "<html><body style=\"" + style + "\">Um den ORF erfolgreich zu nutzen sind zus\u00e4tzliche Einstellungen erforderlich.<br>Bitte lesen Sie sich hierzu den <a href=\"\">Link</a> durch.</body></html>";
        JEditorPane ep = new JEditorPane("text/html", msg);
        ep.setEditable(false);
        ep.setBackground(UIManager.getColor("Label.background"));
        ep.addHyperlinkListener(AustrianVlcCheck::showSwingMessage$lambda$0);
        JOptionPane.showMessageDialog(this.owner, ep, "Wichtige Information f\u00fcr ORF", 2);
    }

    public final void perform() {
        logger.trace("ORF setup tutorial display check started");
        if (ApplicationConfiguration.getConfiguration().getBoolean("application.orf.show_config_help", true) && ApplicationConfiguration.getInstance().getGeographicLocation() == Country.AT) {
            logger.trace("Launching info dialog in 15 seconds...");
            TimerPool.getTimerPool().schedule(() -> AustrianVlcCheck.perform$lambda$0(this), 15L, TimeUnit.SECONDS);
        }
        logger.trace("ORF setup tutorial display check finished");
    }

    private static final void showSwingMessage$lambda$0(HyperlinkEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (Intrinsics.areEqual((Object)e.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
            try {
                ApplicationConfiguration.getConfiguration().setProperty("application.orf.show_config_help", (Object)false);
                UrlHyperlinkAction.openURL("https://forum.mediathekview.de/topic/2546/anleitung-einstellungen-f\u00fcr-orf-download");
            }
            catch (Exception ex) {
                logger.error("Failed to display ORF tutorial", (Throwable)ex);
            }
        }
    }

    private static final void perform$lambda$0(AustrianVlcCheck this$0) {
        SwingUtilities.invokeLater(() -> AustrianVlcCheck.perform$lambda$0$0(this$0));
    }

    private static final void perform$lambda$0$0(AustrianVlcCheck this$0) {
        this$0.showSwingMessage();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lmediathek/mainwindow/AustrianVlcCheck$Companion;", "", "<init>", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "MediathekView"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

