/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.impl.web.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef;
import org.netbeans.modules.j2ee.dd.api.common.EjbRef;
import org.netbeans.modules.j2ee.dd.api.common.EnvEntry;
import org.netbeans.modules.j2ee.dd.api.common.MessageDestinationRef;
import org.netbeans.modules.j2ee.dd.api.common.ResourceEnvRef;
import org.netbeans.modules.j2ee.dd.api.common.ResourceRef;
import org.netbeans.modules.j2ee.dd.api.common.SecurityRole;
import org.netbeans.modules.j2ee.dd.api.common.ServiceRef;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.web.Filter;
import org.netbeans.modules.j2ee.dd.api.web.FilterMapping;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping25;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.api.web.WebFragment;
import org.netbeans.modules.j2ee.dd.api.web.model.FilterInfo;
import org.netbeans.modules.j2ee.dd.api.web.model.ServletInfo;
import org.netbeans.modules.j2ee.dd.impl.common.annotation.CommonAnnotationHelper;
import org.netbeans.modules.j2ee.dd.impl.common.annotation.EjbRefHelper;
import org.netbeans.modules.j2ee.dd.impl.web.annotation.AnnotationHelpers;
import org.netbeans.modules.j2ee.dd.impl.web.annotation.SecurityRoles;
import org.netbeans.modules.j2ee.dd.impl.web.annotation.WebFilter;
import org.netbeans.modules.j2ee.dd.impl.web.annotation.WebServlet;
import org.netbeans.modules.j2ee.dd.impl.web.metadata.FilterInfoAccessor;
import org.netbeans.modules.j2ee.dd.impl.web.metadata.MergeEngine;
import org.netbeans.modules.j2ee.dd.impl.web.metadata.ServletInfoAccessor;

public class MergeEngines {
    private static ServletsEngine servletsEngine = new ServletsEngine();
    private static FiltersEngine filtersEngine = new FiltersEngine();
    private static SecurityRolesEngine securityRolesEngine = new SecurityRolesEngine();
    private static ResourceRefsEngine resourceRefsEngine = new ResourceRefsEngine();
    private static ResourceEnvRefsEngine resourceEnvRefsEngine = new ResourceEnvRefsEngine();
    private static ResourceEnvEntriesEngine resourceEnvEntriesEngine = new ResourceEnvEntriesEngine();
    private static ResourceMsgDestsEngine resourceMsgDestsEngine = new ResourceMsgDestsEngine();
    private static ResourceServicesEngine resourceServicesEngine = new ResourceServicesEngine();
    private static EjbLocalRefsEngine ejbLocalRefsEngine = new EjbLocalRefsEngine();
    private static EjbRefsEngine ejbRefsEngine = new EjbRefsEngine();

    private MergeEngines() {
    }

    static MergeEngine<ServletInfo> servletsEngine() {
        return servletsEngine;
    }

    static MergeEngine<FilterInfo> filtersEngine() {
        return filtersEngine;
    }

    static MergeEngine<String> securityRolesEngine() {
        return securityRolesEngine;
    }

    static MergeEngine<ResourceRef> resourceRefsEngine() {
        return resourceRefsEngine;
    }

    static MergeEngine<ResourceEnvRef> resourceEnvRefsEngine() {
        return resourceEnvRefsEngine;
    }

    static MergeEngine<EnvEntry> resourceEnvEntriesEngine() {
        return resourceEnvEntriesEngine;
    }

    static MergeEngine<MessageDestinationRef> resourceMsgDestsEngine() {
        return resourceMsgDestsEngine;
    }

    static MergeEngine<ServiceRef> resourceServicesEngine() {
        return resourceServicesEngine;
    }

    static MergeEngine<EjbLocalRef> ejbLocalRefsEngine() {
        return ejbLocalRefsEngine;
    }

    static MergeEngine<EjbRef> ejbRefsEngine() {
        return ejbRefsEngine;
    }

    private static class ServletsEngine
    extends MergeEngine<ServletInfo> {
        private ServletsEngine() {
        }

        @Override
        void addItems(WebApp webXml) {
            this.addServlets(webXml.getServlet(), webXml.getServletMapping());
        }

        @Override
        void addItems(WebFragment webXml) {
            this.addServlets(webXml.getServlet(), webXml.getServletMapping());
        }

        @Override
        void addAnnotations(AnnotationHelpers annotationHelpers) {
            for (WebServlet ann : annotationHelpers.getWebServletPOM().getObjects()) {
                this.res.add(ServletInfoAccessor.getDefault().createServletInfo(ann.getName(), ann.getServletClass(), ann.getUrlPatterns()));
            }
        }

        private void addServlets(Servlet[] servlets, ServletMapping[] mappings) {
            if (servlets != null) {
                for (Servlet s : servlets) {
                    String name = s.getServletName();
                    String clazz = s.getServletClass();
                    if (clazz == null || clazz.trim().length() == 0) continue;
                    List<String> urlMappings = this.findUrlMappingsForServlet(mappings, name);
                    this.res.add(ServletInfoAccessor.getDefault().createServletInfo(name, clazz, urlMappings));
                }
            }
        }

        private List<String> findUrlMappingsForServlet(ServletMapping[] mappings, String servletName) {
            ArrayList<String> mpgs = new ArrayList<String>();
            if (mappings != null) {
                for (ServletMapping sm : mappings) {
                    if (!sm.getServletName().equals(servletName)) continue;
                    mpgs.addAll(Arrays.asList(((ServletMapping25)sm).getUrlPatterns()));
                }
            }
            return mpgs;
        }
    }

    private static class FiltersEngine
    extends MergeEngine<FilterInfo> {
        private FiltersEngine() {
        }

        @Override
        void addItems(WebApp webXml) {
            this.addFilters(webXml.getFilter(), webXml.getFilterMapping());
        }

        @Override
        void addItems(WebFragment webXml) {
            this.addFilters(webXml.getFilter(), webXml.getFilterMapping());
        }

        @Override
        void addAnnotations(AnnotationHelpers annotationHelpers) {
            for (WebFilter ann : annotationHelpers.getWebFilterPOM().getObjects()) {
                this.res.add(FilterInfoAccessor.getDefault().createFilterInfo(ann.getName(), ann.getFilterClass(), ann.getUrlPatterns()));
            }
        }

        private void addFilters(Filter[] filters, FilterMapping[] mappings) {
            if (filters != null) {
                for (Filter f : filters) {
                    String name = f.getFilterName();
                    String clazz = f.getFilterClass();
                    List<String> urlMappings = this.findUrlMappingsForFilter(mappings, name);
                    this.res.add(FilterInfoAccessor.getDefault().createFilterInfo(name, clazz, urlMappings));
                }
            }
        }

        private List<String> findUrlMappingsForFilter(FilterMapping[] mappings, String filterName) {
            ArrayList<String> mpgs = new ArrayList<String>();
            if (mappings != null) {
                for (FilterMapping fm : mappings) {
                    if (!fm.getFilterName().equals(filterName) || fm.getUrlPattern() == null) continue;
                    mpgs.add(fm.getUrlPattern());
                }
            }
            return mpgs;
        }
    }

    private static class SecurityRolesEngine
    extends MergeEngine<String> {
        private SecurityRolesEngine() {
        }

        @Override
        void addItems(WebApp webXml) {
            this.addRole(webXml.getSecurityRole());
        }

        @Override
        void addItems(WebFragment webFragment) {
            this.addRole(webFragment.getSecurityRole());
        }

        @Override
        void addAnnotations(AnnotationHelpers annotationHelpers) {
            for (SecurityRoles ann : annotationHelpers.getSecurityRolesPOM().getObjects()) {
                this.res.addAll(ann.getRoles());
            }
        }

        private void addRole(SecurityRole[] roles) {
            for (SecurityRole r : roles) {
                this.res.add(r.getRoleName());
            }
        }
    }

    private static class ResourceRefsEngine
    extends MergeEngine<ResourceRef> {
        private ResourceRefsEngine() {
        }

        @Override
        void addItems(WebApp webXml) {
            this.addAll(webXml.getResourceRef());
        }

        @Override
        void addItems(WebFragment webFragment) {
            this.addAll(webFragment.getResourceRef());
        }

        @Override
        void addAnnotations(AnnotationHelpers annotationHelpers) {
            ResourceRef[] refs;
            for (ResourceRef r : refs = CommonAnnotationHelper.getResourceRefs(annotationHelpers.getHelper())) {
                this.res.add(r);
            }
        }
    }

    private static class ResourceEnvRefsEngine
    extends MergeEngine<ResourceEnvRef> {
        private ResourceEnvRefsEngine() {
        }

        @Override
        void addItems(WebApp webXml) {
            this.addAll(webXml.getResourceEnvRef());
        }

        @Override
        void addItems(WebFragment webFragment) {
            this.addAll(webFragment.getResourceEnvRef());
        }

        @Override
        void addAnnotations(AnnotationHelpers annotationHelpers) {
            ResourceEnvRef[] refs;
            for (ResourceEnvRef r : refs = CommonAnnotationHelper.getResourceEnvRefs(annotationHelpers.getHelper())) {
                this.res.add(r);
            }
        }
    }

    private static class ResourceEnvEntriesEngine
    extends MergeEngine<EnvEntry> {
        private ResourceEnvEntriesEngine() {
        }

        @Override
        void addItems(WebApp webXml) {
            this.addAll(webXml.getEnvEntry());
        }

        @Override
        void addItems(WebFragment webFragment) {
            this.addAll(webFragment.getEnvEntry());
        }

        @Override
        void addAnnotations(AnnotationHelpers annotationHelpers) {
            EnvEntry[] refs;
            for (EnvEntry r : refs = CommonAnnotationHelper.getEnvEntries(annotationHelpers.getHelper())) {
                this.res.add(r);
            }
        }
    }

    private static class ResourceMsgDestsEngine
    extends MergeEngine<MessageDestinationRef> {
        private ResourceMsgDestsEngine() {
        }

        @Override
        void addItems(WebApp webXml) {
            try {
                this.addAll(webXml.getMessageDestinationRef());
            }
            catch (VersionNotSupportedException versionNotSupportedException) {
                // empty catch block
            }
        }

        @Override
        void addItems(WebFragment webFragment) {
            try {
                this.addAll(webFragment.getMessageDestinationRef());
            }
            catch (VersionNotSupportedException versionNotSupportedException) {
                // empty catch block
            }
        }

        @Override
        void addAnnotations(AnnotationHelpers annotationHelpers) {
            MessageDestinationRef[] refs;
            for (MessageDestinationRef r : refs = CommonAnnotationHelper.getMessageDestinationRefs(annotationHelpers.getHelper())) {
                this.res.add(r);
            }
        }
    }

    private static class ResourceServicesEngine
    extends MergeEngine<ServiceRef> {
        private ResourceServicesEngine() {
        }

        @Override
        void addItems(WebApp webXml) {
            try {
                this.addAll(webXml.getServiceRef());
            }
            catch (VersionNotSupportedException versionNotSupportedException) {
                // empty catch block
            }
        }

        @Override
        void addItems(WebFragment webFragment) {
            try {
                this.addAll(webFragment.getServiceRef());
            }
            catch (VersionNotSupportedException versionNotSupportedException) {
                // empty catch block
            }
        }

        @Override
        void addAnnotations(AnnotationHelpers annotationHelpers) {
            ServiceRef[] refs;
            for (ServiceRef r : refs = CommonAnnotationHelper.getServiceRefs(annotationHelpers.getHelper())) {
                this.res.add(r);
            }
        }
    }

    private static class EjbLocalRefsEngine
    extends MergeEngine<EjbLocalRef> {
        private EjbLocalRefsEngine() {
        }

        @Override
        void addItems(WebApp webXml) {
            this.addAll(webXml.getEjbLocalRef());
        }

        @Override
        void addItems(WebFragment webFragment) {
            this.addAll(webFragment.getEjbLocalRef());
        }

        @Override
        void addAnnotations(AnnotationHelpers annotationHelpers) {
            ArrayList<EjbLocalRef> l = new ArrayList<EjbLocalRef>();
            EjbRefHelper.setEjbRefs(annotationHelpers.getHelper(), null, l);
            this.res.addAll(l);
        }
    }

    private static class EjbRefsEngine
    extends MergeEngine<EjbRef> {
        private EjbRefsEngine() {
        }

        @Override
        void addItems(WebApp webXml) {
            this.addAll(webXml.getEjbRef());
        }

        @Override
        void addItems(WebFragment webFragment) {
            this.addAll(webFragment.getEjbRef());
        }

        @Override
        void addAnnotations(AnnotationHelpers annotationHelpers) {
            ArrayList<EjbRef> l = new ArrayList<EjbRef>();
            EjbRefHelper.setEjbRefs(annotationHelpers.getHelper(), l, null);
            this.res.addAll(l);
        }
    }
}

