/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.core.model.UpdateVirtualCircuitDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateVirtualCircuitRequest
extends BmcRequest<UpdateVirtualCircuitDetails> {
    private String virtualCircuitId;
    private UpdateVirtualCircuitDetails updateVirtualCircuitDetails;
    private String ifMatch;

    public String getVirtualCircuitId() {
        return this.virtualCircuitId;
    }

    public UpdateVirtualCircuitDetails getUpdateVirtualCircuitDetails() {
        return this.updateVirtualCircuitDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateVirtualCircuitDetails getBody$() {
        return this.updateVirtualCircuitDetails;
    }

    public Builder toBuilder() {
        return new Builder().virtualCircuitId(this.virtualCircuitId).updateVirtualCircuitDetails(this.updateVirtualCircuitDetails).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",virtualCircuitId=").append(String.valueOf(this.virtualCircuitId));
        sb.append(",updateVirtualCircuitDetails=").append(String.valueOf((Object)this.updateVirtualCircuitDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateVirtualCircuitRequest)) {
            return false;
        }
        UpdateVirtualCircuitRequest other = (UpdateVirtualCircuitRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.virtualCircuitId, other.virtualCircuitId) && Objects.equals((Object)this.updateVirtualCircuitDetails, (Object)other.updateVirtualCircuitDetails) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.virtualCircuitId == null ? 43 : this.virtualCircuitId.hashCode());
        result = result * 59 + (this.updateVirtualCircuitDetails == null ? 43 : this.updateVirtualCircuitDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateVirtualCircuitRequest, UpdateVirtualCircuitDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String virtualCircuitId = null;
        private UpdateVirtualCircuitDetails updateVirtualCircuitDetails = null;
        private String ifMatch = null;

        public Builder virtualCircuitId(String virtualCircuitId) {
            this.virtualCircuitId = virtualCircuitId;
            return this;
        }

        public Builder updateVirtualCircuitDetails(UpdateVirtualCircuitDetails updateVirtualCircuitDetails) {
            this.updateVirtualCircuitDetails = updateVirtualCircuitDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateVirtualCircuitRequest o) {
            this.virtualCircuitId(o.getVirtualCircuitId());
            this.updateVirtualCircuitDetails(o.getUpdateVirtualCircuitDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateVirtualCircuitRequest build() {
            UpdateVirtualCircuitRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateVirtualCircuitDetails body) {
            this.updateVirtualCircuitDetails(body);
            return this;
        }

        public UpdateVirtualCircuitRequest buildWithoutInvocationCallback() {
            UpdateVirtualCircuitRequest request = new UpdateVirtualCircuitRequest();
            request.virtualCircuitId = this.virtualCircuitId;
            request.updateVirtualCircuitDetails = this.updateVirtualCircuitDetails;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

