/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extbrowser.plugins.chrome;

import java.awt.Desktop;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.netbeans.api.extexecution.ExternalProcessBuilder;
import org.netbeans.api.extexecution.input.InputReader;
import org.netbeans.api.extexecution.input.InputReaderTask;
import org.netbeans.api.extexecution.input.InputReaders;
import org.openide.awt.HtmlBrowser;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

final class LinkListener
implements HyperlinkListener {
    private static final Logger LOGGER = Logger.getLogger(LinkListener.class.getName());
    private final RequestProcessor myProcessor = new RequestProcessor(LinkListener.class);

    LinkListener() {
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        block6: {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                final URL url = e.getURL();
                if (url.getProtocol().equals("file")) {
                    try {
                        final Desktop desktop = Desktop.getDesktop();
                        if (desktop.isSupported(Desktop.Action.OPEN)) {
                            this.myProcessor.post(new Runnable(){
                                final /* synthetic */ LinkListener this$0;
                                {
                                    this.this$0 = this$0;
                                }

                                @Override
                                public void run() {
                                    try {
                                        desktop.open(Utilities.toFile((URI)url.toURI()));
                                    }
                                    catch (IOException ex) {
                                        LOGGER.log(Level.FINE, null, ex);
                                        this.this$0.openNativeFileManager(url);
                                    }
                                    catch (URISyntaxException ex) {
                                        LOGGER.log(Level.FINE, null, ex);
                                        this.this$0.openNativeFileManager(url);
                                    }
                                }
                            });
                            break block6;
                        }
                        this.openNativeFileManager(url);
                    }
                    catch (UnsupportedOperationException ex) {
                        LOGGER.log(Level.FINE, null, ex);
                        this.openNativeFileManager(url);
                    }
                } else {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(url);
                }
            }
        }
    }

    private void openNativeFileManager(URL url) {
        String executable;
        if (Utilities.isWindows()) {
            executable = "explorer.exe";
        } else if (Utilities.isMac()) {
            executable = "open";
        } else {
            assert (Utilities.isUnix()) : "Unix expected";
            executable = "xdg-open";
        }
        try {
            Process process = new ExternalProcessBuilder(executable).addArgument(url.toURI().toString()).redirectErrorStream(true).call();
            InputReaderTask task = InputReaderTask.newTask((InputReader)InputReaders.forStream((InputStream)process.getInputStream(), (Charset)Charset.defaultCharset()), null);
            this.myProcessor.post((Runnable)task);
        }
        catch (URISyntaxException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
    }
}

