/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.impl.TaskProcessor;
import org.netbeans.modules.parsing.spi.ParseException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.lookup.Lookups;

public class RunWhenScanFinishedSupport {
    private static final Logger LOG = Logger.getLogger(RunWhenScanFinishedSupport.class.getName());
    private static final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private static final List<DeferredTask> todo = Collections.synchronizedList(new LinkedList());

    private RunWhenScanFinishedSupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void performDeferredTasks() {
        DeferredTask[] deferredTaskArray = todo;
        synchronized (todo) {
            DeferredTask[] _todo = todo.toArray(new DeferredTask[0]);
            todo.clear();
            // ** MonitorExit[var1] (shouldn't be in output)
            for (final DeferredTask rq : _todo) {
                Lookups.executeWith((Lookup)rq.context, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            TaskProcessor.runUserTask(rq.task, rq.sources);
                        }
                        catch (ParseException e) {
                            Exceptions.printStackTrace((Throwable)e);
                        }
                        finally {
                            rq.sync.taskFinished();
                        }
                    }
                });
            }
            return;
        }
    }

    public static void performScan(@NonNull Runnable runnable, @NonNull Lookup context) {
        lock.writeLock().lock();
        try {
            LOG.log(Level.FINE, "performScan:entry", runnable);
            Lookups.executeWith((Lookup)context, (Runnable)runnable);
            LOG.log(Level.FINE, "performScan:exit", runnable);
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public static boolean isScanningThread() {
        return lock.isWriteLockedByCurrentThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static Future<Void> runWhenScanFinished(@NonNull Mutex.ExceptionAction<Void> task, @NonNull Collection<Source> sources) throws ParseException {
        assert (task != null);
        assert (sources != null);
        ScanSync sync = new ScanSync(task);
        DeferredTask r = new DeferredTask(sources, task, sync, Lookup.getDefault());
        todo.add(r);
        boolean indexing = TaskProcessor.getIndexerBridge().isIndexing();
        if (indexing) {
            return sync;
        }
        boolean locked = lock.readLock().tryLock();
        if (locked) {
            try {
                LOG.log(Level.FINE, "runWhenScanFinished:entry", task);
                if (todo.remove(r)) {
                    try {
                        TaskProcessor.runUserTask(task, sources);
                    }
                    finally {
                        sync.taskFinished();
                    }
                }
                LOG.log(Level.FINE, "runWhenScanFinished:exit", task);
            }
            finally {
                lock.readLock().unlock();
            }
        }
        return sync;
    }

    private static final class DeferredTask {
        final Collection<Source> sources;
        final Mutex.ExceptionAction<Void> task;
        final ScanSync sync;
        final Lookup context;

        public DeferredTask(@NonNull Collection<Source> sources, @NonNull Mutex.ExceptionAction<Void> task, @NonNull ScanSync sync, @NonNull Lookup context) {
            assert (sources != null);
            assert (task != null);
            assert (sync != null);
            assert (context != null);
            this.sources = sources;
            this.task = task;
            this.sync = sync;
            this.context = context;
        }
    }

    private static final class ScanSync
    implements Future<Void> {
        private Mutex.ExceptionAction<Void> task;
        private final CountDownLatch sync;
        private final AtomicBoolean canceled;

        public ScanSync(Mutex.ExceptionAction<Void> task) {
            assert (task != null);
            this.task = task;
            this.sync = new CountDownLatch(1);
            this.canceled = new AtomicBoolean(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (this.sync.getCount() == 0L) {
                return false;
            }
            List list = todo;
            synchronized (list) {
                boolean _canceled = this.canceled.getAndSet(true);
                if (!_canceled) {
                    Iterator it = todo.iterator();
                    while (it.hasNext()) {
                        DeferredTask t = (DeferredTask)it.next();
                        if (t.task != this.task) continue;
                        it.remove();
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public boolean isCancelled() {
            return this.canceled.get();
        }

        @Override
        public synchronized boolean isDone() {
            return this.sync.getCount() == 0L;
        }

        @Override
        public Void get() throws InterruptedException, ExecutionException {
            this.checkCaller();
            this.sync.await();
            return null;
        }

        @Override
        public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            this.checkCaller();
            if (!this.sync.await(timeout, unit)) {
                throw new TimeoutException();
            }
            return null;
        }

        private void taskFinished() {
            this.sync.countDown();
        }

        private void checkCaller() {
            if (TaskProcessor.getIndexerBridge().ownsProtectedMode()) {
                throw new IllegalStateException("ScanSync.get called by protected mode owner.");
            }
            boolean ae = false;
            if (!$assertionsDisabled) {
                ae = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            if (ae) {
                for (StackTraceElement stElement : Thread.currentThread().getStackTrace()) {
                    if ("org.netbeans.spi.project.ui.ProjectOpenedHook$1".equals(stElement.getClassName()) && ("projectOpened".equals(stElement.getMethodName()) || "projectClosed".equals(stElement.getMethodName()))) {
                        throw new AssertionError((Object)"Calling ParserManager.parseWhenScanFinished().get() from ProjectOpenedHook");
                    }
                }
            }
        }
    }
}

