/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CredentialRotationStatus
extends ExplicitlySetBmcModel {
    @JsonProperty(value="timeAutoCompletionScheduled")
    private final Date timeAutoCompletionScheduled;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="statusDetails")
    private final StatusDetails statusDetails;

    @Deprecated
    @ConstructorProperties(value={"timeAutoCompletionScheduled", "status", "statusDetails"})
    public CredentialRotationStatus(Date timeAutoCompletionScheduled, Status status, StatusDetails statusDetails) {
        this.timeAutoCompletionScheduled = timeAutoCompletionScheduled;
        this.status = status;
        this.statusDetails = statusDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Date getTimeAutoCompletionScheduled() {
        return this.timeAutoCompletionScheduled;
    }

    public Status getStatus() {
        return this.status;
    }

    public StatusDetails getStatusDetails() {
        return this.statusDetails;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CredentialRotationStatus(");
        sb.append("super=").append(super.toString());
        sb.append("timeAutoCompletionScheduled=").append(String.valueOf(this.timeAutoCompletionScheduled));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", statusDetails=").append(String.valueOf((Object)this.statusDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CredentialRotationStatus)) {
            return false;
        }
        CredentialRotationStatus other = (CredentialRotationStatus)((Object)o);
        return Objects.equals(this.timeAutoCompletionScheduled, other.timeAutoCompletionScheduled) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals((Object)this.statusDetails, (Object)other.statusDetails) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.timeAutoCompletionScheduled == null ? 43 : this.timeAutoCompletionScheduled.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.statusDetails == null ? 43 : this.statusDetails.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum StatusDetails implements BmcEnum
    {
        IssuingNewCredentials("ISSUING_NEW_CREDENTIALS"),
        NewCredentialsIssued("NEW_CREDENTIALS_ISSUED"),
        RetiringOldCredentials("RETIRING_OLD_CREDENTIALS"),
        Completed("COMPLETED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, StatusDetails> map;

        private StatusDetails(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static StatusDetails create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'StatusDetails', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(StatusDetails.class);
            map = new HashMap<String, StatusDetails>();
            for (StatusDetails v : StatusDetails.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Status implements BmcEnum
    {
        InProgress("IN_PROGRESS"),
        Waiting("WAITING"),
        Completed("COMPLETED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeAutoCompletionScheduled")
        private Date timeAutoCompletionScheduled;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="statusDetails")
        private StatusDetails statusDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeAutoCompletionScheduled(Date timeAutoCompletionScheduled) {
            this.timeAutoCompletionScheduled = timeAutoCompletionScheduled;
            this.__explicitlySet__.add("timeAutoCompletionScheduled");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder statusDetails(StatusDetails statusDetails) {
            this.statusDetails = statusDetails;
            this.__explicitlySet__.add("statusDetails");
            return this;
        }

        public CredentialRotationStatus build() {
            CredentialRotationStatus model = new CredentialRotationStatus(this.timeAutoCompletionScheduled, this.status, this.statusDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CredentialRotationStatus model) {
            if (model.wasPropertyExplicitlySet("timeAutoCompletionScheduled")) {
                this.timeAutoCompletionScheduled(model.getTimeAutoCompletionScheduled());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("statusDetails")) {
                this.statusDetails(model.getStatusDetails());
            }
            return this;
        }
    }
}

