/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.graph;

import java.util.List;
import java.util.Set;
import javax.swing.Action;
import org.apache.maven.artifact.Artifact;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.graph.DependencyGraphScene;
import org.netbeans.modules.java.graph.GraphNode;
import org.netbeans.modules.maven.api.CommonArtifactActions;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.graph.Bundle;
import org.netbeans.modules.maven.graph.DependencyGraphTopComponent;
import org.netbeans.modules.maven.graph.ExcludeDepAction;
import org.netbeans.modules.maven.graph.FixVersionConflictAction;
import org.netbeans.modules.maven.graph.MavenDependencyNode;
import org.netbeans.modules.maven.model.pom.POMModel;

public class MavenActionsProvider
implements DependencyGraphScene.ActionsProvider<MavenDependencyNode> {
    private final Project project;
    private final POMModel model;
    private final DependencyGraphTopComponent ownerTC;

    public MavenActionsProvider(DependencyGraphTopComponent ownerTC, Project project, POMModel model) {
        this.project = project;
        this.model = model;
        this.ownerTC = ownerTC;
    }

    public Action createExcludeDepAction(DependencyGraphScene scene, GraphNode<MavenDependencyNode> rootNode, GraphNode<MavenDependencyNode> node) {
        return this.model != null && node.getPrimaryLevel() > 1 ? new ExcludeDepAction(this.ownerTC, scene, rootNode, node, this.model, this.project) : null;
    }

    public Action createFixVersionConflictAction(DependencyGraphScene scene, GraphNode<MavenDependencyNode> rootNode, GraphNode<MavenDependencyNode> node) {
        return this.model != null && MavenActionsProvider.isFixCandidate(node) ? new FixVersionConflictAction(this.ownerTC, scene, rootNode, node, this.model, this.project) : null;
    }

    public Action createShowGraphAction(GraphNode<MavenDependencyNode> node) {
        Action a = CommonArtifactActions.createViewArtifactDetails((Artifact)((MavenDependencyNode)node.getImpl()).getArtifact(), (List)((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).getMavenProject().getRemoteArtifactRepositories());
        a.putValue("PANEL_HINT", "grf");
        a.putValue("Name", Bundle.ACT_Show_Graph());
        return a;
    }

    static boolean isFixCandidate(GraphNode<MavenDependencyNode> node) {
        Set conf = node.getDuplicatesOrConflicts();
        for (MavenDependencyNode dn : conf) {
            if (dn.getState() != 2 || ((MavenDependencyNode)node.getImpl()).compareVersions(dn) >= 0) continue;
            return true;
        }
        return false;
    }
}

