/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.visual.breakpoints;

import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LongValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.util.List;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.expr.JDIVariable;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.IntegerValueWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LongValueWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.StackFrameWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.TypeComponentWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.visual.breakpoints.BaseComponentBreakpointImpl;
import org.netbeans.modules.debugger.jpda.visual.breakpoints.ComponentBreakpoint;
import org.openide.util.Exceptions;

public class AWTComponentBreakpointImpl
extends BaseComponentBreakpointImpl {
    public AWTComponentBreakpointImpl(ComponentBreakpoint cb, JPDADebugger debugger) {
        super(cb, debugger);
    }

    @Override
    protected void initServiceBreakpoints() {
        ObjectReference component = this.cb.getComponent().getComponent(this.debugger);
        Variable variableComponent = ((JPDADebuggerImpl)this.debugger).getVariable((Value)component);
        final int type = this.cb.getType();
        if ((type & 1) != 0 || (type & 2) != 0) {
            MethodBreakpoint mb = MethodBreakpoint.create((String)"java.awt.Component", (String)"createHierarchyEvents");
            mb.setHidden(true);
            mb.setInstanceFilters(this.debugger, new ObjectVariable[]{(ObjectVariable)variableComponent});
            mb.addJPDABreakpointListener(new JPDABreakpointListener(){
                final /* synthetic */ AWTComponentBreakpointImpl this$0;
                {
                    this.this$0 = this$0;
                }

                public void breakpointReached(JPDABreakpointEvent event) {
                    ObjectReference component;
                    ObjectReference[] parentPtr = null;
                    if ((type & 1) == 0) {
                        parentPtr = new ObjectReference[]{null};
                    }
                    if ((type & 2) == 0) {
                        parentPtr = new ObjectReference[]{null};
                    }
                    if ((component = AWTComponentBreakpointImpl.getComponentOfParentChanged(event, parentPtr)) == null || (type & 1) == 0 && parentPtr == null || (type & 2) == 0 && parentPtr != null) {
                        event.resume();
                    } else {
                        this.this$0.navigateToCustomCode(event.getThread());
                    }
                }
            });
            if (!this.cb.isEnabled()) {
                mb.disable();
            }
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)mb);
            this.serviceBreakpoints.add(mb);
        }
        if ((type & 4) != 0 || (type & 8) != 0) {
            MethodBreakpoint mbShow = MethodBreakpoint.create((String)"java.awt.Component", (String)"show");
            mbShow.setMethodSignature("()V");
            this.addMethodBreakpoint(mbShow, (ObjectVariable)variableComponent);
            MethodBreakpoint mbHide = MethodBreakpoint.create((String)"java.awt.Component", (String)"hide");
            mbHide.setMethodSignature("()V");
            this.addMethodBreakpoint(mbHide, (ObjectVariable)variableComponent);
            if (!this.cb.isEnabled()) {
                mbShow.disable();
                mbHide.disable();
            }
        }
        if ((type & 0x10) != 0) {
            Value value;
            String componentClassName = null;
            if (variableComponent instanceof JDIVariable && (value = ((JDIVariable)variableComponent).getJDIValue()) instanceof ObjectReference) {
                componentClassName = this.findClassWithMethod((ObjectReference)value, "repaint", "(JIIII)V");
            }
            if (componentClassName == null) {
                componentClassName = "java.awt.Component";
            }
            MethodBreakpoint mbShow = MethodBreakpoint.create((String)componentClassName, (String)"repaint");
            mbShow.setMethodSignature("(JIIII)V");
            mbShow.setHidden(true);
            mbShow.setInstanceFilters(this.debugger, new ObjectVariable[]{(ObjectVariable)variableComponent});
            mbShow.addJPDABreakpointListener(new JPDABreakpointListener(){

                public void breakpointReached(JPDABreakpointEvent event) {
                    AWTComponentBreakpointImpl.this.navigateToCustomCode(event.getThread());
                }
            });
            if (!this.cb.isEnabled()) {
                mbShow.disable();
            }
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)mbShow);
            this.serviceBreakpoints.add(mbShow);
        }
    }

    public static ObjectReference getComponentOfParentChanged(JPDABreakpointEvent event, ObjectReference[] parentPtr) {
        ThreadReference tr = ((JPDAThreadImpl)event.getThread()).getThreadReference();
        try {
            StackFrame frame = ThreadReferenceWrapper.frame((ThreadReference)tr, (int)0);
            List argumentValues = StackFrameWrapper.getArgumentValues0((StackFrame)frame);
            if (argumentValues.size() < 4) {
                return null;
            }
            Value idValue = (Value)argumentValues.get(0);
            if (!(idValue instanceof IntegerValue) || 1400 != IntegerValueWrapper.value((IntegerValue)((IntegerValue)idValue))) {
                return null;
            }
            Value changeFlags = (Value)argumentValues.get(3);
            if (!(changeFlags instanceof LongValue) || (LongValueWrapper.value((LongValue)((LongValue)changeFlags)) & 1L) == 0L) {
                return null;
            }
            ObjectReference component = (ObjectReference)argumentValues.get(1);
            if (parentPtr != null) {
                List componentClassesByName = VirtualMachineWrapper.classesByName((VirtualMachine)tr.virtualMachine(), (String)"java.awt.Component");
                try {
                    Field parent = ReferenceTypeWrapper.fieldByName((ReferenceType)((ReferenceType)componentClassesByName.get(0)), (String)"parent");
                    if (parent != null) {
                        parentPtr[0] = (ObjectReference)ObjectReferenceWrapper.getValue((ObjectReference)component, (Field)parent);
                    }
                }
                catch (ClassNotPreparedExceptionWrapper ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return component;
        }
        catch (IncompatibleThreadStateException e) {
            return null;
        }
        catch (IllegalThreadStateExceptionWrapper e) {
            return null;
        }
        catch (InvalidStackFrameExceptionWrapper e) {
            return null;
        }
        catch (InternalExceptionWrapper e) {
            return null;
        }
        catch (ObjectCollectedExceptionWrapper ocex) {
            return null;
        }
        catch (VMDisconnectedExceptionWrapper e) {
            return null;
        }
    }

    private String findClassWithMethod(ObjectReference value, String name, String signature) {
        try {
            ReferenceType referenceType = ObjectReferenceWrapper.referenceType((ObjectReference)value);
            List methods = ReferenceTypeWrapper.methodsByName((ReferenceType)referenceType, (String)name, (String)signature);
            if (!methods.isEmpty()) {
                return ReferenceTypeWrapper.name((ReferenceType)TypeComponentWrapper.declaringType((TypeComponent)((TypeComponent)methods.get(0))));
            }
        }
        catch (ClassNotPreparedExceptionWrapper classNotPreparedExceptionWrapper) {
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            // empty catch block
        }
        return null;
    }
}

