/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.project.api.ant.ui;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.common.ClasspathUtil;
import org.netbeans.modules.j2ee.deployment.devmodules.api.AntDeploymentHelper;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.javaee.specs.support.api.JaxWs;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.websvc.wsstack.api.WSTool;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class J2EEProjectProperties {
    public static final String J2EE_PLATFORM_CLASSPATH = "j2ee.platform.classpath";
    public static final String J2EE_SERVER_HOME = "j2ee.server.home";
    public static final String J2EE_DOMAIN_HOME = "j2ee.server.domain";
    public static final String J2EE_MIDDLEWARE_HOME = "j2ee.server.middleware";
    public static final String J2EE_SERVER_INSTANCE = "j2ee.server.instance";
    public static final String J2EE_SERVER_TYPE = "j2ee.server.type";
    public static final String J2EE_PLATFORM_EMBEDDABLE_EJB_CLASSPATH = "j2ee.platform.embeddableejb.classpath";
    public static final String ANT_DEPLOY_BUILD_SCRIPT = "nbproject/ant-deploy.xml";
    public static final String DEPLOY_ANT_PROPS_FILE = "deploy.ant.properties.file";
    public static final String J2EE_PLATFORM_WSCOMPILE_CLASSPATH = "j2ee.platform.wscompile.classpath";
    public static final String J2EE_PLATFORM_JWSDP_CLASSPATH = "j2ee.platform.jwsdp.classpath";
    public static final String J2EE_PLATFORM_WSIT_CLASSPATH = "j2ee.platform.wsit.classpath";
    public static final String J2EE_PLATFORM_WSGEN_CLASSPATH = "j2ee.platform.wsgen.classpath";
    public static final String J2EE_PLATFORM_WSIMPORT_CLASSPATH = "j2ee.platform.wsimport.classpath";
    public static final String J2EE_PLATFORM_JSR109_SUPPORT = "j2ee.platform.is.jsr109";
    private static final Logger LOGGER = Logger.getLogger(J2EEProjectProperties.class.getName());

    public static void removeObsoleteLibraryLocations(EditableProperties privateProps) {
        Iterator propKeys = privateProps.keySet().iterator();
        while (propKeys.hasNext()) {
            String key = (String)propKeys.next();
            if (!key.endsWith(".libdirs") && !key.endsWith(".libfiles") && key.indexOf(".libdir.") <= 0 && key.indexOf(".libfile.") <= 0) continue;
            propKeys.remove();
        }
    }

    public static void setServerProperties(EditableProperties ep, EditableProperties epPriv, ClassPathSupport cs, Iterable<ClassPathSupport.Item> items, String serverInstanceID, Profile j2eeProfile, J2eeModule.Type moduleType) {
        J2EEProjectProperties.setServerProperties(null, ep, epPriv, cs, items, serverInstanceID, j2eeProfile, moduleType);
    }

    @CheckForNull
    public static String getMatchingInstance(String serverType, J2eeModule.Type moduleType, Profile profile) {
        String[] servInstIDs;
        for (String instanceID : servInstIDs = Deployment.getDefault().getInstancesOfServer(serverType)) {
            try {
                J2eePlatform platformLocal = Deployment.getDefault().getServerInstance(instanceID).getJ2eePlatform();
                if (!platformLocal.getSupportedProfiles(moduleType).contains(profile)) continue;
                return instanceID;
            }
            catch (InstanceRemovedException ex) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean checkSelectedServer(@NonNull Project project, @NonNull AntProjectHelper helper, @NonNull Profile profile, @NonNull J2eeModule.Type moduleType, @NullAllowed SetServerInstanceCallback callback, boolean checkDebug, boolean checkProfile, boolean noMessages) {
        String instanceID;
        String serverType;
        String id;
        J2eeModuleProvider jmp;
        String sdi;
        PropertyEvaluator eval = helper.getStandardPropertyEvaluator();
        String instanceId = null;
        String instance = eval.getProperty(J2EE_SERVER_INSTANCE);
        if (instance != null && (sdi = (jmp = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class)).getServerInstanceID()) != null && (id = Deployment.getDefault().getServerID(sdi)) != null) {
            instanceId = sdi;
        }
        if (instanceId == null && (serverType = eval.getProperty(J2EE_SERVER_TYPE)) != null && (instanceID = J2EEProjectProperties.getMatchingInstance(serverType, moduleType, profile)) != null && callback != null) {
            callback.setServerInstance(instanceID);
            instanceId = instanceID;
        }
        if (instanceId != null) {
            try {
                String msg;
                ServerInstance instanceObject = Deployment.getDefault().getServerInstance(instanceId);
                if (checkDebug && !instanceObject.isDebuggingSupported()) {
                    if (!noMessages) {
                        msg = NbBundle.getMessage(J2EEProjectProperties.class, (String)"MSG_Server_No_Debugging");
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 2));
                    }
                    return false;
                }
                if (checkProfile && !instanceObject.isProfilingSupported()) {
                    if (!noMessages) {
                        msg = NbBundle.getMessage(J2EEProjectProperties.class, (String)"MSG_Server_No_Profiling");
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 2));
                    }
                    return false;
                }
            }
            catch (InstanceRemovedException ex) {
                instanceId = null;
            }
        }
        if (instanceId == null) {
            if (!noMessages) {
                String msg = NbBundle.getMessage(J2EEProjectProperties.class, (String)"MSG_No_Server_Selected");
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 2));
            }
            return false;
        }
        return true;
    }

    private static void setServerProperties(Project project, EditableProperties ep, EditableProperties epPriv, ClassPathSupport cs, Iterable<ClassPathSupport.Item> items, String serverInstanceID, Profile j2eeProfile, J2eeModule.Type moduleType) {
        Deployment deployment = Deployment.getDefault();
        String serverType = deployment.getServerID(serverInstanceID);
        J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(serverInstanceID);
        if (!j2eePlatform.getSupportedProfiles(moduleType).contains(j2eeProfile)) {
            Logger.getLogger("global").log(Level.WARNING, "J2EE level: {0} not supported by server {1} for module type WAR", new Object[]{j2eeProfile != null ? j2eeProfile.getDisplayName() : "Unknown J2EE profile version - ", Deployment.getDefault().getServerInstanceDisplayName(serverInstanceID)});
        }
        ep.setProperty(J2EE_SERVER_TYPE, serverType);
        epPriv.setProperty(J2EE_SERVER_INSTANCE, serverInstanceID);
        Map<String, String> roots = J2EEProjectProperties.extractPlatformLibrariesRoot(j2eePlatform);
        if (roots != null) {
            J2EEProjectProperties.setLocalServerProperties(project, epPriv, ep, j2eePlatform, roots);
        } else {
            J2EEProjectProperties.setLocalServerProperties(project, ep, epPriv, j2eePlatform, null);
        }
        if (j2eePlatform.isToolSupported("jsr109")) {
            epPriv.setProperty(J2EE_PLATFORM_JSR109_SUPPORT, "true");
        }
    }

    public static void createDeploymentScript(FileObject dirFO, EditableProperties ep, EditableProperties epPriv, String serverInstanceID, J2eeModule.Type moduleType) {
        File projectFolder = FileUtil.toFile((FileObject)dirFO);
        try {
            AntDeploymentHelper.writeDeploymentScript((File)new File(projectFolder, ANT_DEPLOY_BUILD_SCRIPT), (Object)moduleType, (String)serverInstanceID);
        }
        catch (IOException ioe) {
            Logger.getLogger("global").log(Level.INFO, null, ioe);
        }
        File deployAntPropsFile = AntDeploymentHelper.getDeploymentPropertiesFile((String)serverInstanceID);
        if (deployAntPropsFile != null) {
            epPriv.setProperty(DEPLOY_ANT_PROPS_FILE, deployAntPropsFile.getAbsolutePath());
        }
    }

    public static void updateServerProperties(EditableProperties projectProps, EditableProperties privateProps, String newServInstID, ClassPathSupport cs, Iterable<ClassPathSupport.Item> items, Callback callback, Project proj, Profile profile, J2eeModule.Type moduleType) {
        J2eePlatform j2eePlatform;
        J2eePlatform oldJ2eePlatform;
        assert (newServInstID != null) : "Server isntance id to set can't be null";
        String oldServInstID = privateProps.getProperty(J2EE_SERVER_INSTANCE);
        if (oldServInstID != null && (oldJ2eePlatform = Deployment.getDefault().getJ2eePlatform(oldServInstID)) != null) {
            callback.unregisterJ2eePlatformListener(oldJ2eePlatform);
        }
        if ((j2eePlatform = Deployment.getDefault().getJ2eePlatform(newServInstID)) == null) {
            Logger.getLogger("global").log(Level.INFO, "J2EE platform is null.");
            privateProps.setProperty(J2EE_SERVER_INSTANCE, newServInstID);
            J2EEProjectProperties.removeServerClasspathProperties(privateProps);
            privateProps.remove((Object)J2EE_PLATFORM_JSR109_SUPPORT);
            privateProps.remove((Object)DEPLOY_ANT_PROPS_FILE);
            return;
        }
        callback.registerJ2eePlatformListener(j2eePlatform);
        J2EEProjectProperties.setServerProperties(proj, projectProps, privateProps, cs, items, newServInstID, profile, moduleType);
        J2EEProjectProperties.createDeploymentScript(proj.getProjectDirectory(), projectProps, privateProps, newServInstID, moduleType);
    }

    private static void removeServerClasspathProperties(EditableProperties ep) {
        ep.remove((Object)J2EE_PLATFORM_CLASSPATH);
        ep.remove((Object)J2EE_PLATFORM_EMBEDDABLE_EJB_CLASSPATH);
        ep.remove((Object)J2EE_PLATFORM_WSCOMPILE_CLASSPATH);
        ep.remove((Object)J2EE_PLATFORM_WSIMPORT_CLASSPATH);
        ep.remove((Object)J2EE_PLATFORM_WSGEN_CLASSPATH);
        ep.remove((Object)J2EE_PLATFORM_WSIT_CLASSPATH);
        ep.remove((Object)J2EE_PLATFORM_JWSDP_CLASSPATH);
        ep.remove((Object)J2EE_SERVER_HOME);
    }

    private static void setLocalServerProperties(Project project, EditableProperties epToClean, EditableProperties epTarget, J2eePlatform j2eePlatform, Map<String, String> roots) {
        File[] wsClasspath;
        WSTool wsTool;
        WSStack wsStack;
        J2EEProjectProperties.removeServerClasspathProperties(epTarget);
        String classpath = J2EEProjectProperties.toClasspathString(ClasspathUtil.getJ2eePlatformClasspathEntries((Project)project, (J2eePlatform)j2eePlatform), roots);
        epTarget.setProperty(J2EE_PLATFORM_CLASSPATH, classpath);
        if (j2eePlatform.isToolSupported("embeddableejb")) {
            File[] ejbClasspath = j2eePlatform.getToolClasspathEntries("embeddableejb");
            epTarget.setProperty(J2EE_PLATFORM_EMBEDDABLE_EJB_CLASSPATH, J2EEProjectProperties.toClasspathString(ejbClasspath, roots));
        }
        if (j2eePlatform.isToolSupported("wscompile")) {
            File[] wsClasspath2 = j2eePlatform.getToolClasspathEntries("wscompile");
            epTarget.setProperty(J2EE_PLATFORM_WSCOMPILE_CLASSPATH, J2EEProjectProperties.toClasspathString(wsClasspath2, roots));
        }
        if ((wsStack = WSStack.findWSStack((Lookup)j2eePlatform.getLookup(), JaxWs.class)) != null && (wsTool = wsStack.getWSTool((WSStack.Tool)JaxWs.Tool.WSIMPORT)) != null && wsTool.getLibraries().length > 0) {
            String librariesList = J2EEProjectProperties.toClasspathString(wsTool.getLibraries(), roots);
            epTarget.setProperty(J2EE_PLATFORM_WSGEN_CLASSPATH, librariesList);
            epTarget.setProperty(J2EE_PLATFORM_WSIMPORT_CLASSPATH, librariesList);
        }
        if (j2eePlatform.isToolSupported("wsit")) {
            wsClasspath = j2eePlatform.getToolClasspathEntries("wsit");
            epTarget.setProperty(J2EE_PLATFORM_WSIT_CLASSPATH, J2EEProjectProperties.toClasspathString(wsClasspath, roots));
        }
        if (j2eePlatform.isToolSupported("jwsdp")) {
            wsClasspath = j2eePlatform.getToolClasspathEntries("jwsdp");
            epTarget.setProperty(J2EE_PLATFORM_JWSDP_CLASSPATH, J2EEProjectProperties.toClasspathString(wsClasspath, roots));
        }
        J2EEProjectProperties.removeServerClasspathProperties(epToClean);
        if (roots != null) {
            for (Map.Entry<String, String> entry : roots.entrySet()) {
                epToClean.setProperty(entry.getValue(), entry.getKey());
            }
        }
    }

    public static Map<String, String> extractPlatformLibrariesRoot(J2eePlatform j2eePlatform) {
        FileObject middleware;
        File middlewareFile;
        FileObject domain;
        File domainFile;
        FileObject server;
        HashSet<FileObject> toCheck = new HashSet<FileObject>();
        HashMap<String, String> roots = new HashMap<String, String>();
        File serverFile = j2eePlatform.getServerHome();
        if (serverFile != null && (server = FileUtil.toFileObject((File)(serverFile = FileUtil.normalizeFile((File)serverFile)))) != null) {
            roots.put(serverFile.getAbsolutePath().replace('\\', '/'), J2EE_SERVER_HOME);
            toCheck.add(server);
        }
        if ((domainFile = j2eePlatform.getDomainHome()) != null && (domain = FileUtil.toFileObject((File)(domainFile = FileUtil.normalizeFile((File)domainFile)))) != null) {
            roots.put(domainFile.getAbsolutePath().replace('\\', '/'), J2EE_DOMAIN_HOME);
            toCheck.add(domain);
        }
        if ((middlewareFile = j2eePlatform.getMiddlewareHome()) != null && (middleware = FileUtil.toFileObject((File)(middlewareFile = FileUtil.normalizeFile((File)middlewareFile)))) != null) {
            roots.put(middlewareFile.getAbsolutePath().replace('\\', '/'), J2EE_MIDDLEWARE_HOME);
            toCheck.add(middleware);
        }
        if (roots.isEmpty()) {
            return J2EEProjectProperties.extractPlatformLibrariesRootHeuristic(j2eePlatform);
        }
        boolean ok = true;
        for (File file : j2eePlatform.getClasspathEntries()) {
            FileObject fo = FileUtil.toFileObject((File)file);
            if (fo == null) continue;
            boolean hit = false;
            for (FileObject root : toCheck) {
                if (!FileUtil.isParentOf((FileObject)root, (FileObject)fo)) continue;
                hit = true;
                break;
            }
            if (hit) continue;
            ok = false;
            break;
        }
        if (!ok) {
            return null;
        }
        return roots;
    }

    private static Map<String, String> extractPlatformLibrariesRootHeuristic(J2eePlatform j2eePlatform) {
        if (j2eePlatform.getPlatformRoots() == null || j2eePlatform.getPlatformRoots().length == 0) {
            return null;
        }
        File rootFile = FileUtil.normalizeFile((File)j2eePlatform.getPlatformRoots()[0]);
        FileObject root = FileUtil.toFileObject((File)rootFile);
        if (root == null) {
            return null;
        }
        boolean ok = true;
        for (File file : j2eePlatform.getClasspathEntries()) {
            FileObject fo = FileUtil.toFileObject((File)file);
            if (fo == null || FileUtil.isParentOf((FileObject)root, (FileObject)fo)) continue;
            ok = false;
            break;
        }
        if (!ok) {
            return null;
        }
        return Collections.singletonMap(rootFile.getAbsolutePath().replace('\\', '/'), J2EE_SERVER_HOME);
    }

    public static String toClasspathString(File[] classpathEntries, Map<String, String> roots) {
        if (classpathEntries == null) {
            return "";
        }
        StringBuilder classpath = new StringBuilder();
        for (int i = 0; i < classpathEntries.length; ++i) {
            String path = classpathEntries[i].getAbsolutePath().replace('\\', '/');
            if (roots != null) {
                Map.Entry<String, String> replacement = null;
                for (Map.Entry<String, String> entry : roots.entrySet()) {
                    if (!path.startsWith(entry.getKey()) || replacement != null && ((String)replacement.getKey()).length() >= entry.getKey().length()) continue;
                    replacement = entry;
                }
                if (replacement != null) {
                    path = "${" + (String)replacement.getValue() + "}" + path.substring(replacement.getKey().length());
                }
            }
            if (classpath.length() > 0) {
                classpath.append(':');
            }
            classpath.append(path);
        }
        return classpath.toString();
    }

    private static String toClasspathString(URL[] classpathEntries, Map<String, String> roots) {
        if (classpathEntries == null) {
            return "";
        }
        ArrayList<File> files = new ArrayList<File>();
        for (URL url : classpathEntries) {
            try {
                File file = new File(url.toURI()).getAbsoluteFile();
                files.add(file);
            }
            catch (URISyntaxException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
        }
        return J2EEProjectProperties.toClasspathString(files.toArray(new File[0]), roots);
    }

    public static interface SetServerInstanceCallback {
        public void setServerInstance(String var1);
    }

    public static interface Callback {
        public void registerJ2eePlatformListener(J2eePlatform var1);

        public void unregisterJ2eePlatformListener(J2eePlatform var1);
    }
}

