/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.support.CancellableTreeScanner;
import org.netbeans.api.java.source.support.ErrorAwareTreeScanner;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.api.InlineRefactoring;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.plugins.Bundle;
import org.netbeans.modules.refactoring.java.plugins.InlineMethodTransformer;
import org.netbeans.modules.refactoring.java.plugins.InlineVariableTransformer;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;

public class InlineRefactoringPlugin
extends JavaRefactoringPlugin {
    private static final List<Tree.Kind> unary = Arrays.asList(Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.PREFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT);
    private final InlineRefactoring refactoring;
    private TreePathHandle treePathHandle;
    private Set<ElementHandle<ExecutableElement>> allMethods;

    public InlineRefactoringPlugin(InlineRefactoring refactoring) {
        this.refactoring = refactoring;
        this.treePathHandle = (TreePathHandle)refactoring.getRefactoringSource().lookup(TreePathHandle.class);
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase p) {
        if (this.treePathHandle == null) {
            return null;
        }
        switch (p) {
            case PRECHECK: 
            case FASTCHECKPARAMETERS: {
                return JavaSource.forFileObject((FileObject)this.treePathHandle.getFileObject());
            }
            case CHECKPARAMETERS: {
                ClasspathInfo classpathInfo = this.getClasspathInfo(this.refactoring);
                JavaSource source = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[]{this.treePathHandle.getFileObject()});
                return source;
            }
        }
        throw new IllegalStateException();
    }

    protected ClasspathInfo getClasspathInfo(Set<FileObject> a) {
        ClasspathInfo cpInfo = JavaRefactoringUtils.getClasspathInfoFor(a.toArray(new FileObject[0]));
        return cpInfo;
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        RefactoringVisitor visitor;
        if (this.treePathHandle == null) {
            return null;
        }
        switch (this.refactoring.getType()) {
            case METHOD: {
                visitor = new InlineMethodTransformer(this.treePathHandle);
                break;
            }
            case CONSTANT: 
            case TEMP: {
                visitor = new InlineVariableTransformer(this.treePathHandle);
                break;
            }
            default: {
                return null;
            }
        }
        Set<FileObject> a = this.getRelevantFiles();
        this.fireProgressListenerStart(3, a.size());
        JavaRefactoringPlugin.TransformTask transform = new JavaRefactoringPlugin.TransformTask(this, visitor, this.treePathHandle);
        Problem problem = this.createAndAddElements(a, transform, refactoringElements, this.refactoring, this.getClasspathInfo(a));
        this.fireProgressListenerStop();
        if (visitor instanceof InlineMethodTransformer) {
            RefactoringVisitor imt = visitor;
            problem = problem != null ? problem : ((InlineMethodTransformer)imt).getProblem();
        }
        return problem;
    }

    private Set<FileObject> getRelevantFiles() {
        ClasspathInfo cpInfo = this.getClasspathInfo(this.refactoring);
        final HashSet<FileObject> set = new HashSet<FileObject>();
        JavaSource source = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[]{this.treePathHandle.getFileObject()});
        try {
            source.runUserActionTask((Task)new Task<CompilationController>(){
                final /* synthetic */ InlineRefactoringPlugin this$0;
                {
                    this.this$0 = this$0;
                }

                public void run(CompilationController info) throws Exception {
                    ClassIndex idx = info.getClasspathInfo().getClassIndex();
                    info.toPhase(JavaSource.Phase.RESOLVED);
                    Element el = this.this$0.treePathHandle.resolveElement((CompilationInfo)info);
                    ElementHandle enclosingType = el instanceof TypeElement ? ElementHandle.create((Element)((TypeElement)el)) : ElementHandle.create((Element)info.getElementUtilities().enclosingTypeElement(el));
                    set.add(SourceUtils.getFile((ElementHandle)enclosingType, (ClasspathInfo)info.getClasspathInfo()));
                    if (el.getModifiers().contains((Object)Modifier.PRIVATE)) {
                        if (el.getKind() == ElementKind.METHOD) {
                            this.this$0.allMethods = new HashSet<ElementHandle<ExecutableElement>>();
                            this.this$0.allMethods.add((ElementHandle<ExecutableElement>)ElementHandle.create((Element)((ExecutableElement)el)));
                        }
                    } else if (el.getKind().isField()) {
                        set.addAll(idx.getResources(enclosingType, EnumSet.of(ClassIndex.SearchKind.FIELD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                    } else if (el instanceof TypeElement) {
                        set.addAll(idx.getResources(enclosingType, EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES, ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                    } else if (el.getKind() == ElementKind.METHOD) {
                        this.this$0.allMethods = new HashSet<ElementHandle<ExecutableElement>>();
                        this.this$0.allMethods.add((ElementHandle<ExecutableElement>)ElementHandle.create((Element)((ExecutableElement)el)));
                        for (ExecutableElement e : JavaRefactoringUtils.getOverridingMethods((ExecutableElement)el, (CompilationInfo)info, this.this$0.cancelRequested)) {
                            this.this$0.addMethods(e, set, (CompilationInfo)info, idx);
                        }
                        for (ExecutableElement ov : JavaRefactoringUtils.getOverriddenMethods((ExecutableElement)el, (CompilationInfo)info)) {
                            this.this$0.addMethods(ov, set, (CompilationInfo)info, idx);
                            for (ExecutableElement e : JavaRefactoringUtils.getOverridingMethods(ov, (CompilationInfo)info, this.this$0.cancelRequested)) {
                                this.this$0.addMethods(e, set, (CompilationInfo)info, idx);
                            }
                        }
                        set.addAll(idx.getResources(enclosingType, EnumSet.of(ClassIndex.SearchKind.METHOD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                    }
                }
            }, true);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return set;
    }

    private void addMethods(ExecutableElement e, Set set, CompilationInfo info, ClassIndex idx) {
        ElementHandle encl = ElementHandle.create((Element)info.getElementUtilities().enclosingTypeElement((Element)e));
        set.add(SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)e), (ClasspathInfo)info.getClasspathInfo()));
        set.addAll(idx.getResources(encl, EnumSet.of(ClassIndex.SearchKind.METHOD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
        this.allMethods.add((ElementHandle<ExecutableElement>)ElementHandle.create((Element)e));
    }

    @Override
    protected Problem checkParameters(CompilationController javac) throws IOException {
        javac.toPhase(JavaSource.Phase.RESOLVED);
        Problem problem = InlineRefactoringPlugin.isElementAvail(this.treePathHandle, (CompilationInfo)javac);
        return problem;
    }

    @Override
    protected Problem preCheck(CompilationController javac) throws IOException {
        Problem preCheckProblem = null;
        javac.toPhase(JavaSource.Phase.RESOLVED);
        Element element = this.treePathHandle.resolveElement((CompilationInfo)javac);
        preCheckProblem = InlineRefactoringPlugin.isElementAvail(this.treePathHandle, (CompilationInfo)javac);
        if (preCheckProblem != null) {
            return preCheckProblem;
        }
        preCheckProblem = JavaPluginUtils.isSourceElement(element, (CompilationInfo)javac);
        if (preCheckProblem != null) {
            return preCheckProblem;
        }
        switch (element.getKind()) {
            case FIELD: 
            case LOCAL_VARIABLE: {
                NewArrayTree newArrayTree;
                UnsafeTreeScanner scanner;
                Boolean isChanged;
                VariableTree variableTree;
                Tree tree = javac.getTrees().getTree(element);
                if (tree.getKind() != Tree.Kind.VARIABLE) {
                    preCheckProblem = InlineRefactoringPlugin.createProblem(preCheckProblem, true, Bundle.ERR_InlineWrongType(element.getKind().toString()));
                }
                if ((variableTree = (VariableTree)tree).getInitializer() == null) {
                    preCheckProblem = InlineRefactoringPlugin.createProblem(preCheckProblem, true, Bundle.ERR_InlineNoVarInitializer());
                    return preCheckProblem;
                }
                if (variableTree.getInitializer().getKind() == Tree.Kind.NULL_LITERAL) {
                    preCheckProblem = InlineRefactoringPlugin.createProblem(preCheckProblem, true, Bundle.ERR_InlineNullVarInitializer());
                    return preCheckProblem;
                }
                InlineUsageVisitor visitor = new InlineUsageVisitor(javac, element);
                TreePath elementPath = javac.getTrees().getPath(element);
                TreePath blockPath = elementPath.getParentPath();
                visitor.scan(blockPath.getLeaf(), blockPath);
                if (visitor.assignmentCount > 0) {
                    preCheckProblem = InlineRefactoringPlugin.createProblem(preCheckProblem, true, Bundle.ERR_InlineAssignedOnce());
                    return preCheckProblem;
                }
                ExpressionTree initializer = variableTree.getInitializer();
                int skipFirstMethodInvocation = 0;
                if (initializer.getKind() == Tree.Kind.METHOD_INVOCATION) {
                    ++skipFirstMethodInvocation;
                }
                if ((isChanged = (Boolean)(scanner = new UnsafeTreeScanner(skipFirstMethodInvocation)).scan(initializer, false)) != null && isChanged.booleanValue()) {
                    preCheckProblem = InlineRefactoringPlugin.createProblem(preCheckProblem, false, Bundle.WRN_InlineChange());
                }
                TreePath treePath = this.treePathHandle.resolve((CompilationInfo)javac);
                Tree loop = (treePath = treePath.getParentPath()).getLeaf();
                if (loop.getKind() == Tree.Kind.ENHANCED_FOR_LOOP || loop.getKind() == Tree.Kind.FOR_LOOP) {
                    preCheckProblem = InlineRefactoringPlugin.createProblem(preCheckProblem, true, Bundle.ERR_InlineNotInIterator());
                    return preCheckProblem;
                }
                if (variableTree.getInitializer().getKind() != Tree.Kind.NEW_ARRAY || (newArrayTree = (NewArrayTree)variableTree.getInitializer()).getType() != null && newArrayTree.getDimensions() != null) break;
                preCheckProblem = InlineRefactoringPlugin.createProblem(preCheckProblem, true, Bundle.ERR_InlineNotCompoundArrayInit());
                return preCheckProblem;
            }
            case METHOD: {
                if (element.getEnclosingElement().getKind().isInterface()) {
                    preCheckProblem = InlineRefactoringPlugin.createProblem(preCheckProblem, true, Bundle.ERR_InlineMethodInInterface());
                    return preCheckProblem;
                }
                if (element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                    preCheckProblem = InlineRefactoringPlugin.createProblem(preCheckProblem, true, Bundle.ERR_InlineMethodAbstract());
                    return preCheckProblem;
                }
                Collection<ExecutableElement> overridenMethods = JavaRefactoringUtils.getOverriddenMethods((ExecutableElement)element, (CompilationInfo)javac);
                Collection<ExecutableElement> overridingMethods = JavaRefactoringUtils.getOverridingMethods((ExecutableElement)element, (CompilationInfo)javac, this.cancelRequested);
                if (overridenMethods.size() > 0 || overridingMethods.size() > 0) {
                    preCheckProblem = InlineRefactoringPlugin.createProblem(preCheckProblem, true, Bundle.ERR_InlineMethodPolymorphic());
                    return preCheckProblem;
                }
                TreePath methodPath = javac.getTrees().getPath(element);
                MethodTree methodTree = (MethodTree)methodPath.getLeaf();
                Tree returnType = methodTree.getReturnType();
                boolean hasReturn = true;
                if (returnType.getKind() == Tree.Kind.PRIMITIVE_TYPE && ((PrimitiveTypeTree)returnType).getPrimitiveTypeKind() == TypeKind.VOID) {
                    hasReturn = false;
                }
                InlineMethodVisitor methodVisitor = new InlineMethodVisitor(javac, element);
                methodVisitor.scan(methodPath.getLeaf(), methodPath);
                if (!hasReturn && methodVisitor.nrOfReturnStatements > 0) {
                    preCheckProblem = InlineRefactoringPlugin.createProblem(preCheckProblem, true, Bundle.ERR_InlineMethodVoidReturn());
                    return preCheckProblem;
                }
                if (!methodVisitor.isRecursive) break;
                preCheckProblem = InlineRefactoringPlugin.createProblem(preCheckProblem, true, Bundle.ERR_InlineMethodRecursion());
                return preCheckProblem;
            }
            default: {
                preCheckProblem = InlineRefactoringPlugin.createProblem(preCheckProblem, true, Bundle.ERR_InlineWrongType(element.getKind().toString()));
            }
        }
        return preCheckProblem;
    }

    private class InlineUsageVisitor
    extends CancellableTreeScanner<Tree, TreePath> {
        public int assignmentCount = 0;
        public int usageCount = 0;
        private final CompilationController workingCopy;
        private final Element element;

        public InlineUsageVisitor(CompilationController workingCopy, Element element) {
            this.workingCopy = workingCopy;
            this.element = element;
        }

        public Tree visitVariable(VariableTree node, TreePath p) {
            if (this.element.equals(this.asElement(new TreePath(p, node)))) {
                ++this.usageCount;
            }
            return (Tree)super.visitVariable(node, (Object)p);
        }

        public Tree visitMemberSelect(MemberSelectTree node, TreePath p) {
            if (this.element.equals(this.asElement(new TreePath(p, node)))) {
                ++this.usageCount;
            }
            return (Tree)super.visitMemberSelect(node, (Object)p);
        }

        public Tree visitIdentifier(IdentifierTree node, TreePath p) {
            if (this.element.equals(this.asElement(new TreePath(p, node)))) {
                ++this.usageCount;
            }
            return (Tree)super.visitIdentifier(node, (Object)p);
        }

        public Tree visitMethod(MethodTree node, TreePath p) {
            if (this.element.equals(this.asElement(new TreePath(p, node)))) {
                ++this.usageCount;
            }
            return (Tree)super.visitMethod(node, (Object)p);
        }

        public Tree visitMethodInvocation(MethodInvocationTree node, TreePath p) {
            if (this.element.equals(this.asElement(new TreePath(p, node)))) {
                ++this.usageCount;
            }
            return (Tree)super.visitMethodInvocation(node, (Object)p);
        }

        public Tree visitAssignment(AssignmentTree node, TreePath p) {
            if (this.element.equals(this.asElement(new TreePath(p, node.getVariable())))) {
                ++this.assignmentCount;
            }
            return (Tree)super.visitAssignment(node, (Object)p);
        }

        public Tree visitCompoundAssignment(CompoundAssignmentTree node, TreePath p) {
            if (this.element.equals(this.asElement(new TreePath(p, node.getVariable())))) {
                ++this.assignmentCount;
            }
            return (Tree)super.visitCompoundAssignment(node, (Object)p);
        }

        public Tree visitUnary(UnaryTree node, TreePath p) {
            if (this.element.equals(this.asElement(new TreePath(p, node.getExpression()))) && unary.contains((Object)node.getKind())) {
                ++this.assignmentCount;
            }
            return (Tree)super.visitUnary(node, (Object)p);
        }

        private Element asElement(TreePath treePath) {
            Trees treeUtil = this.workingCopy.getTrees();
            return treeUtil.getElement(treePath);
        }
    }

    private static class UnsafeTreeScanner
    extends ErrorAwareTreeScanner<Boolean, Boolean> {
        private int skipFirstMethodInvocation;

        public UnsafeTreeScanner(int skipFirstMethodInvocation) {
            this.skipFirstMethodInvocation = skipFirstMethodInvocation;
        }

        public Boolean visitMethodInvocation(MethodInvocationTree node, Boolean p) {
            if (this.skipFirstMethodInvocation > 0) {
                --this.skipFirstMethodInvocation;
                return (Boolean)super.visitMethodInvocation(node, (Object)p);
            }
            return true;
        }

        public Boolean visitNewClass(NewClassTree node, Boolean p) {
            return true;
        }

        public Boolean visitNewArray(NewArrayTree node, Boolean p) {
            return true;
        }

        public Boolean visitAssignment(AssignmentTree node, Boolean p) {
            return true;
        }

        public Boolean visitUnary(UnaryTree node, Boolean p) {
            return true;
        }

        public Boolean reduce(Boolean left, Boolean right) {
            return left != null && left != false || right != null && right != false;
        }
    }

    private class InlineMethodVisitor
    extends CancellableTreeScanner<Tree, TreePath> {
        public int nrOfReturnStatements = 0;
        public boolean isRecursive = false;
        private boolean qualIdentProblem = false;
        private final CompilationController workingCopy;
        private final Modifier access;
        private final Element element;

        public InlineMethodVisitor(CompilationController workingCopy, Element element) {
            this.workingCopy = workingCopy;
            this.access = this.getAccessSpecifier(element.getModifiers());
            this.element = element;
        }

        public Tree visitReturn(ReturnTree node, TreePath p) {
            ++this.nrOfReturnStatements;
            return (Tree)super.visitReturn(node, (Object)p);
        }

        public Tree visitMethodInvocation(MethodInvocationTree node, TreePath p) {
            Element asElement = this.asElement(new TreePath(p, node));
            if (this.element.equals(asElement)) {
                this.isRecursive = true;
            } else if (asElement != null && (asElement.getKind() == ElementKind.FIELD || asElement.getKind() == ElementKind.METHOD || asElement.getKind() == ElementKind.CLASS)) {
                Modifier mod = this.getAccessSpecifier(asElement.getModifiers());
                this.qualIdentProblem = this.hasQualIdentProblem(this.element, asElement);
            }
            return (Tree)super.visitMethodInvocation(node, (Object)p);
        }

        private boolean hasQualIdentProblem(Element p, Element asElement) throws IllegalArgumentException {
            TypeElement invocationEnclosingTypeElement;
            boolean result = this.qualIdentProblem;
            ElementUtilities elementUtilities = this.workingCopy.getElementUtilities();
            TypeElement bodyEnclosingTypeElement = elementUtilities.enclosingTypeElement(p);
            if (bodyEnclosingTypeElement.equals(invocationEnclosingTypeElement = elementUtilities.enclosingTypeElement(asElement)) && this.access != Modifier.PRIVATE) {
                result = true;
            }
            return result;
        }

        private Modifier getAccessSpecifier(Set<Modifier> modifiers) {
            Modifier mod = null;
            for (Modifier modifier : modifiers) {
                switch (modifier) {
                    case PUBLIC: 
                    case PRIVATE: 
                    case PROTECTED: {
                        mod = modifier;
                    }
                }
            }
            return mod;
        }

        public Tree visitIdentifier(IdentifierTree node, TreePath p) {
            Element asElement = this.asElement(new TreePath(p, node));
            if (!(node.getName().contentEquals("this") || asElement == null || asElement.getKind() != ElementKind.FIELD && asElement.getKind() != ElementKind.METHOD && asElement.getKind() != ElementKind.CLASS)) {
                Modifier mod = this.getAccessSpecifier(asElement.getModifiers());
                this.qualIdentProblem = this.hasQualIdentProblem(this.element, asElement);
            }
            return (Tree)super.visitIdentifier(node, (Object)p);
        }

        public Tree visitNewClass(NewClassTree node, TreePath p) {
            Element asElement = this.asElement(new TreePath(p, node));
            if (asElement != null && (asElement.getKind() == ElementKind.FIELD || asElement.getKind() == ElementKind.METHOD || asElement.getKind() == ElementKind.CLASS)) {
                Modifier mod = this.getAccessSpecifier(asElement.getModifiers());
                this.qualIdentProblem = this.hasQualIdentProblem(this.element, asElement);
            }
            return (Tree)super.visitNewClass(node, (Object)p);
        }

        public Tree visitMemberSelect(MemberSelectTree node, TreePath p) {
            Element asElement = this.asElement(new TreePath(p, node));
            if (asElement != null && (asElement.getKind() == ElementKind.FIELD || asElement.getKind() == ElementKind.METHOD || asElement.getKind() == ElementKind.CLASS)) {
                Modifier mod = this.getAccessSpecifier(asElement.getModifiers());
                this.qualIdentProblem = this.hasQualIdentProblem(this.element, asElement);
            }
            return (Tree)super.visitMemberSelect(node, (Object)p);
        }

        private Element asElement(TreePath treePath) {
            Trees treeUtil = this.workingCopy.getTrees();
            Element element = treeUtil.getElement(treePath);
            return element;
        }
    }
}

