/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.tax.CannotMergeException;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.TreeObjectList;
import org.netbeans.tax.Util;

public class TreeNamedObjectMap
extends TreeObjectList {
    private Map map;
    private KeyListener keyListener;

    protected TreeNamedObjectMap(ContentManager contentManager) {
        super(contentManager);
        this.map = null;
        this.keyListener = null;
    }

    protected TreeNamedObjectMap(TreeNamedObjectMap namedObjectMap) {
        super(namedObjectMap);
    }

    private KeyListener getKeyListener() {
        if (this.keyListener == null) {
            this.keyListener = new KeyListener();
        }
        return this.keyListener;
    }

    private Map getMap() {
        if (this.map == null) {
            this.map = new HashMap(3);
        }
        return this.map;
    }

    private void mapClear() {
        for (NamedObject namedObject : this.getMap().values()) {
            namedObject.setKeyListener(null);
        }
        this.getMap().clear();
    }

    private Object mapPut(NamedObject namedObject) {
        NamedObject obj = this.getMap().put(namedObject.mapKey(), namedObject);
        namedObject.setKeyListener(this.getKeyListener());
        return obj;
    }

    private Object mapRemove(NamedObject namedObject) {
        Object obj = this.getMap().remove(namedObject.mapKey());
        namedObject.setKeyListener(null);
        return obj;
    }

    @Override
    public Object clone() {
        return new TreeNamedObjectMap(this);
    }

    @Override
    public boolean equals(Object object, boolean deep) {
        if (!super.equals(object, deep)) {
            return false;
        }
        TreeNamedObjectMap peer = (TreeNamedObjectMap)object;
        if (this.getMap().size() != peer.getMap().size()) {
            return false;
        }
        Iterator thisIt = this.getMap().keySet().iterator();
        Iterator peerIt = peer.getMap().keySet().iterator();
        while (thisIt.hasNext()) {
            Object peerNext;
            Object thisNext = thisIt.next();
            if (!Util.equals(thisNext, peerNext = peerIt.next())) {
                return false;
            }
            if (Util.equals(this.getMap().get(thisNext), peer.getMap().get(peerNext))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void merge(TreeObject treeObject) throws CannotMergeException {
        this.mapClear();
        super.merge(treeObject);
    }

    @Override
    protected int findMergeCandidate(TreeObject original, TreeObject[] candidates) {
        if (!(original instanceof NamedObject)) {
            return -1;
        }
        for (int i = 0; i < candidates.length; ++i) {
            TreeObject candidate = candidates[i];
            if (candidate == null || !(candidate instanceof NamedObject)) continue;
            Object key1 = ((NamedObject)((Object)candidate)).mapKey();
            Object key2 = ((NamedObject)((Object)original)).mapKey();
            if (key2 == null || !key2.equals(key1)) continue;
            return i;
        }
        return -1;
    }

    public final Object get(Object mapKey) {
        return this.getMap().get(mapKey);
    }

    @Override
    protected boolean removeImpl(Object obj) throws ClassCastException {
        boolean removed = super.removeImpl(obj);
        if (removed) {
            this.mapRemove((NamedObject)obj);
        }
        return removed;
    }

    @Override
    protected Object setImpl(int index, Object obj) throws ClassCastException {
        Object oldObj = super.setImpl(index, obj);
        this.mapRemove((NamedObject)oldObj);
        this.mapPut((NamedObject)obj);
        return oldObj;
    }

    @Override
    protected Object removeImpl(int index) {
        Object oldObj = super.removeImpl(index);
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("\nTreeNamedObjectMap::removeImpl [ " + index + " ] = " + oldObj);
        }
        if (oldObj != null) {
            this.mapRemove((NamedObject)oldObj);
        }
        return oldObj;
    }

    @Override
    protected void addImpl(int index, Object obj) throws ClassCastException {
        Object oldObj = this.getMap().get(((NamedObject)obj).mapKey());
        if (oldObj != null) {
            this.remove(oldObj);
        }
        super.addImpl(index, obj);
        this.mapPut((NamedObject)obj);
    }

    @Override
    protected boolean addImpl(Object obj) throws ClassCastException {
        boolean added;
        Object oldObj = this.getMap().get(((NamedObject)obj).mapKey());
        if (oldObj != null) {
            this.remove(oldObj);
        }
        if (added = super.addImpl(obj)) {
            this.mapPut((NamedObject)obj);
        }
        return added;
    }

    private void keyChanged(Object oldKey) {
        Object oldValue = this.getMap().remove(oldKey);
        Object newKey = ((NamedObject)oldValue).mapKey();
        Object newValue = this.getMap().get(newKey);
        if (newValue != null) {
            this.remove(newValue);
        }
        this.getMap().put(newKey, oldValue);
    }

    public class KeyListener {
        private KeyListener() {
        }

        public void mapKeyChanged(Object oldKey) {
            TreeNamedObjectMap.this.keyChanged(oldKey);
        }
    }

    public static interface NamedObject {
        public Object mapKey();

        public void setKeyListener(KeyListener var1);
    }

    protected static abstract class ContentManager
    extends TreeObjectList.ContentManager {
        protected ContentManager() {
        }

        @Override
        public void checkAssignableObject(Object obj) throws ClassCastException {
            super.checkAssignableObject(obj);
            if (!(obj instanceof NamedObject)) {
                String msg = Util.THIS.getString("EXC_instance_of_NamedObject");
                throw new ClassCastException(msg);
            }
        }
    }
}

