/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.database.model.AutonomousVirtualMachineSummary;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ListAutonomousVirtualMachinesRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String autonomousVmClusterId;
    private Integer limit;
    private String page;
    private String opcRequestId;
    private AutonomousVirtualMachineSummary.LifecycleState lifecycleState;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getAutonomousVmClusterId() {
        return this.autonomousVmClusterId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public AutonomousVirtualMachineSummary.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).autonomousVmClusterId(this.autonomousVmClusterId).limit(this.limit).page(this.page).opcRequestId(this.opcRequestId).lifecycleState(this.lifecycleState);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",autonomousVmClusterId=").append(String.valueOf(this.autonomousVmClusterId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListAutonomousVirtualMachinesRequest)) {
            return false;
        }
        ListAutonomousVirtualMachinesRequest other = (ListAutonomousVirtualMachinesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.autonomousVmClusterId, other.autonomousVmClusterId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.autonomousVmClusterId == null ? 43 : this.autonomousVmClusterId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListAutonomousVirtualMachinesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String autonomousVmClusterId = null;
        private Integer limit = null;
        private String page = null;
        private String opcRequestId = null;
        private AutonomousVirtualMachineSummary.LifecycleState lifecycleState = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder autonomousVmClusterId(String autonomousVmClusterId) {
            this.autonomousVmClusterId = autonomousVmClusterId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder lifecycleState(AutonomousVirtualMachineSummary.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListAutonomousVirtualMachinesRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.autonomousVmClusterId(o.getAutonomousVmClusterId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.lifecycleState(o.getLifecycleState());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListAutonomousVirtualMachinesRequest build() {
            ListAutonomousVirtualMachinesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListAutonomousVirtualMachinesRequest buildWithoutInvocationCallback() {
            ListAutonomousVirtualMachinesRequest request = new ListAutonomousVirtualMachinesRequest();
            request.compartmentId = this.compartmentId;
            request.autonomousVmClusterId = this.autonomousVmClusterId;
            request.limit = this.limit;
            request.page = this.page;
            request.opcRequestId = this.opcRequestId;
            request.lifecycleState = this.lifecycleState;
            return request;
        }
    }
}

