/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.rules.entity;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.j2ee.jpa.model.ModelUtils;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.common.Utilities;
import org.netbeans.modules.j2ee.jpa.verification.fixes.ImplementSerializable;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.IdClass;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.MappedSuperclass;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.util.NbBundle;

public class SerializableClass {
    public static ErrorDescription apply(HintContext hc) {
        TreePath par;
        if (hc.isCanceled() || hc.getPath().getLeaf().getKind() != Tree.Kind.IDENTIFIER || hc.getPath().getParentPath().getLeaf().getKind() != Tree.Kind.ANNOTATION) {
            return null;
        }
        final JPAProblemContext ctx = ModelUtils.getOrCreateCachedContext(hc);
        if (ctx == null || hc.isCanceled()) {
            return null;
        }
        TypeElement subject = ctx.getJavaClass();
        boolean idClass = "IdClass".equals(hc.getPath().getLeaf().toString());
        if (idClass) {
            final IdClass[] idclass = new IdClass[]{null};
            try {
                MetadataModel<EntityMappingsMetadata> model = ModelUtils.getModel(hc.getInfo().getFileObject());
                model.runReadAction((MetadataModelAction)new MetadataModelAction<EntityMappingsMetadata, Void>(){

                    public Void run(EntityMappingsMetadata metadata) {
                        if (ctx.getModelElement() instanceof Entity) {
                            idclass[0] = ((Entity)ctx.getModelElement()).getIdClass();
                        } else if (ctx.getModelElement() instanceof MappedSuperclass) {
                            idclass[0] = ((MappedSuperclass)ctx.getModelElement()).getIdClass();
                        }
                        return null;
                    }
                });
            }
            catch (IOException model) {
                // empty catch block
            }
            if (idclass[0] == null || idclass[0].getClass2() == null) {
                return null;
            }
            subject = hc.getInfo().getElements().getTypeElement(idclass[0].getClass2());
        }
        if (subject == null || SerializableClass.extendsFromSerializable(subject)) {
            return null;
        }
        TypeMirror superCls = subject.getSuperclass();
        while (superCls instanceof DeclaredType) {
            TypeElement superElem = (TypeElement)((DeclaredType)superCls).asElement();
            if (SerializableClass.extendsFromSerializable(superElem)) {
                return null;
            }
            superCls = superElem.getSuperclass();
        }
        ImplementSerializable fix = new ImplementSerializable(ctx.getFileObject(), (ElementHandle<TypeElement>)ElementHandle.create((Element)subject));
        if (idClass) {
            return ErrorDescriptionFactory.forTree((HintContext)hc, (TreePath)hc.getPath().getParentPath(), (String)NbBundle.getMessage(SerializableClass.class, (String)"MSG_NonSerializableClass"), (Fix[])new Fix[]{fix});
        }
        for (par = hc.getPath(); par != null && par.getParentPath() != null && par.getLeaf().getKind() != Tree.Kind.CLASS; par = par.getParentPath()) {
        }
        Utilities.TextSpan underlineSpan = Utilities.getUnderlineSpan(ctx.getCompilationInfo(), par.getLeaf());
        return ErrorDescriptionFactory.forSpan((HintContext)hc, (int)underlineSpan.getStartOffset(), (int)underlineSpan.getEndOffset(), (String)NbBundle.getMessage(SerializableClass.class, (String)"MSG_NonSerializableClass"), (Fix[])new Fix[]{fix});
    }

    private static boolean extendsFromSerializable(TypeElement subject) {
        for (TypeMirror typeMirror : subject.getInterfaces()) {
            DeclaredType iType;
            if ("java.io.Serializable".equals(typeMirror.toString())) {
                return true;
            }
            if (!(typeMirror instanceof DeclaredType) || !SerializableClass.extendsFromSerializable((TypeElement)(iType = (DeclaredType)typeMirror).asElement())) continue;
            return true;
        }
        return false;
    }
}

