/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.refactoring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.csl.spi.support.ModificationResult;
import org.netbeans.modules.css.editor.Css3Utils;
import org.netbeans.modules.css.editor.CssProjectSupport;
import org.netbeans.modules.css.indexing.CssFileModel;
import org.netbeans.modules.css.indexing.api.CssIndex;
import org.netbeans.modules.css.refactoring.DiffElement;
import org.netbeans.modules.css.refactoring.api.CssRefactoringExtraInfo;
import org.netbeans.modules.css.refactoring.api.CssRefactoringInfo;
import org.netbeans.modules.css.refactoring.api.Entry;
import org.netbeans.modules.css.refactoring.api.RefactoringElementType;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringCommit;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.netbeans.modules.web.common.api.DependenciesGraph;
import org.netbeans.modules.web.common.api.FileReference;
import org.netbeans.modules.web.common.api.FileReferenceModification;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CssRenameRefactoringPlugin
implements RefactoringPlugin {
    private static final String SELECTOR_RENAME_MSG_KEY = "MSG_Rename_Selector";
    private static final String COLOR_RENAME_MSG_KEY = "MSG_Rename_Color";
    private static final String UNRELATED_PREFIX_MSG_KEY = "MSG_Unrelated_Prefix";
    private static final Logger LOGGER = Logger.getLogger(CssRenameRefactoringPlugin.class.getSimpleName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    private final RenameRefactoring refactoring;
    private final Lookup lookup;
    private CssRefactoringInfo context;

    public CssRenameRefactoringPlugin(RenameRefactoring refactoring) {
        this.refactoring = refactoring;
        this.lookup = refactoring.getRefactoringSource();
        this.context = (CssRefactoringInfo)this.lookup.lookup(CssRefactoringInfo.class);
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        String newName = this.refactoring.getNewName();
        if (newName.length() == 0) {
            return new Problem(true, NbBundle.getMessage(CssRenameRefactoringPlugin.class, (String)"MSG_Error_ElementEmpty"));
        }
        return null;
    }

    public Problem fastCheckParameters() {
        return this.checkParameters();
    }

    public void cancelRequest() {
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        FileObject fileObject = this.context != null ? this.context.getFileObject() : (FileObject)this.lookup.lookup(FileObject.class);
        if (fileObject == null) {
            return null;
        }
        CssProjectSupport sup = CssProjectSupport.findFor(fileObject);
        if (sup == null) {
            return null;
        }
        CssIndex index = sup.getIndex();
        ModificationResult modificationResult = new ModificationResult();
        if (this.context != null) {
            CssRefactoringInfo.Type kind = this.context.getType();
            String elementImage = this.context.getElementName();
            switch (kind) {
                case CLASS: {
                    Collection<FileObject> files = index.findClasses(elementImage);
                    this.refactor(this.lookup, modificationResult, RefactoringElementType.CLASS, files, this.context, index, SELECTOR_RENAME_MSG_KEY);
                    break;
                }
                case ID: {
                    Collection<FileObject> files = index.findIds(elementImage);
                    this.refactor(this.lookup, modificationResult, RefactoringElementType.ID, files, this.context, index, SELECTOR_RENAME_MSG_KEY);
                    break;
                }
                case HEX_COLOR: {
                    Collection<FileObject> files = index.findColor(elementImage);
                    this.refactor(this.lookup, modificationResult, RefactoringElementType.COLOR, files, this.context, index, COLOR_RENAME_MSG_KEY);
                    break;
                }
                case ELEMENT: {
                    this.refactorElement(modificationResult, this.context, index);
                    break;
                }
                case RESOURCE_IDENTIFIER: {
                    FileObject resolved = WebUtils.resolve((FileObject)this.context.getFileObject(), (String)elementImage);
                    if (resolved != null) {
                        this.refactorFile(modificationResult, resolved, index);
                        refactoringElements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)new RenameFile(resolved));
                    }
                    return null;
                }
                case URI: {
                    Matcher m = Css3Utils.URI_PATTERN.matcher(elementImage);
                    if (!m.matches()) break;
                    int groupIndex = 1;
                    String content = m.group(groupIndex);
                    String unquoted = WebUtils.unquotedValue((CharSequence)content);
                    FileObject resolved = WebUtils.resolve((FileObject)this.context.getFileObject(), (String)elementImage);
                    if (resolved == null) break;
                    this.refactorFile(modificationResult, resolved, index);
                    refactoringElements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)new RenameFile(resolved));
                }
            }
        } else if (!fileObject.isFolder()) {
            this.refactorFile(modificationResult, fileObject, index);
        } else if (fileObject.isFolder()) {
            this.refactorFolder(modificationResult, fileObject, index);
        }
        refactoringElements.registerTransaction((Transaction)new RefactoringCommit(Collections.singletonList(modificationResult)));
        for (FileObject fo : modificationResult.getModifiedFileObjects()) {
            for (ModificationResult.Difference diff : modificationResult.getDifferences(fo)) {
                refactoringElements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)DiffElement.create(diff, fo, modificationResult));
            }
        }
        return null;
    }

    private void refactorFile(ModificationResult modificationResult, FileObject context, CssIndex index) {
        LOGGER.log(Level.FINE, "refactor file {0}", context.getPath());
        String newName = this.refactoring.getNewName();
        DependenciesGraph deps = index.getDependencies(context);
        Collection refering = deps.getSourceNode().getReferingNodes();
        for (DependenciesGraph.Node ref : refering) {
            FileObject file = ref.getFile();
            try {
                CloneableEditorSupport editor = GsfUtilities.findCloneableEditorSupport((FileObject)file);
                Source source = editor != null && editor.isModified() ? Source.create((Document)editor.getDocument()) : Source.create((FileObject)file);
                CssFileModel model = CssFileModel.create(source);
                ArrayList<ModificationResult.Difference> diffs = new ArrayList<ModificationResult.Difference>();
                for (Entry entry : model.getImports()) {
                    String imp = entry.getName();
                    FileObject resolvedFileObject = WebUtils.resolve((FileObject)file, (String)imp);
                    if (resolvedFileObject == null || !resolvedFileObject.equals(context) || !entry.isValidInSourceDocument()) continue;
                    String extension = context.getExt();
                    int slashIndex = imp.lastIndexOf(47);
                    String newImport = slashIndex != -1 ? imp.substring(0, slashIndex) + "/" + newName + "." + extension : newName + "." + extension;
                    diffs.add(new ModificationResult.Difference(ModificationResult.Difference.Kind.CHANGE, editor.createPositionRef(entry.getDocumentRange().getStart(), Position.Bias.Forward), editor.createPositionRef(entry.getDocumentRange().getEnd(), Position.Bias.Backward), entry.getName(), newImport, NbBundle.getMessage(CssRenameRefactoringPlugin.class, (String)"MSG_Modify_Css_File_Import")));
                }
                if (diffs.isEmpty()) continue;
                modificationResult.addDifferences(file, diffs);
            }
            catch (ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void refactorFolder(ModificationResult modificationResult, FileObject renamedFolder, CssIndex index) {
        LOGGER.log(Level.FINE, "refactor folder {0}", renamedFolder.getPath());
        String newName = this.refactoring.getNewName();
        try {
            CssIndex.AllDependenciesMaps alldeps = index.getAllDependencies();
            Map<FileObject, Collection<FileReference>> source2dest = alldeps.getSource2dest();
            WeakHashMap<FileObject, CssFileModel> modelsCache = new WeakHashMap<FileObject, CssFileModel>();
            HashSet<Entry> refactoredReferenceEntries = new HashSet<Entry>();
            for (Map.Entry<FileObject, Collection<FileReference>> source2destEntry : source2dest.entrySet()) {
                ArrayList<ModificationResult.Difference> diffs = new ArrayList<ModificationResult.Difference>();
                FileObject source = source2destEntry.getKey();
                Collection<FileReference> destinations = source2destEntry.getValue();
                for (FileReference dest : destinations) {
                    FileReferenceModification modification = dest.createModification();
                    if (!modification.rename(renamedFolder, newName)) continue;
                    CssFileModel model = (CssFileModel)modelsCache.get(source);
                    if (model == null) {
                        try {
                            model = CssFileModel.create(Source.create((FileObject)source));
                            modelsCache.put(source, model);
                        }
                        catch (ParseException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                    if (model == null) continue;
                    Collection<Entry> imports = model.getImports();
                    for (Entry entry : imports) {
                        if (refactoredReferenceEntries.contains(entry) || !entry.isValidInSourceDocument() || !entry.getName().equals(dest.linkPath())) continue;
                        CloneableEditorSupport editor = GsfUtilities.findCloneableEditorSupport((FileObject)source);
                        diffs.add(new ModificationResult.Difference(ModificationResult.Difference.Kind.CHANGE, editor.createPositionRef(entry.getDocumentRange().getStart(), Position.Bias.Forward), editor.createPositionRef(entry.getDocumentRange().getEnd(), Position.Bias.Backward), entry.getName(), modification.getModifiedReferencePath(), NbBundle.getMessage(CssRenameRefactoringPlugin.class, (String)"MSG_Modify_Css_File_Import")));
                        refactoredReferenceEntries.add(entry);
                    }
                }
                if (diffs.isEmpty()) continue;
                modificationResult.addDifferences(source, diffs);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void refactorElement(ModificationResult modificationResult, CssRefactoringInfo context, CssIndex index) {
        CssFileModel model;
        String elementImage = context.getElementName();
        try {
            model = CssFileModel.create(Source.create((FileObject)context.getFileObject()));
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
        ArrayList<ModificationResult.Difference> diffs = new ArrayList<ModificationResult.Difference>();
        CloneableEditorSupport editor = GsfUtilities.findCloneableEditorSupport((FileObject)context.getFileObject());
        for (Entry entry : model.getHtmlElements()) {
            if (!entry.isValidInSourceDocument() || !elementImage.equals(entry.getName())) continue;
            diffs.add(new ModificationResult.Difference(ModificationResult.Difference.Kind.CHANGE, editor.createPositionRef(entry.getDocumentRange().getStart(), Position.Bias.Forward), editor.createPositionRef(entry.getDocumentRange().getEnd(), Position.Bias.Backward), entry.getName(), this.refactoring.getNewName(), NbBundle.getMessage(CssRenameRefactoringPlugin.class, (String)SELECTOR_RENAME_MSG_KEY)));
        }
        if (!diffs.isEmpty()) {
            modificationResult.addDifferences(context.getFileObject(), diffs);
        }
    }

    private void refactor(Lookup lookup, ModificationResult modificationResult, RefactoringElementType type, Collection<FileObject> files, CssRefactoringInfo context, CssIndex index, String renameMsgKey) {
        String elementImage = context.getElementName();
        LinkedList<FileObject> involvedFiles = new LinkedList<FileObject>(files);
        DependenciesGraph deps = index.getDependencies(context.getFileObject());
        Collection relatedFiles = deps.getAllRelatedFiles();
        CssRefactoringExtraInfo extraInfo = (CssRefactoringExtraInfo)lookup.lookup(CssRefactoringExtraInfo.class);
        if (extraInfo == null || !extraInfo.isRefactorAll()) {
            involvedFiles.retainAll(relatedFiles);
        }
        if (LOG) {
            LOGGER.log(Level.FINE, "Refactoring element {0} in file {1}", new Object[]{elementImage, context.getFileObject().getPath()});
            LOGGER.log(Level.FINE, "Involved files declaring the element {0}:", elementImage);
            for (FileObject fo : involvedFiles) {
                LOGGER.log(Level.FINE, "{0}\n", fo.getPath());
            }
        }
        String newName = this.refactoring.getNewName();
        for (FileObject file : involvedFiles) {
            try {
                CloneableEditorSupport editor = GsfUtilities.findCloneableEditorSupport((FileObject)file);
                Source source = editor != null && editor.isModified() ? Source.create((Document)editor.getDocument()) : Source.create((FileObject)file);
                CssFileModel model = CssFileModel.create(source);
                Collection<Entry> entries = model.get(type);
                boolean related = relatedFiles.contains(file);
                ArrayList<ModificationResult.Difference> diffs = new ArrayList<ModificationResult.Difference>();
                for (Entry entry : entries) {
                    if (!entry.isValidInSourceDocument() || !LexerUtils.equals((CharSequence)elementImage, (CharSequence)entry.getName(), (type == RefactoringElementType.COLOR ? 1 : 0) != 0, (boolean)false)) continue;
                    diffs.add(new ModificationResult.Difference(ModificationResult.Difference.Kind.CHANGE, editor.createPositionRef(entry.getDocumentRange().getStart(), Position.Bias.Forward), editor.createPositionRef(entry.getDocumentRange().getEnd(), Position.Bias.Backward), entry.getName(), newName, related ? NbBundle.getMessage(CssRenameRefactoringPlugin.class, (String)renameMsgKey) : NbBundle.getMessage(CssRenameRefactoringPlugin.class, (String)UNRELATED_PREFIX_MSG_KEY) + " " + NbBundle.getMessage(CssRenameRefactoringPlugin.class, (String)renameMsgKey)));
                }
                if (diffs.isEmpty()) continue;
                modificationResult.addDifferences(file, diffs);
            }
            catch (ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private class RenameFile
    extends SimpleRefactoringElementImplementation {
        private FileObject fo;
        private String oldName;

        public RenameFile(FileObject fo) {
            this.fo = fo;
        }

        public String getText() {
            return NbBundle.getMessage(CssRenameRefactoringPlugin.class, (String)"TXT_RenameFile", (Object)this.fo.getNameExt());
        }

        public String getDisplayText() {
            return this.getText();
        }

        public void performChange() {
            try {
                this.oldName = this.fo.getName();
                DataObject.find((FileObject)this.fo).rename(CssRenameRefactoringPlugin.this.refactoring.getNewName());
            }
            catch (DataObjectNotFoundException ex) {
                throw new IllegalStateException(ex);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }

        public void undoChange() {
            try {
                DataObject.find((FileObject)this.fo).rename(this.oldName);
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public FileObject getParentFile() {
            return this.fo;
        }

        public PositionBounds getPosition() {
            return null;
        }
    }

    private class RenameFolder
    extends SimpleRefactoringElementImplementation {
        private FileObject fo;
        private String oldName;

        public RenameFolder(FileObject fo) {
            this.fo = fo;
        }

        public String getText() {
            return NbBundle.getMessage(CssRenameRefactoringPlugin.class, (String)"TXT_RenameFolder", (Object)this.fo.getNameExt());
        }

        public String getDisplayText() {
            return this.getText();
        }

        public void performChange() {
            try {
                this.oldName = this.fo.getName();
                DataObject.find((FileObject)this.fo).rename(CssRenameRefactoringPlugin.this.refactoring.getNewName());
            }
            catch (DataObjectNotFoundException ex) {
                throw new IllegalStateException(ex);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }

        public void undoChange() {
            try {
                DataObject.find((FileObject)this.fo).rename(this.oldName);
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public FileObject getParentFile() {
            return this.fo;
        }

        public PositionBounds getPosition() {
            return null;
        }
    }
}

