/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ResetIdpScimClientRequest
extends BmcRequest<Void> {
    private String identityProviderId;

    public String getIdentityProviderId() {
        return this.identityProviderId;
    }

    public Builder toBuilder() {
        return new Builder().identityProviderId(this.identityProviderId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",identityProviderId=").append(String.valueOf(this.identityProviderId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResetIdpScimClientRequest)) {
            return false;
        }
        ResetIdpScimClientRequest other = (ResetIdpScimClientRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.identityProviderId, other.identityProviderId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.identityProviderId == null ? 43 : this.identityProviderId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ResetIdpScimClientRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String identityProviderId = null;

        public Builder identityProviderId(String identityProviderId) {
            this.identityProviderId = identityProviderId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ResetIdpScimClientRequest o) {
            this.identityProviderId(o.getIdentityProviderId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ResetIdpScimClientRequest build() {
            ResetIdpScimClientRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ResetIdpScimClientRequest buildWithoutInvocationCallback() {
            ResetIdpScimClientRequest request = new ResetIdpScimClientRequest();
            request.identityProviderId = this.identityProviderId;
            return request;
        }
    }
}

