/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.cert;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.security.auth.x500.X500Principal;
import oracle.security.pki.internal.asn1.ASN1Object;
import oracle.security.pki.internal.asn1.ASN1ObjectID;
import oracle.security.pki.internal.asn1.ASN1Sequence;
import oracle.security.pki.internal.asn1.ASN1SequenceInputStream;
import oracle.security.pki.internal.asn1.ASN1String;
import oracle.security.pki.internal.cert.Entity;
import oracle.security.pki.internal.cert.PKIX;
import oracle.security.pki.internal.cert.X500RDN;
import oracle.security.pki.util.InvalidFormatException;
import oracle.security.pki.util.Utils;

public class X500Name
extends Entity
implements ASN1Object {
    private ArrayList<X500RDN> a = new ArrayList();
    private String b = null;
    private String c = null;
    private String d = null;
    private String e = null;
    private String f = null;
    private String g = null;
    private String h = null;
    private ASN1Sequence i;
    private String j;
    private int k = -1;

    public X500Name() {
    }

    public X500Name(String string) {
        this.d(string);
    }

    public X500Name(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public static X500Name a(X500Principal x500Principal) {
        try {
            return new X500Name(new ByteArrayInputStream(x500Principal.getEncoded()));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    X500Name(ASN1Sequence aSN1Sequence) throws IOException {
        this.a(aSN1Sequence);
    }

    public void a(X500RDN x500RDN) {
        this.a.add(x500RDN);
        for (ASN1ObjectID aSN1ObjectID : x500RDN.a().keySet()) {
            ASN1Object aSN1Object = x500RDN.a(aSN1ObjectID);
            if (!(aSN1Object instanceof ASN1String)) continue;
            ASN1String aSN1String = (ASN1String)aSN1Object;
            if (aSN1ObjectID.equals(PKIX.b)) {
                this.a(aSN1String.b());
                continue;
            }
            if (aSN1ObjectID.equals(PKIX.h)) {
                this.b = aSN1String.b();
                continue;
            }
            if (aSN1ObjectID.equals(PKIX.c)) {
                this.d = aSN1String.b();
                continue;
            }
            if (aSN1ObjectID.equals(PKIX.d)) {
                this.c = aSN1String.b();
                continue;
            }
            if (aSN1ObjectID.equals(PKIX.f)) {
                this.e = aSN1String.b();
                continue;
            }
            if (aSN1ObjectID.equals(PKIX.g)) {
                this.f = aSN1String.b();
                continue;
            }
            if (aSN1ObjectID.equals(PKIX.i)) {
                this.g = aSN1String.b();
                continue;
            }
            if (!aSN1ObjectID.equals(PKIX.r)) continue;
            this.h = aSN1String.b();
        }
        this.j = null;
        this.i = null;
        this.k = -1;
    }

    public void a(ASN1ObjectID aSN1ObjectID, ASN1String aSN1String) {
        this.a(new X500RDN(aSN1ObjectID, aSN1String));
    }

    public void a(ASN1ObjectID aSN1ObjectID, String string) {
        this.a(new X500RDN(aSN1ObjectID, string));
    }

    public void a(String string, String string2) {
        this.a(X500RDN.b(string), string2);
    }

    public ASN1Object b(String string) {
        return this.a(X500RDN.b(string));
    }

    public ASN1Object a(ASN1ObjectID aSN1ObjectID) {
        X500RDN x500RDN = this.b(aSN1ObjectID);
        return x500RDN != null ? x500RDN.a(aSN1ObjectID) : null;
    }

    public X500RDN c(String string) {
        ASN1ObjectID aSN1ObjectID = X500RDN.b(string);
        return aSN1ObjectID != null ? this.b(aSN1ObjectID) : null;
    }

    public X500RDN b(ASN1ObjectID aSN1ObjectID) {
        for (X500RDN x500RDN : this.c()) {
            if (x500RDN == null || x500RDN.a(aSN1ObjectID) == null) continue;
            return x500RDN;
        }
        return null;
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.h();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        while (aSN1SequenceInputStream.a()) {
            this.a(new X500RDN(aSN1SequenceInputStream));
        }
        aSN1SequenceInputStream.b();
    }

    void a(ASN1Sequence aSN1Sequence) throws IOException {
        this.input(Utils.toStream(aSN1Sequence));
    }

    public void d(String string) throws InvalidFormatException {
        this.h();
        boolean bl = true;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (X500RDN.a(string.charAt(i))) continue;
            bl = false;
            break;
        }
        if (bl) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        n = 0;
        boolean bl2 = false;
        int n2 = 0;
        ArrayList<X500RDN> arrayList = new ArrayList<X500RDN>();
        while (n2 < string.length()) {
            try {
                char c = string.charAt(n2);
                if (c == '\"') {
                    n = n == 0 ? 1 : 0;
                    stringBuffer.append(c);
                } else if (c == ',' || c == ';') {
                    if (n != 0) {
                        stringBuffer.append(c);
                    } else {
                        bl2 = true;
                    }
                } else if (c == '\\') {
                    stringBuffer.append(c);
                    c = string.charAt(++n2);
                    stringBuffer.append(c);
                } else {
                    stringBuffer.append(c);
                }
                if (!bl2 && ++n2 != string.length()) continue;
                arrayList.add(new X500RDN(stringBuffer.toString()));
                stringBuffer = new StringBuffer();
                n = 0;
                bl2 = false;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new InvalidFormatException("Malformed DN string");
            }
        }
        X500RDN[] x500RDNArray = arrayList.toArray(new X500RDN[arrayList.size()]);
        for (int i = x500RDNArray.length - 1; i >= 0; --i) {
            this.a(x500RDNArray[i]);
        }
    }

    private void h() {
        this.a.clear();
        this.b = null;
        this.c = null;
        this.d = null;
        this.e = null;
        this.f = null;
        this.g = null;
        this.h = null;
        this.j = null;
        this.i = null;
        this.k = -1;
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.b().output(outputStream);
    }

    @Override
    public int length() {
        return this.b().length();
    }

    ASN1Sequence b() {
        if (this.i == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            int n = this.d();
            for (int i = 0; i < n; ++i) {
                aSN1Sequence.a(this.a.get(i));
            }
            this.i = aSN1Sequence;
        }
        return this.i;
    }

    public String toString() {
        if (this.j == null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = this.d() - 1; i >= 0; --i) {
                X500RDN x500RDN = this.a(i);
                stringBuffer.append(x500RDN.toString());
                stringBuffer.append(',');
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.setLength(stringBuffer.length() - 1);
            }
            this.j = stringBuffer.toString();
        }
        return this.j;
    }

    public ArrayList<X500RDN> c() {
        if (this.a == null) {
            this.a = new ArrayList();
            if (this.b != null) {
                this.a.add(new X500RDN(PKIX.h, this.b));
            }
            if (this.c != null) {
                this.a.add(new X500RDN(PKIX.d, this.c));
            }
            if (this.d != null) {
                this.a.add(new X500RDN(PKIX.c, this.d));
            }
            if (this.e != null) {
                this.a.add(new X500RDN(PKIX.f, this.e));
            }
            if (this.f != null) {
                this.a.add(new X500RDN(PKIX.g, this.f));
            }
            if (this.a() != null) {
                this.a.add(new X500RDN(PKIX.b, this.a()));
            }
            if (this.g != null) {
                this.a.add(new X500RDN(PKIX.i, this.g));
            }
            if (this.h != null) {
                this.a.add(new X500RDN(PKIX.r, this.h));
            }
        }
        return this.a;
    }

    public int d() {
        return this.c().size();
    }

    public X500RDN a(int n) {
        return this.c().get(n);
    }

    private void i() {
        this.a = null;
        this.i = null;
        this.j = null;
        this.k = -1;
    }

    public void e(String string) {
        this.b = string;
        this.i();
    }

    public void f(String string) {
        this.e = string;
        this.i();
    }

    public String e() {
        return this.f;
    }

    public String f() {
        return this.a();
    }

    public void g(String string) {
        this.g = string;
        this.i();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof X500Principal) {
            return this.g().equals(object);
        }
        if (object instanceof X500Name) {
            X500Name x500Name = (X500Name)object;
            if (x500Name.d() != this.d()) {
                return false;
            }
            int n = this.d();
            for (int i = 0; i < n; ++i) {
                if (this.a(i).equals(x500Name.a(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.k == -1) {
            this.k = this.toString().hashCode();
        }
        return this.k;
    }

    public X500Principal g() {
        return new X500Principal(Utils.toBytes(this.b()));
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray = (byte[])objectInput.readObject();
        this.input(new ByteArrayInputStream(byArray));
    }
}

