"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TextureRendererFn = exports.ShapeRendererFn = exports.line = exports.circle = exports.square = exports.triangle = exports.cross = void 0;
var theme_1 = require("../../../utils/themes/theme");
var cross = function (r) {
    return "M " + -r + " 0 L " + r + " 0 M 0 " + r + " L 0 " + -r;
};
exports.cross = cross;
var triangle = function (r) {
    var h = (r * Math.sqrt(3)) / 2;
    var hr = r / 2;
    return "M " + -h + " " + hr + " L " + h + " " + hr + " L 0 " + -r + " Z";
};
exports.triangle = triangle;
var square = function (r) {
    return "M " + -r + " " + -r + " L " + -r + " " + r + " L " + r + " " + r + " L " + r + " " + -r + " Z";
};
exports.square = square;
var circle = function (r) {
    return "M " + -r + " 0 a " + r + "," + r + " 0 1,0 " + r * 2 + ",0 a " + r + "," + r + " 0 1,0 " + -r * 2 + ",0";
};
exports.circle = circle;
var line = function (r) {
    return "M 0 " + -r + " l 0 " + r * 2;
};
exports.line = line;
exports.ShapeRendererFn = (_a = {},
    _a[theme_1.PointShape.Circle] = [exports.circle, 0],
    _a[theme_1.PointShape.X] = [exports.cross, 45],
    _a[theme_1.PointShape.Plus] = [exports.cross, 0],
    _a[theme_1.PointShape.Diamond] = [exports.square, 45],
    _a[theme_1.PointShape.Square] = [exports.square, 0],
    _a[theme_1.PointShape.Triangle] = [exports.triangle, 0],
    _a);
exports.TextureRendererFn = __assign(__assign({}, exports.ShapeRendererFn), (_b = {}, _b[theme_1.TextureShape.Line] = [exports.line, 0], _b));
//# sourceMappingURL=shapes_paths.js.map