/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ClusterJvmVersion
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ClusterJvmVersion> {
    private final boolean bundledJdk;
    private final int count;
    private final boolean usingBundledJdk;
    @Nonnull
    private final String version;
    @Nonnull
    private final String vmName;
    @Nonnull
    private final String vmVendor;
    @Nonnull
    private final String vmVersion;
    public static final JsonpDeserializer<ClusterJvmVersion> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterJvmVersion::setupClusterJvmVersionDeserializer);

    private ClusterJvmVersion(Builder builder) {
        this.bundledJdk = ApiTypeHelper.requireNonNull(builder.bundledJdk, this, "bundledJdk");
        this.count = ApiTypeHelper.requireNonNull(builder.count, this, "count");
        this.usingBundledJdk = ApiTypeHelper.requireNonNull(builder.usingBundledJdk, this, "usingBundledJdk");
        this.version = ApiTypeHelper.requireNonNull(builder.version, this, "version");
        this.vmName = ApiTypeHelper.requireNonNull(builder.vmName, this, "vmName");
        this.vmVendor = ApiTypeHelper.requireNonNull(builder.vmVendor, this, "vmVendor");
        this.vmVersion = ApiTypeHelper.requireNonNull(builder.vmVersion, this, "vmVersion");
    }

    public static ClusterJvmVersion of(Function<Builder, ObjectBuilder<ClusterJvmVersion>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean bundledJdk() {
        return this.bundledJdk;
    }

    public final int count() {
        return this.count;
    }

    public final boolean usingBundledJdk() {
        return this.usingBundledJdk;
    }

    @Nonnull
    public final String version() {
        return this.version;
    }

    @Nonnull
    public final String vmName() {
        return this.vmName;
    }

    @Nonnull
    public final String vmVendor() {
        return this.vmVendor;
    }

    @Nonnull
    public final String vmVersion() {
        return this.vmVersion;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("bundled_jdk");
        generator.write(this.bundledJdk);
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("using_bundled_jdk");
        generator.write(this.usingBundledJdk);
        generator.writeKey("version");
        generator.write(this.version);
        generator.writeKey("vm_name");
        generator.write(this.vmName);
        generator.writeKey("vm_vendor");
        generator.write(this.vmVendor);
        generator.writeKey("vm_version");
        generator.write(this.vmVersion);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupClusterJvmVersionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::bundledJdk, JsonpDeserializer.booleanDeserializer(), "bundled_jdk");
        op.add(Builder::count, JsonpDeserializer.integerDeserializer(), "count");
        op.add(Builder::usingBundledJdk, JsonpDeserializer.booleanDeserializer(), "using_bundled_jdk");
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version");
        op.add(Builder::vmName, JsonpDeserializer.stringDeserializer(), "vm_name");
        op.add(Builder::vmVendor, JsonpDeserializer.stringDeserializer(), "vm_vendor");
        op.add(Builder::vmVersion, JsonpDeserializer.stringDeserializer(), "vm_version");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Boolean.hashCode(this.bundledJdk);
        result = 31 * result + Integer.hashCode(this.count);
        result = 31 * result + Boolean.hashCode(this.usingBundledJdk);
        result = 31 * result + this.version.hashCode();
        result = 31 * result + this.vmName.hashCode();
        result = 31 * result + this.vmVendor.hashCode();
        result = 31 * result + this.vmVersion.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterJvmVersion other = (ClusterJvmVersion)o;
        return this.bundledJdk == other.bundledJdk && this.count == other.count && this.usingBundledJdk == other.usingBundledJdk && this.version.equals(other.version) && this.vmName.equals(other.vmName) && this.vmVendor.equals(other.vmVendor) && this.vmVersion.equals(other.vmVersion);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ClusterJvmVersion> {
        private Boolean bundledJdk;
        private Integer count;
        private Boolean usingBundledJdk;
        private String version;
        private String vmName;
        private String vmVendor;
        private String vmVersion;

        public Builder() {
        }

        private Builder(ClusterJvmVersion o) {
            this.bundledJdk = o.bundledJdk;
            this.count = o.count;
            this.usingBundledJdk = o.usingBundledJdk;
            this.version = o.version;
            this.vmName = o.vmName;
            this.vmVendor = o.vmVendor;
            this.vmVersion = o.vmVersion;
        }

        private Builder(Builder o) {
            this.bundledJdk = o.bundledJdk;
            this.count = o.count;
            this.usingBundledJdk = o.usingBundledJdk;
            this.version = o.version;
            this.vmName = o.vmName;
            this.vmVendor = o.vmVendor;
            this.vmVersion = o.vmVersion;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder bundledJdk(boolean value) {
            this.bundledJdk = value;
            return this;
        }

        @Nonnull
        public final Builder count(int value) {
            this.count = value;
            return this;
        }

        @Nonnull
        public final Builder usingBundledJdk(boolean value) {
            this.usingBundledJdk = value;
            return this;
        }

        @Nonnull
        public final Builder version(String value) {
            this.version = value;
            return this;
        }

        @Nonnull
        public final Builder vmName(String value) {
            this.vmName = value;
            return this;
        }

        @Nonnull
        public final Builder vmVendor(String value) {
            this.vmVendor = value;
            return this;
        }

        @Nonnull
        public final Builder vmVersion(String value) {
            this.vmVersion = value;
            return this;
        }

        @Override
        @Nonnull
        public ClusterJvmVersion build() {
            this._checkSingleUse();
            return new ClusterJvmVersion(this);
        }
    }
}

