/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.matrix.stats;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.opensearch.OpenSearchException;
import org.opensearch.Version;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;

public class RunningStats
implements Writeable,
Cloneable {
    private boolean usesMaps = false;
    public static final Version ARRAY_IMPL_VERSION = Version.V_3_4_0;
    protected long docCount = 0L;
    protected double[] fieldSumArr;
    protected long[] countsArr;
    protected double[] meansArr;
    protected double[] variancesArr;
    protected double[] skewnessArr;
    protected double[] kurtosisArr;
    protected double[][] covariancesArr;
    final String[] fieldNames;
    protected Map<String, Double> fieldSum;
    protected Map<String, Long> counts;
    protected Map<String, Double> means;
    protected Map<String, Double> variances;
    protected Map<String, Double> skewness;
    protected Map<String, Double> kurtosis;
    protected Map<String, Map<String, Double>> covariances;

    RunningStats(String[] fieldNames) {
        this.fieldNames = fieldNames;
        this.init(fieldNames == null);
    }

    RunningStats(String[] fieldNames, double[] fieldVals) {
        this.fieldNames = fieldNames;
        if (fieldVals != null && fieldVals.length > 0) {
            this.init(fieldNames == null);
            this.add(fieldNames, fieldVals);
        }
    }

    private void init(boolean usesMaps) {
        this.usesMaps = usesMaps;
        if (usesMaps) {
            this.counts = new HashMap<String, Long>();
            this.fieldSum = new HashMap<String, Double>();
            this.means = new HashMap<String, Double>();
            this.skewness = new HashMap<String, Double>();
            this.kurtosis = new HashMap<String, Double>();
            this.covariances = new HashMap<String, Map<String, Double>>();
            this.variances = new HashMap<String, Double>();
        } else {
            assert (this.fieldNames != null);
            this.countsArr = new long[this.fieldNames.length];
            this.fieldSumArr = new double[this.fieldNames.length];
            this.meansArr = new double[this.fieldNames.length];
            this.skewnessArr = new double[this.fieldNames.length];
            this.kurtosisArr = new double[this.fieldNames.length];
            this.variancesArr = new double[this.fieldNames.length];
            this.covariancesArr = new double[this.fieldNames.length][this.fieldNames.length];
        }
    }

    void switchToMaps() {
        if (this.usesMaps) {
            return;
        }
        this.counts = this.convertLongArrayToMap(this.countsArr);
        this.fieldSum = this.convertDoubleArrayToMap(this.fieldSumArr);
        this.means = this.convertDoubleArrayToMap(this.meansArr);
        this.skewness = this.convertDoubleArrayToMap(this.skewnessArr);
        this.kurtosis = this.convertDoubleArrayToMap(this.kurtosisArr);
        this.variances = this.convertDoubleArrayToMap(this.variancesArr);
        this.covariances = this.convertNestedDoubleArrayToMap(this.covariancesArr);
        this.usesMaps = true;
    }

    void switchToArrays() {
        if (this.fieldNames == null) {
            throw new IllegalArgumentException("Cannot convert to array impl if fieldNames is null");
        }
        this.countsArr = this.convertFieldLongMap(this.counts);
        this.fieldSumArr = this.convertFieldDoubleMap(this.fieldSum);
        this.meansArr = this.convertFieldDoubleMap(this.means);
        this.skewnessArr = this.convertFieldDoubleMap(this.skewness);
        this.kurtosisArr = this.convertFieldDoubleMap(this.kurtosis);
        this.variancesArr = this.convertFieldDoubleMap(this.variances);
        this.covariancesArr = this.convertNestedDoubleMap(this.covariances);
        this.usesMaps = false;
    }

    public RunningStats(StreamInput in) throws IOException {
        this.docCount = (Long)in.readGenericValue();
        this.fieldSum = (Map)in.readGenericValue();
        this.counts = (Map)in.readGenericValue();
        this.means = (Map)in.readGenericValue();
        this.variances = (Map)in.readGenericValue();
        this.skewness = (Map)in.readGenericValue();
        this.kurtosis = (Map)in.readGenericValue();
        this.covariances = (Map)in.readGenericValue();
        if (in.getVersion().onOrAfter(ARRAY_IMPL_VERSION)) {
            this.usesMaps = in.readBoolean();
            this.fieldNames = in.readOptionalStringArray();
            if (!this.usesMaps) {
                this.switchToArrays();
            }
        } else {
            this.usesMaps = true;
            this.fieldNames = null;
        }
    }

    double[] convertFieldDoubleMap(Map<String, Double> serializedMap) {
        assert (serializedMap.keySet().equals(new HashSet<String>(Arrays.asList(this.fieldNames))));
        double[] result = new double[this.fieldNames.length];
        for (int i = 0; i < this.fieldNames.length; ++i) {
            result[i] = serializedMap.get(this.fieldNames[i]);
        }
        return result;
    }

    long[] convertFieldLongMap(Map<String, Long> serializedMap) {
        assert (serializedMap.keySet().equals(new HashSet<String>(Arrays.asList(this.fieldNames))));
        long[] result = new long[this.fieldNames.length];
        for (int i = 0; i < this.fieldNames.length; ++i) {
            result[i] = serializedMap.get(this.fieldNames[i]);
        }
        return result;
    }

    double[][] convertNestedDoubleMap(Map<String, Map<String, Double>> serializedMap) {
        assert (serializedMap.keySet().equals(new HashSet<String>(Arrays.asList(this.fieldNames))));
        double[][] result = new double[this.fieldNames.length][this.fieldNames.length];
        for (int i = 0; i < this.fieldNames.length; ++i) {
            for (int j = i + 1; j < this.fieldNames.length; ++j) {
                result[i][j] = serializedMap.get(this.fieldNames[i]).get(this.fieldNames[j]);
            }
        }
        return result;
    }

    Map<String, Double> convertDoubleArrayToMap(double[] stats) {
        HashMap<String, Double> result = new HashMap<String, Double>();
        for (int i = 0; i < this.fieldNames.length; ++i) {
            result.put(this.fieldNames[i], stats[i]);
        }
        return result;
    }

    Map<String, Long> convertLongArrayToMap(long[] stats) {
        HashMap<String, Long> result = new HashMap<String, Long>();
        for (int i = 0; i < this.fieldNames.length; ++i) {
            result.put(this.fieldNames[i], stats[i]);
        }
        return result;
    }

    Map<String, Map<String, Double>> convertNestedDoubleArrayToMap(double[][] stats) {
        HashMap<String, Map<String, Double>> result = new HashMap<String, Map<String, Double>>();
        for (int i = 0; i < this.fieldNames.length; ++i) {
            HashMap<String, Double> innerMap = new HashMap<String, Double>();
            result.put(this.fieldNames[i], innerMap);
            for (int j = i + 1; j < this.fieldNames.length; ++j) {
                innerMap.put(this.fieldNames[j], stats[i][j]);
            }
        }
        return result;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeGenericValue((Object)this.docCount);
        if (this.usesMaps) {
            out.writeGenericValue(this.fieldSum);
            out.writeGenericValue(this.counts);
            out.writeGenericValue(this.means);
            out.writeGenericValue(this.variances);
            out.writeGenericValue(this.skewness);
            out.writeGenericValue(this.kurtosis);
            out.writeGenericValue(this.covariances);
        } else {
            out.writeGenericValue(this.convertDoubleArrayToMap(this.fieldSumArr));
            out.writeGenericValue(this.convertLongArrayToMap(this.countsArr));
            out.writeGenericValue(this.convertDoubleArrayToMap(this.meansArr));
            out.writeGenericValue(this.convertDoubleArrayToMap(this.variancesArr));
            out.writeGenericValue(this.convertDoubleArrayToMap(this.skewnessArr));
            out.writeGenericValue(this.convertDoubleArrayToMap(this.kurtosisArr));
            out.writeGenericValue(this.convertNestedDoubleArrayToMap(this.covariancesArr));
        }
        if (out.getVersion().onOrAfter(ARRAY_IMPL_VERSION)) {
            out.writeBoolean(this.usesMaps);
            out.writeOptionalStringArray(this.fieldNames);
        }
    }

    public void add(String[] fn, double[] fieldVals) {
        if (fieldVals == null) {
            throw new IllegalArgumentException("Cannot add statistics without field values.");
        }
        if (this.usesMaps) {
            this.addMaps(fn, fieldVals);
        } else {
            this.addArrays(fieldVals);
        }
    }

    public void addArrays(double[] fieldVals) {
        if (this.fieldNames.length != fieldVals.length) {
            throw new IllegalArgumentException("Number of field values do not match number of field names.");
        }
        ++this.docCount;
        double[] deltas = new double[this.fieldNames.length];
        for (int i = 0; i < this.fieldNames.length; ++i) {
            double fieldValue = fieldVals[i];
            int n = i;
            this.countsArr[n] = this.countsArr[n] + 1L;
            int n2 = i;
            this.fieldSumArr[n2] = this.fieldSumArr[n2] + fieldValue;
            deltas[i] = fieldValue * (double)this.docCount - this.fieldSumArr[i];
            if (this.docCount == 1L) {
                this.meansArr[i] = fieldValue;
                continue;
            }
            double d = fieldValue - this.meansArr[i];
            double dn = d / (double)this.docCount;
            int n3 = i;
            this.meansArr[n3] = this.meansArr[n3] + dn;
            double m2 = this.variancesArr[i];
            double t1 = d * dn * (double)(this.docCount - 1L);
            int n4 = i;
            this.variancesArr[n4] = this.variancesArr[n4] + t1;
            double m3 = this.skewnessArr[i];
            int n5 = i;
            this.skewnessArr[n5] = this.skewnessArr[n5] + (t1 * dn * ((double)this.docCount - 2.0) - 3.0 * dn * m2);
            double dn2 = dn * dn;
            int n6 = i;
            this.kurtosisArr[n6] = this.kurtosisArr[n6] + (t1 * dn2 * ((double)(this.docCount * this.docCount) - 3.0 * (double)this.docCount + 3.0) + 6.0 * dn2 * m2 - 4.0 * dn * m3);
        }
        this.updateCovarianceArrays(this.fieldNames, deltas);
    }

    public void addMaps(String[] fieldNames, double[] fieldVals) {
        if (fieldNames == null) {
            throw new IllegalArgumentException("Cannot add statistics without field names.");
        }
        if (fieldNames.length != fieldVals.length) {
            throw new IllegalArgumentException("Number of field values do not match number of field names.");
        }
        ++this.docCount;
        HashMap<String, Double> deltas = new HashMap<String, Double>();
        for (int i = 0; i < fieldNames.length; ++i) {
            String fieldName = fieldNames[i];
            double fieldValue = fieldVals[i];
            this.counts.put(fieldName, 1L + (this.counts.containsKey(fieldName) ? this.counts.get(fieldName) : 0L));
            this.fieldSum.put(fieldName, fieldValue + (this.fieldSum.containsKey(fieldName) ? this.fieldSum.get(fieldName) : 0.0));
            deltas.put(fieldName, fieldValue * (double)this.docCount - this.fieldSum.get(fieldName));
            if (this.means.containsKey(fieldName)) {
                double m1 = this.means.get(fieldName);
                double d = fieldValue - m1;
                this.means.put(fieldName, m1 + d / (double)this.docCount);
                double dn = d / (double)this.docCount;
                double t1 = d * dn * (double)(this.docCount - 1L);
                double m2 = this.variances.get(fieldName);
                this.variances.put(fieldName, m2 + t1);
                double m3 = this.skewness.get(fieldName);
                this.skewness.put(fieldName, m3 + (t1 * dn * ((double)this.docCount - 2.0) - 3.0 * dn * m2));
                double dn2 = dn * dn;
                double m4 = t1 * dn2 * ((double)(this.docCount * this.docCount) - 3.0 * (double)this.docCount + 3.0) + 6.0 * dn2 * m2 - 4.0 * dn * m3;
                this.kurtosis.put(fieldName, this.kurtosis.get(fieldName) + m4);
                continue;
            }
            this.means.put(fieldName, fieldValue);
            this.variances.put(fieldName, 0.0);
            this.skewness.put(fieldName, 0.0);
            this.kurtosis.put(fieldName, 0.0);
        }
        this.updateCovarianceMaps(fieldNames, deltas);
    }

    private void updateCovarianceArrays(String[] fieldNames, double[] deltas) {
        if (this.docCount > 1L) {
            for (int i = 0; i < fieldNames.length; ++i) {
                int j = i + 1;
                while (j < fieldNames.length) {
                    double intermediate = 1.0 / ((double)this.docCount * ((double)this.docCount - 1.0)) * deltas[i] * deltas[j];
                    double[] dArray = this.covariancesArr[i];
                    int n = j++;
                    dArray[n] = dArray[n] + intermediate;
                }
            }
        }
    }

    private void updateCovarianceMaps(String[] fieldNames, Map<String, Double> deltas) {
        ArrayList<String> cFieldNames = new ArrayList<String>(Arrays.asList(fieldNames));
        for (int i = 0; i < fieldNames.length; ++i) {
            String fieldName = fieldNames[i];
            cFieldNames.remove(fieldName);
            double dR = deltas.get(fieldName);
            HashMap<String, Double> cFieldVals = this.covariances.get(fieldName) != null ? this.covariances.get(fieldName) : new HashMap<String, Double>();
            for (String cFieldName : cFieldNames) {
                if (cFieldVals.containsKey(cFieldName)) {
                    double newVal = (Double)cFieldVals.get(cFieldName) + 1.0 / ((double)this.docCount * ((double)this.docCount - 1.0)) * dR * deltas.get(cFieldName);
                    cFieldVals.put(cFieldName, newVal);
                    continue;
                }
                cFieldVals.put(cFieldName, 0.0);
            }
            if (cFieldVals.size() <= 0) continue;
            this.covariances.put(fieldName, cFieldVals);
        }
    }

    public void merge(RunningStats other) {
        if (other == null) {
            return;
        }
        if (!this.usesMaps && !other.usesMaps) {
            this.mergeArrays(other);
            return;
        }
        if (!this.usesMaps) {
            this.switchToMaps();
        } else if (!other.usesMaps) {
            other.switchToMaps();
        }
        this.mergeMaps(other);
    }

    private void mergeArrays(RunningStats other) {
        assert (!other.usesMaps && !this.usesMaps);
        if (!Arrays.equals(other.fieldNames, this.fieldNames)) {
            throw new IllegalArgumentException("Cannot merge RunningStats with different fieldNames");
        }
        if (this.docCount == 0L) {
            this.meansArr = other.meansArr;
            this.countsArr = other.countsArr;
            this.fieldSumArr = other.fieldSumArr;
            this.variancesArr = other.variancesArr;
            this.skewnessArr = other.skewnessArr;
            this.kurtosisArr = other.kurtosisArr;
            this.covariancesArr = other.covariancesArr;
            this.docCount = other.docCount;
            return;
        }
        double nA = this.docCount;
        double nB = other.docCount;
        this.docCount += other.docCount;
        double[] deltas = new double[this.fieldNames.length];
        for (int i = 0; i < this.fieldNames.length; ++i) {
            double meanA = this.meansArr[i];
            double varA = this.variancesArr[i];
            double skewA = this.skewnessArr[i];
            double kurtA = this.kurtosisArr[i];
            double meanB = other.meansArr[i];
            double varB = other.variancesArr[i];
            double skewB = other.skewnessArr[i];
            double kurtB = other.kurtosisArr[i];
            int n = i;
            this.countsArr[n] = this.countsArr[n] + other.countsArr[i];
            this.meansArr[i] = (nA * this.meansArr[i] + nB * other.meansArr[i]) / (nA + nB);
            deltas[i] = other.fieldSumArr[i] / nB - this.fieldSumArr[i] / nA;
            int n2 = i;
            this.fieldSumArr[n2] = this.fieldSumArr[n2] + other.fieldSumArr[i];
            double d = meanB - meanA;
            double d2 = d * d;
            double d3 = d * d2;
            double d4 = d2 * d2;
            double n22 = this.docCount * this.docCount;
            double nA2 = nA * nA;
            double nB2 = nB * nB;
            this.variancesArr[i] = varA + varB + d2 * nA * (double)other.docCount / (double)this.docCount;
            double newSkew = skewA + skewB + d3 * nA * nB * (nA - nB) / n22;
            this.skewnessArr[i] = newSkew + 3.0 * d * (nA * varB - nB * varA) / (double)this.docCount;
            double nk = kurtA + kurtB + d4 * nA * nB * (nA2 - nA * nB + nB2) / (n22 * (double)this.docCount);
            this.kurtosisArr[i] = nk + 6.0 * d2 * (nA2 * varB + nB2 * varA) / n22 + 4.0 * d * (nA * skewB - nB * skewA) / (double)this.docCount;
        }
        this.mergeCovarianceArrays(other, deltas);
    }

    private void mergeCovarianceArrays(RunningStats other, double[] deltas) {
        double f = (double)(this.docCount - other.docCount) * (double)other.docCount / (double)this.docCount;
        for (int i = 0; i < this.fieldNames.length; ++i) {
            for (int j = i + 1; j < this.fieldNames.length; ++j) {
                double[] dArray = this.covariancesArr[i];
                int n = j;
                dArray[n] = dArray[n] + (other.covariancesArr[i][j] + f * deltas[i] * deltas[j]);
            }
        }
    }

    private void mergeMaps(RunningStats other) {
        assert (other.usesMaps && this.usesMaps);
        if (this.docCount == 0L) {
            for (Map.Entry<String, Double> fs : other.means.entrySet()) {
                String fieldName = fs.getKey();
                this.means.put(fieldName, (double)fs.getValue());
                this.counts.put(fieldName, (long)other.counts.get(fieldName));
                this.fieldSum.put(fieldName, (double)other.fieldSum.get(fieldName));
                this.variances.put(fieldName, (double)other.variances.get(fieldName));
                this.skewness.put(fieldName, (double)other.skewness.get(fieldName));
                this.kurtosis.put(fieldName, (double)other.kurtosis.get(fieldName));
                if (other.covariances.containsKey(fieldName)) {
                    this.covariances.put(fieldName, other.covariances.get(fieldName));
                }
                this.docCount = other.docCount;
            }
            return;
        }
        double nA = this.docCount;
        double nB = other.docCount;
        this.docCount += other.docCount;
        HashMap<String, Double> deltas = new HashMap<String, Double>();
        for (Map.Entry<String, Double> fs : other.means.entrySet()) {
            String fieldName = fs.getKey();
            double meanA = this.means.get(fieldName);
            double varA = this.variances.get(fieldName);
            double skewA = this.skewness.get(fieldName);
            double kurtA = this.kurtosis.get(fieldName);
            double meanB = other.means.get(fieldName);
            double varB = other.variances.get(fieldName);
            double skewB = other.skewness.get(fieldName);
            double kurtB = other.kurtosis.get(fieldName);
            this.counts.put(fieldName, this.counts.get(fieldName) + other.counts.get(fieldName));
            this.means.put(fieldName, (nA * this.means.get(fieldName) + nB * other.means.get(fieldName)) / (nA + nB));
            deltas.put(fieldName, other.fieldSum.get(fieldName) / nB - this.fieldSum.get(fieldName) / nA);
            this.fieldSum.put(fieldName, this.fieldSum.get(fieldName) + other.fieldSum.get(fieldName));
            double d = meanB - meanA;
            double d2 = d * d;
            double d3 = d * d2;
            double d4 = d2 * d2;
            double n2 = this.docCount * this.docCount;
            double nA2 = nA * nA;
            double nB2 = nB * nB;
            this.variances.put(fieldName, varA + varB + d2 * nA * (double)other.docCount / (double)this.docCount);
            double newSkew = skewA + skewB + d3 * nA * nB * (nA - nB) / n2;
            this.skewness.put(fieldName, newSkew + 3.0 * d * (nA * varB - nB * varA) / (double)this.docCount);
            double nk = kurtA + kurtB + d4 * nA * nB * (nA2 - nA * nB + nB2) / (n2 * (double)this.docCount);
            this.kurtosis.put(fieldName, nk + 6.0 * d2 * (nA2 * varB + nB2 * varA) / n2 + 4.0 * d * (nA * skewB - nB * skewA) / (double)this.docCount);
        }
        this.mergeCovarianceMaps(other, deltas);
    }

    private void mergeCovarianceMaps(RunningStats other, Map<String, Double> deltas) {
        double countA = this.docCount - other.docCount;
        for (Map.Entry<String, Double> fs : other.means.entrySet()) {
            String fieldName = fs.getKey();
            double f = countA * (double)other.docCount / (double)this.docCount;
            double dR = deltas.get(fieldName);
            if (!this.covariances.containsKey(fieldName)) continue;
            Map<String, Double> cFieldVals = this.covariances.get(fieldName);
            for (String cFieldName : cFieldVals.keySet()) {
                double newVal = cFieldVals.get(cFieldName);
                newVal = other.covariances.containsKey(fieldName) && other.covariances.get(fieldName).containsKey(cFieldName) ? (newVal += other.covariances.get(fieldName).get(cFieldName) + f * dR * deltas.get(cFieldName)) : (newVal += other.covariances.get(cFieldName).get(fieldName) + f * dR * deltas.get(cFieldName));
                cFieldVals.put(cFieldName, newVal);
            }
            this.covariances.put(fieldName, cFieldVals);
        }
    }

    public RunningStats clone() {
        try {
            return (RunningStats)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new OpenSearchException("Error trying to create a copy of RunningStats", new Object[0]);
        }
    }

    public boolean usesMaps() {
        return this.usesMaps;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RunningStats that = (RunningStats)o;
        if (this.usesMaps != that.usesMaps) {
            return false;
        }
        if (this.usesMaps) {
            return this.docCount == that.docCount && Objects.equals(this.fieldSum, that.fieldSum) && Objects.equals(this.counts, that.counts) && Objects.equals(this.means, that.means) && Objects.equals(this.variances, that.variances) && Objects.equals(this.skewness, that.skewness) && Objects.equals(this.kurtosis, that.kurtosis) && Objects.equals(this.covariances, that.covariances);
        }
        return this.docCount == that.docCount && Arrays.equals(this.fieldSumArr, that.fieldSumArr) && Arrays.equals(this.countsArr, that.countsArr) && Arrays.equals(this.meansArr, that.meansArr) && Arrays.equals(this.variancesArr, that.variancesArr) && Arrays.equals(this.skewnessArr, that.skewnessArr) && Arrays.equals(this.kurtosisArr, that.kurtosisArr) && Arrays.deepEquals((Object[])this.covariancesArr, (Object[])that.covariancesArr);
    }

    public int hashCode() {
        if (this.usesMaps) {
            return Objects.hash(this.docCount, this.fieldSum, this.counts, this.means, this.variances, this.skewness, this.kurtosis, this.covariances);
        }
        return Objects.hash(this.docCount, Arrays.hashCode(this.fieldSumArr), Arrays.hashCode(this.countsArr), Arrays.hashCode(this.meansArr), Arrays.hashCode(this.variancesArr), Arrays.hashCode(this.skewnessArr), Arrays.hashCode(this.kurtosisArr), Arrays.deepHashCode((Object[])this.covariancesArr));
    }
}

