/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.wmf.tosvg;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.batik.transcoder.wmf.tosvg.AbstractWMFReader;
import org.apache.batik.transcoder.wmf.tosvg.MetaRecord;

public class WMFRecordStore
extends AbstractWMFReader {
    private URL url;
    protected int numRecords;
    protected float vpX;
    protected float vpY;
    protected List records;
    private boolean _bext = true;

    public WMFRecordStore() {
        this.reset();
    }

    public void reset() {
        this.numRecords = 0;
        this.vpX = 0.0f;
        this.vpY = 0.0f;
        this.vpW = 1000;
        this.vpH = 1000;
        this.scaleX = 1.0f;
        this.scaleY = 1.0f;
        this.scaleXY = 1.0f;
        this.inch = 84;
        this.records = new ArrayList(20);
    }

    protected boolean readRecords(DataInputStream dataInputStream) throws IOException {
        int n = 1;
        int n2 = 0;
        this.numRecords = 0;
        while (n > 0) {
            n2 = this.readInt(dataInputStream);
            n2 -= 3;
            n = this.readShort(dataInputStream);
            if (n <= 0) break;
            MetaRecord metaRecord = new MetaRecord();
            switch (n) {
                case 259: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    int n3 = this.readShort(dataInputStream);
                    if (n3 == 8) {
                        this.isotropic = false;
                    }
                    metaRecord.addElement(n3);
                    this.records.add(metaRecord);
                    break;
                }
                case 1583: {
                    int n3;
                    for (n3 = 0; n3 < n2; ++n3) {
                        short s = this.readShort(dataInputStream);
                    }
                    --this.numRecords;
                    break;
                }
                case 2610: {
                    int n4;
                    int n5;
                    int n3 = this.readShort(dataInputStream) * this.ySign;
                    int n6 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    short s = this.readShort(dataInputStream);
                    int n7 = this.readShort(dataInputStream);
                    int n8 = 4;
                    int n9 = 0;
                    int n10 = 0;
                    int n11 = 0;
                    int n12 = 0;
                    int n13 = 0;
                    if ((n7 & 4) != 0) {
                        n10 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                        n11 = this.readShort(dataInputStream) * this.ySign;
                        n12 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                        n13 = this.readShort(dataInputStream) * this.ySign;
                        n8 += 4;
                        n9 = 1;
                    }
                    byte[] byArray = new byte[s];
                    for (n5 = 0; n5 < s; ++n5) {
                        byArray[n5] = dataInputStream.readByte();
                    }
                    n8 += (s + 1) / 2;
                    if (s % 2 != 0) {
                        dataInputStream.readByte();
                    }
                    if (n8 < n2) {
                        for (n4 = n8; n4 < n2; ++n4) {
                            this.readShort(dataInputStream);
                        }
                    }
                    metaRecord = new MetaRecord.ByteRecord(byArray);
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    metaRecord.addElement(n6);
                    metaRecord.addElement(n3);
                    metaRecord.addElement(n7);
                    if (n9 != 0) {
                        metaRecord.addElement(n10);
                        metaRecord.addElement(n11);
                        metaRecord.addElement(n12);
                        metaRecord.addElement(n13);
                    }
                    this.records.add(metaRecord);
                    break;
                }
                case 1313: {
                    int n9;
                    int n7;
                    int n3 = this.readShort(dataInputStream);
                    int n14 = 1;
                    byte[] byArray = new byte[n3];
                    for (n7 = 0; n7 < n3; ++n7) {
                        byArray[n7] = dataInputStream.readByte();
                    }
                    if (n3 % 2 != 0) {
                        dataInputStream.readByte();
                    }
                    n14 += (n3 + 1) / 2;
                    n7 = this.readShort(dataInputStream) * this.ySign;
                    int n8 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    if ((n14 += 2) < n2) {
                        for (n9 = n14; n9 < n2; ++n9) {
                            this.readShort(dataInputStream);
                        }
                    }
                    metaRecord = new MetaRecord.ByteRecord(byArray);
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    metaRecord.addElement(n8);
                    metaRecord.addElement(n7);
                    this.records.add(metaRecord);
                    break;
                }
                case 763: {
                    int n3 = this.readShort(dataInputStream);
                    short s = this.readShort(dataInputStream);
                    short s2 = this.readShort(dataInputStream);
                    int n7 = this.readShort(dataInputStream);
                    int n8 = this.readShort(dataInputStream);
                    int n9 = dataInputStream.readByte();
                    int n10 = dataInputStream.readByte();
                    int n11 = dataInputStream.readByte();
                    int n12 = dataInputStream.readByte() & 0xFF;
                    byte by = dataInputStream.readByte();
                    int n15 = dataInputStream.readByte();
                    byte by2 = dataInputStream.readByte();
                    int n5 = dataInputStream.readByte();
                    int n4 = 2 * (n2 - 9);
                    byte[] byArray = new byte[n4];
                    for (int i = 0; i < n4; ++i) {
                        byArray[i] = dataInputStream.readByte();
                    }
                    String string = new String(byArray);
                    metaRecord = new MetaRecord.StringRecord(string);
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    metaRecord.addElement(n3);
                    metaRecord.addElement(n9);
                    metaRecord.addElement(n8);
                    metaRecord.addElement(n12);
                    metaRecord.addElement(n10);
                    metaRecord.addElement(n11);
                    metaRecord.addElement(n7);
                    metaRecord.addElement(s2);
                    this.records.add(metaRecord);
                    break;
                }
                case 523: 
                case 524: 
                case 525: 
                case 526: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    int n3 = this.readShort(dataInputStream);
                    short s = this.readShort(dataInputStream);
                    if (s < 0) {
                        s = -s;
                        this.xSign = -1;
                    }
                    if (n3 < 0) {
                        n3 = -n3;
                        this.ySign = -1;
                    }
                    metaRecord.addElement((int)((float)s * this.scaleXY));
                    metaRecord.addElement(n3);
                    this.records.add(metaRecord);
                    if (this._bext && n == 524) {
                        this.vpW = s;
                        this.vpH = n3;
                        if (!this.isotropic) {
                            this.scaleXY = (float)this.vpW / (float)this.vpH;
                        }
                        this.vpW = (int)((float)this.vpW * this.scaleXY);
                        this._bext = false;
                    }
                    if (this.isAldus) break;
                    this.width = this.vpW;
                    this.height = this.vpH;
                    break;
                }
                case 527: 
                case 529: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    int n3 = this.readShort(dataInputStream) * this.ySign;
                    int n16 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    metaRecord.addElement(n16);
                    metaRecord.addElement(n3);
                    this.records.add(metaRecord);
                    break;
                }
                case 1040: 
                case 1042: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    int n3 = this.readShort(dataInputStream);
                    short s = this.readShort(dataInputStream);
                    short s3 = this.readShort(dataInputStream);
                    int n7 = this.readShort(dataInputStream);
                    metaRecord.addElement(s3);
                    metaRecord.addElement(n3);
                    metaRecord.addElement(n7);
                    metaRecord.addElement(s);
                    this.records.add(metaRecord);
                    this.scaleX = this.scaleX * (float)s3 / (float)n7;
                    this.scaleY = this.scaleY * (float)n3 / (float)s;
                    break;
                }
                case 764: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    metaRecord.addElement(this.readShort(dataInputStream));
                    int n3 = this.readInt(dataInputStream);
                    int n17 = n3 & 0xFF;
                    int n18 = (n3 & 0xFF00) >> 8;
                    int n7 = (n3 & 0xFF0000) >> 16;
                    int n8 = (n3 & 0x3000000) >> 24;
                    metaRecord.addElement(n17);
                    metaRecord.addElement(n18);
                    metaRecord.addElement(n7);
                    metaRecord.addElement(this.readShort(dataInputStream));
                    this.records.add(metaRecord);
                    break;
                }
                case 762: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    metaRecord.addElement(this.readShort(dataInputStream));
                    int n3 = this.readInt(dataInputStream);
                    int n19 = this.readInt(dataInputStream);
                    if (n2 == 6) {
                        this.readShort(dataInputStream);
                    }
                    int n20 = n19 & 0xFF;
                    int n7 = (n19 & 0xFF00) >> 8;
                    int n8 = (n19 & 0xFF0000) >> 16;
                    int n9 = (n19 & 0x3000000) >> 24;
                    metaRecord.addElement(n20);
                    metaRecord.addElement(n7);
                    metaRecord.addElement(n8);
                    metaRecord.addElement(n3);
                    this.records.add(metaRecord);
                    break;
                }
                case 302: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    int n3 = this.readShort(dataInputStream);
                    if (n2 > 1) {
                        for (int i = 1; i < n2; ++i) {
                            this.readShort(dataInputStream);
                        }
                    }
                    metaRecord.addElement(n3);
                    this.records.add(metaRecord);
                    break;
                }
                case 513: 
                case 521: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    int n3 = this.readInt(dataInputStream);
                    int n21 = n3 & 0xFF;
                    int n22 = (n3 & 0xFF00) >> 8;
                    int n7 = (n3 & 0xFF0000) >> 16;
                    int n8 = (n3 & 0x3000000) >> 24;
                    metaRecord.addElement(n21);
                    metaRecord.addElement(n22);
                    metaRecord.addElement(n7);
                    this.records.add(metaRecord);
                    break;
                }
                case 531: 
                case 532: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    int n3 = this.readShort(dataInputStream) * this.ySign;
                    int n23 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    metaRecord.addElement(n23);
                    metaRecord.addElement(n3);
                    this.records.add(metaRecord);
                    break;
                }
                case 262: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    int n3 = this.readShort(dataInputStream);
                    if (n2 > 1) {
                        for (int i = 1; i < n2; ++i) {
                            this.readShort(dataInputStream);
                        }
                    }
                    metaRecord.addElement(n3);
                    this.records.add(metaRecord);
                    break;
                }
                case 1336: {
                    int n10;
                    int n9;
                    int n8;
                    int n7;
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    int n3 = this.readShort(dataInputStream);
                    int[] nArray = new int[n3];
                    int n24 = 0;
                    for (n7 = 0; n7 < n3; ++n7) {
                        nArray[n7] = this.readShort(dataInputStream);
                        n24 += nArray[n7];
                    }
                    metaRecord.addElement(n3);
                    for (n7 = 0; n7 < n3; ++n7) {
                        metaRecord.addElement(nArray[n7]);
                    }
                    n7 = n3 + 1;
                    for (n8 = 0; n8 < n3; ++n8) {
                        n9 = nArray[n8];
                        for (n10 = 0; n10 < n9; ++n10) {
                            metaRecord.addElement((int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY));
                            metaRecord.addElement(this.readShort(dataInputStream) * this.ySign);
                        }
                    }
                    this.records.add(metaRecord);
                    break;
                }
                case 804: 
                case 805: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    int n3 = this.readShort(dataInputStream);
                    metaRecord.addElement(n3);
                    for (int i = 0; i < n3; ++i) {
                        metaRecord.addElement((int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY));
                        metaRecord.addElement(this.readShort(dataInputStream) * this.ySign);
                    }
                    this.records.add(metaRecord);
                    break;
                }
                case 1046: 
                case 1048: 
                case 1051: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    int n3 = this.readShort(dataInputStream) * this.ySign;
                    int n25 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n26 = this.readShort(dataInputStream) * this.ySign;
                    int n7 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    metaRecord.addElement(n7);
                    metaRecord.addElement(n26);
                    metaRecord.addElement(n25);
                    metaRecord.addElement(n3);
                    this.records.add(metaRecord);
                    break;
                }
                case 1791: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    int n3 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n27 = this.readShort(dataInputStream) * this.ySign;
                    int n28 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n7 = this.readShort(dataInputStream) * this.ySign;
                    metaRecord.addElement(n3);
                    metaRecord.addElement(n27);
                    metaRecord.addElement(n28);
                    metaRecord.addElement(n7);
                    this.records.add(metaRecord);
                    break;
                }
                case 1564: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    int n3 = this.readShort(dataInputStream) * this.ySign;
                    int n29 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n30 = this.readShort(dataInputStream) * this.ySign;
                    int n7 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n8 = this.readShort(dataInputStream) * this.ySign;
                    int n9 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    metaRecord.addElement(n9);
                    metaRecord.addElement(n8);
                    metaRecord.addElement(n7);
                    metaRecord.addElement(n30);
                    metaRecord.addElement(n29);
                    metaRecord.addElement(n3);
                    this.records.add(metaRecord);
                    break;
                }
                case 2071: 
                case 2074: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    int n3 = this.readShort(dataInputStream) * this.ySign;
                    int n31 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n32 = this.readShort(dataInputStream) * this.ySign;
                    int n7 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n8 = this.readShort(dataInputStream) * this.ySign;
                    int n9 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n10 = this.readShort(dataInputStream) * this.ySign;
                    int n11 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    metaRecord.addElement(n11);
                    metaRecord.addElement(n10);
                    metaRecord.addElement(n9);
                    metaRecord.addElement(n8);
                    metaRecord.addElement(n7);
                    metaRecord.addElement(n32);
                    metaRecord.addElement(n31);
                    metaRecord.addElement(n3);
                    this.records.add(metaRecord);
                    break;
                }
                case 1565: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    int n3 = this.readInt(dataInputStream);
                    int n33 = this.readShort(dataInputStream) * this.ySign;
                    int n34 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n7 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n8 = this.readShort(dataInputStream) * this.ySign;
                    metaRecord.addElement(n3);
                    metaRecord.addElement(n33);
                    metaRecord.addElement(n34);
                    metaRecord.addElement(n8);
                    metaRecord.addElement(n7);
                    this.records.add(metaRecord);
                    break;
                }
                case 258: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    int n3 = this.readShort(dataInputStream);
                    metaRecord.addElement(n3);
                    if (n2 > 1) {
                        for (int i = 1; i < n2; ++i) {
                            this.readShort(dataInputStream);
                        }
                    }
                    this.records.add(metaRecord);
                    break;
                }
                case 260: {
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    int n3 = n2 == 1 ? (int)this.readShort(dataInputStream) : this.readInt(dataInputStream);
                    metaRecord.addElement(n3);
                    this.records.add(metaRecord);
                    break;
                }
                case 2881: {
                    int n3 = dataInputStream.readInt() & 0xFF;
                    int n35 = this.readShort(dataInputStream) * this.ySign;
                    int n36 = this.readShort(dataInputStream) * this.xSign;
                    int n7 = this.readShort(dataInputStream) * this.ySign;
                    int n8 = this.readShort(dataInputStream) * this.xSign;
                    int n9 = this.readShort(dataInputStream) * this.ySign;
                    int n10 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n11 = this.readShort(dataInputStream) * this.ySign;
                    int n12 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n37 = 2 * n2 - 20;
                    byte[] byArray = new byte[n37];
                    for (int i = 0; i < n37; ++i) {
                        byArray[i] = dataInputStream.readByte();
                    }
                    metaRecord = new MetaRecord.ByteRecord(byArray);
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    metaRecord.addElement(n3);
                    metaRecord.addElement(n35);
                    metaRecord.addElement(n36);
                    metaRecord.addElement(n7);
                    metaRecord.addElement(n8);
                    metaRecord.addElement(n9);
                    metaRecord.addElement(n10);
                    metaRecord.addElement(n11);
                    metaRecord.addElement(n12);
                    this.records.add(metaRecord);
                    break;
                }
                case 3907: {
                    int n5;
                    int n3 = dataInputStream.readInt() & 0xFF;
                    short s = this.readShort(dataInputStream);
                    int n38 = this.readShort(dataInputStream) * this.ySign;
                    int n7 = this.readShort(dataInputStream) * this.xSign;
                    int n8 = this.readShort(dataInputStream) * this.ySign;
                    int n9 = this.readShort(dataInputStream) * this.xSign;
                    int n10 = this.readShort(dataInputStream) * this.ySign;
                    int n11 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n12 = this.readShort(dataInputStream) * this.ySign;
                    int n39 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n15 = 2 * n2 - 22;
                    byte[] byArray = new byte[n15];
                    for (n5 = 0; n5 < n15; ++n5) {
                        byArray[n5] = dataInputStream.readByte();
                    }
                    metaRecord = new MetaRecord.ByteRecord(byArray);
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    metaRecord.addElement(n3);
                    metaRecord.addElement(n38);
                    metaRecord.addElement(n7);
                    metaRecord.addElement(n8);
                    metaRecord.addElement(n9);
                    metaRecord.addElement(n10);
                    metaRecord.addElement(n11);
                    metaRecord.addElement(n12);
                    metaRecord.addElement(n39);
                    this.records.add(metaRecord);
                    break;
                }
                case 2368: {
                    int n15;
                    int n3 = dataInputStream.readInt() & 0xFF;
                    short s = this.readShort(dataInputStream);
                    short s4 = this.readShort(dataInputStream);
                    int n7 = this.readShort(dataInputStream);
                    int n8 = this.readShort(dataInputStream);
                    int n9 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n10 = this.readShort(dataInputStream);
                    int n11 = (int)((float)(this.readShort(dataInputStream) * this.xSign) * this.scaleXY);
                    int n12 = 2 * n2 - 18;
                    if (n12 > 0) {
                        byte[] byArray = new byte[n12];
                        for (n15 = 0; n15 < n12; ++n15) {
                            byArray[n15] = dataInputStream.readByte();
                        }
                        metaRecord = new MetaRecord.ByteRecord(byArray);
                        metaRecord.numPoints = n2;
                        metaRecord.functionId = n;
                    } else {
                        metaRecord.numPoints = n2;
                        metaRecord.functionId = n;
                        for (int i = 0; i < n12; ++i) {
                            dataInputStream.readByte();
                        }
                    }
                    metaRecord.addElement(n3);
                    metaRecord.addElement(n8);
                    metaRecord.addElement(n9);
                    metaRecord.addElement(s);
                    metaRecord.addElement(s4);
                    metaRecord.addElement(n10);
                    metaRecord.addElement(n11);
                    this.records.add(metaRecord);
                    break;
                }
                case 322: {
                    int n7;
                    int n3 = dataInputStream.readInt() & 0xFF;
                    int n40 = 2 * n2 - 4;
                    byte[] byArray = new byte[n40];
                    for (n7 = 0; n7 < n40; ++n7) {
                        byArray[n7] = dataInputStream.readByte();
                    }
                    metaRecord = new MetaRecord.ByteRecord(byArray);
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    metaRecord.addElement(n3);
                    this.records.add(metaRecord);
                    break;
                }
                default: {
                    int n3;
                    metaRecord.numPoints = n2;
                    metaRecord.functionId = n;
                    for (n3 = 0; n3 < n2; ++n3) {
                        metaRecord.addElement(this.readShort(dataInputStream));
                    }
                    this.records.add(metaRecord);
                }
            }
            ++this.numRecords;
        }
        if (!this.isAldus) {
            this.right = (int)this.vpX;
            this.left = (int)(this.vpX + (float)this.vpW);
            this.top = (int)this.vpY;
            this.bottom = (int)(this.vpY + (float)this.vpH);
        }
        this.setReading(false);
        return true;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL uRL) {
        this.url = uRL;
    }

    public MetaRecord getRecord(int n) {
        return (MetaRecord)this.records.get(n);
    }

    public int getNumRecords() {
        return this.numRecords;
    }

    public float getVpX() {
        return this.vpX;
    }

    public float getVpY() {
        return this.vpY;
    }

    public void setVpX(float f) {
        this.vpX = f;
    }

    public void setVpY(float f) {
        this.vpY = f;
    }
}

