# _SchedulerStats
<span class="source-link">[[Source]](src/runtime_info/_scheduler_stats.md#L-0-1)</span>

Pony struct for the Pony scheduler stats C struct that can be used to
inspect statistics about a scheduler thread.


```pony
struct ref _SchedulerStats
```

## Constructors

### create
<span class="source-link">[[Source]](src/runtime_info/_scheduler_stats.md#L-0-1)</span>


```pony
new iso create()
: _SchedulerStats iso^
```

#### Returns

* [_SchedulerStats](runtime_info-_SchedulerStats.md) iso^

---

## Public fields

### var mem_used: [I64](builtin-I64.md) val
<span class="source-link">[[Source]](src/runtime_info/_scheduler_stats.md#L-0-7)</span>

Memory used by mutemaps




---

### var mem_allocated: [I64](builtin-I64.md) val
<span class="source-link">[[Source]](src/runtime_info/_scheduler_stats.md#L-0-12)</span>

Memory allocated for mutemaps




---

### var mem_used_actors: [I64](builtin-I64.md) val
<span class="source-link">[[Source]](src/runtime_info/_scheduler_stats.md#L-0-17)</span>

Memory used for actors created and for GC acquire/release actormaps




---

### var mem_allocated_actors: [I64](builtin-I64.md) val
<span class="source-link">[[Source]](src/runtime_info/_scheduler_stats.md#L-0-22)</span>

Memory allocated for actors created and for GC acquire/release actormaps




---

### var created_actors_counter: [USize](builtin-USize.md) val
<span class="source-link">[[Source]](src/runtime_info/_scheduler_stats.md#L-0-27)</span>

Count of actors created




---

### var destroyed_actors_counter: [USize](builtin-USize.md) val
<span class="source-link">[[Source]](src/runtime_info/_scheduler_stats.md#L-0-32)</span>

Count of actors destroyed




---

### var actor_app_cpu: [USize](builtin-USize.md) val
<span class="source-link">[[Source]](src/runtime_info/_scheduler_stats.md#L-0-37)</span>

Amount of cpu used to process actor app messages




---

### var actor_gc_mark_cpu: [USize](builtin-USize.md) val
<span class="source-link">[[Source]](src/runtime_info/_scheduler_stats.md#L-0-42)</span>

Amount of cpu used for mark phase to garbage collect actor heaps




---

### var actor_gc_sweep_cpu: [USize](builtin-USize.md) val
<span class="source-link">[[Source]](src/runtime_info/_scheduler_stats.md#L-0-47)</span>

Amount of cpu used sweep phase to garbage collect actor heaps




---

### var actor_system_cpu: [USize](builtin-USize.md) val
<span class="source-link">[[Source]](src/runtime_info/_scheduler_stats.md#L-0-52)</span>

Amount of cpu used to process actor system messages




---

### var msg_cpu: [USize](builtin-USize.md) val
<span class="source-link">[[Source]](src/runtime_info/_scheduler_stats.md#L-0-57)</span>

Amount of cpu used to process scheduler system messages




---

### var misc_cpu: [USize](builtin-USize.md) val
<span class="source-link">[[Source]](src/runtime_info/_scheduler_stats.md#L-0-62)</span>

Amount of cpu used to by scheduler while waiting to do work




---

### var mem_used_inflight_messages: [I64](builtin-I64.md) val
<span class="source-link">[[Source]](src/runtime_info/_scheduler_stats.md#L-0-67)</span>

Memory used by inflight messages




---

### var mem_allocated_inflight_messages: [I64](builtin-I64.md) val
<span class="source-link">[[Source]](src/runtime_info/_scheduler_stats.md#L-0-72)</span>

Memory allocated for inflight messages




---

### var num_inflight_messages: [I64](builtin-I64.md) val
<span class="source-link">[[Source]](src/runtime_info/_scheduler_stats.md#L-0-77)</span>

Number of inflight messages




---

