/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkLabelMapToBinaryImageFilter_h
#define sitkLabelMapToBinaryImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class LabelMapToBinaryImageFilter
\brief Convert a LabelMap to a binary image.

LabelMapToBinaryImageFilter to a binary image. All the objects in the image are used as foreground. The background values of the original binary image can be restored by passing this image to the filter with the SetBackgroundImage() method.

This implementation was taken from the Insight Journal paper: https://doi.org/10.54294/q6auw4 

\author Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA de Jouy-en-Josas, France.


\see LabelMapToLabelImageFilter , LabelMapMaskImageFilter
\sa itk::simple::LabelMapToBinary for the procedural interface
\sa itk::LabelMapToBinaryImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT LabelMapToBinaryImageFilter : public ImageFilter {
    public:
      using Self = LabelMapToBinaryImageFilter;

      /** Destructor */
      virtual ~LabelMapToBinaryImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      LabelMapToBinaryImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = LabelPixelIDTypeList;
\

      /**
       * Set/Get the value used as "background" in the output image. Defaults to NumericTraits<PixelType>::NonpositiveMin() .
       */
      SITK_RETURN_SELF_TYPE_HEADER SetBackgroundValue ( double BackgroundValue ) { this->m_BackgroundValue = BackgroundValue; return *this; }

      /**
       * Set/Get the value used as "background" in the output image. Defaults to NumericTraits<PixelType>::NonpositiveMin() .
       */
      double GetBackgroundValue() const { return this->m_BackgroundValue; }\

      /**
       * Set/Get the value used as "foreground" in the output image. Defaults to NumericTraits<PixelType>::max() .
       */
      SITK_RETURN_SELF_TYPE_HEADER SetForegroundValue ( double ForegroundValue ) { this->m_ForegroundValue = ForegroundValue; return *this; }

      /**
       * Set/Get the value used as "foreground" in the output image. Defaults to NumericTraits<PixelType>::max() .
       */
      double GetForegroundValue() const { return this->m_ForegroundValue; }

      /** Name of this class */
      std::string GetName() const { return std::string ("LabelMapToBinaryImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */

      Image Execute ( const Image& image1 );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /*  */
      double  m_BackgroundValue{0};

      /*  */
      double  m_ForegroundValue{1.0};


    };

    /**\
     * \brief Convert a LabelMap to a binary image.
     *
     * This function directly calls the execute method of LabelMapToBinaryImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::LabelMapToBinaryImageFilter for the object oriented interface
     * @{
     */

     SITKBasicFilters_EXPORT Image LabelMapToBinary ( const Image& image1, double backgroundValue = 0, double foregroundValue = 1.0 );

     /** @} */
}
#endif
