"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AsyncMutex = void 0;
class AsyncMutex {
    #locked = false;
    #queue = [];
    get count() {
        return this.#queue.length;
    }
    async run(fn) {
        if (this.#locked) {
            await new Promise((resolve) => this.#queue.push(resolve));
        }
        this.#locked = true;
        try {
            return await fn();
        }
        finally {
            this.#locked = false;
            const next = this.#queue.shift();
            if (next) {
                next();
            }
        }
    }
    clear() {
        this.#queue.length = 0;
    }
}
exports.AsyncMutex = AsyncMutex;
//# sourceMappingURL=async-mutex.js.map