"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = loader;

var _loaderUtils = require("loader-utils");

var _schemaUtils = require("schema-utils");

var _sourceMap = require("source-map");

var _options = _interopRequireDefault(require("./options.json"));

var _utils = require("./utils");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
  MIT License http://www.opensource.org/licenses/mit-license.php
  Author Tobias Koppers @sokra
*/
const FOOTER = '/*** EXPORTS FROM exports-loader ***/\n';

function loader(content, sourceMap) {
  const options = (0, _loaderUtils.getOptions)(this);
  (0, _schemaUtils.validate)(_options.default, options, {
    name: 'Exports Loader',
    baseDataPath: 'options'
  });
  const type = options.type || 'module';
  const callback = this.async();
  let exports;

  try {
    exports = (0, _utils.getExports)(type, options.exports);
  } catch (error) {
    callback(error);
    return;
  }

  const exportsCode = (0, _utils.renderExports)(this, type, exports);

  if (this.sourceMap && sourceMap) {
    const node = _sourceMap.SourceNode.fromStringWithSourceMap(content, new _sourceMap.SourceMapConsumer(sourceMap));

    node.add(`\n${FOOTER}${exportsCode}`);
    const result = node.toStringWithSourceMap({
      file: this.resourcePath
    });
    callback(null, result.code, result.map.toJSON());
    return;
  }

  callback(null, `${content}\n${FOOTER}${exportsCode}`, sourceMap);
}