/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.FileDescriptor;
import java.nio.file.attribute.FileTime;
import jnr.posix.FileStat;
import jnr.posix.NanosecondFileStat;
import jnr.posix.util.Platform;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFile;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Error;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.FileResource;
import org.jruby.util.JRubyFile;

@JRubyClass(name={"File::Stat"}, include={"Comparable"})
public class RubyFileStat
extends RubyObject {
    private static final long serialVersionUID = 1L;
    private static final int S_IRUGO = 292;
    private static final int S_IWUGO = 146;
    private static final int S_IXUGO = 73;
    public static final int BILLION = 1000000000;
    private FileResource file;
    private FileStat stat;

    private void checkInitialized(ThreadContext context) {
        if (this.stat == null) {
            throw Error.typeError(context, "uninitialized File::Stat");
        }
    }

    public static RubyClass createFileStatClass(ThreadContext context, RubyClass Object2, RubyClass File2, RubyModule Comparable2) {
        return (RubyClass)((RubyModule)((RubyModule)File2.defineClassUnder(context, "Stat", Object2, RubyFileStat::new)).include(context, Comparable2)).defineMethods(context, RubyFileStat.class);
    }

    protected RubyFileStat(Ruby runtime2, RubyClass clazz) {
        super(runtime2, clazz);
    }

    public static RubyFileStat newFileStat(Ruby runtime2, String filename2, boolean lstat2) {
        RubyFileStat stat2 = new RubyFileStat(runtime2, runtime2.getFileStat());
        stat2.setup(filename2, lstat2);
        return stat2;
    }

    public static RubyFileStat newFileStat(Ruby runtime2, FileDescriptor descriptor) {
        RubyFileStat stat2 = new RubyFileStat(runtime2, runtime2.getFileStat());
        stat2.setup(descriptor);
        return stat2;
    }

    public static RubyFileStat newFileStat(Ruby runtime2, int fileno2) {
        RubyFileStat stat2 = new RubyFileStat(runtime2, runtime2.getFileStat());
        stat2.setup(fileno2);
        return stat2;
    }

    private void setup(FileDescriptor descriptor) {
        this.stat = this.getRuntime().getPosix().fstat(descriptor);
    }

    private void setup(int fileno2) {
        this.stat = this.getRuntime().getPosix().fstat(fileno2);
    }

    private void setup(String filename2, boolean lstat2) {
        Ruby runtime2 = this.getRuntime();
        if (Platform.IS_WINDOWS && ((String)filename2).length() == 2 && ((String)filename2).charAt(1) == ':' && Character.isLetter(((String)filename2).charAt(0))) {
            filename2 = (String)filename2 + "/";
        }
        this.file = JRubyFile.createResource(runtime2, (String)filename2);
        FileStat fileStat = this.stat = lstat2 ? this.file.lstat() : this.file.stat();
        if (this.stat == null) {
            if (Platform.IS_WINDOWS) {
                switch (this.file.errno()) {
                    case 2: 
                    case 3: 
                    case 53: 
                    case 123: {
                        throw runtime2.newErrnoENOENTError((String)filename2);
                    }
                }
            }
            throw runtime2.newErrnoFromInt(this.file.errno(), (String)filename2);
        }
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject initialize19(IRubyObject fname, Block unusedBlock) {
        return this.initialize(fname, unusedBlock);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject initialize(IRubyObject fname, Block unusedBlock) {
        return this.initialize(this.getCurrentContext(), fname, unusedBlock);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject fname, Block unusedBlock) {
        this.setup(RubyFile.get_path(context, fname).toString(), false);
        return this;
    }

    @JRubyMethod(name={"atime"})
    public IRubyObject atime(ThreadContext context) {
        RubyTime rubyTime;
        this.checkInitialized(context);
        FileStat fileStat = this.stat;
        if (fileStat instanceof NanosecondFileStat) {
            NanosecondFileStat nanoStat = (NanosecondFileStat)fileStat;
            rubyTime = RubyTime.newTimeFromNanoseconds(context, this.stat.atime() * 1000000000L + nanoStat.aTimeNanoSecs());
        } else {
            rubyTime = context.runtime.newTime(this.stat.atime() * 1000L);
        }
        return rubyTime;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject atime() {
        return this.atime(this.getCurrentContext());
    }

    @JRubyMethod(name={"blksize"})
    public IRubyObject blockSize(ThreadContext context) {
        this.checkInitialized(context);
        if (Platform.IS_WINDOWS) {
            return context.nil;
        }
        return Convert.asFixnum(context, this.stat.blockSize());
    }

    @Deprecated(since="9.0.4.0")
    public RubyFixnum blksize() {
        ThreadContext context = this.getCurrentContext();
        this.checkInitialized(context);
        return Convert.asFixnum(context, this.stat.blockSize());
    }

    @JRubyMethod(name={"blockdev?"})
    public IRubyObject blockdev_p(ThreadContext context) {
        this.checkInitialized(context);
        return Convert.asBoolean(context, this.stat.isBlockDev());
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject blockdev_p() {
        return this.blockdev_p(this.getCurrentContext());
    }

    @JRubyMethod(name={"blocks"})
    public IRubyObject blocks(ThreadContext context) {
        this.checkInitialized(context);
        if (Platform.IS_WINDOWS) {
            return context.nil;
        }
        return Convert.asFixnum(context, this.stat.blocks());
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject blocks() {
        return this.blocks(this.getCurrentContext());
    }

    @JRubyMethod(name={"chardev?"})
    public IRubyObject chardev_p(ThreadContext context) {
        this.checkInitialized(context);
        return Convert.asBoolean(context, this.stat.isCharDev());
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject chardev_p() {
        return this.chardev_p(this.getCurrentContext());
    }

    @JRubyMethod(name={"<=>"})
    public IRubyObject cmp(ThreadContext context, IRubyObject other) {
        long time2;
        this.checkInitialized(context);
        if (!(other instanceof RubyFileStat)) {
            return context.nil;
        }
        long time1 = this.stat.mtime();
        if (time1 == (time2 = ((RubyFileStat)other).stat.mtime())) {
            return Convert.asFixnum(context, 0);
        }
        if (time1 < time2) {
            return Convert.asFixnum(context, -1);
        }
        return Convert.asFixnum(context, 1);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject cmp(IRubyObject other) {
        return this.cmp(this.getCurrentContext(), other);
    }

    @JRubyMethod(name={"ctime"})
    public IRubyObject ctime(ThreadContext context) {
        this.checkInitialized(context);
        FileStat fileStat = this.stat;
        if (fileStat instanceof NanosecondFileStat) {
            NanosecondFileStat nfs = (NanosecondFileStat)fileStat;
            return RubyTime.newTimeFromNanoseconds(context, this.stat.ctime() * 1000000000L + nfs.cTimeNanoSecs());
        }
        return context.runtime.newTime(this.stat.ctime() * 1000L);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject ctime() {
        return this.ctime(this.getCurrentContext());
    }

    @JRubyMethod(name={"birthtime"})
    public IRubyObject birthtime(ThreadContext context) {
        FileTime btime;
        this.checkInitialized(context);
        if (Platform.IS_LINUX) {
            throw context.runtime.newNotImplementedError("birthtime() function is unimplemented on this machine");
        }
        if (this.file == null || (btime = RubyFile.getBirthtimeWithNIO(this.file.absolutePath())) == null) {
            return this.ctime();
        }
        return context.runtime.newTime(btime.toMillis());
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject birthtime() {
        return this.birthtime(this.getCurrentContext());
    }

    @JRubyMethod(name={"dev"})
    public IRubyObject dev(ThreadContext context) {
        this.checkInitialized(context);
        return Convert.asFixnum(context, this.stat.dev());
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject dev() {
        return this.dev(this.getCurrentContext());
    }

    @JRubyMethod(name={"dev_major"})
    public IRubyObject devMajor(ThreadContext context) {
        this.checkInitialized(context);
        if (Platform.IS_WINDOWS) {
            return context.nil;
        }
        return Convert.asFixnum(context, this.stat.major(this.stat.dev()));
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject devMajor() {
        return this.devMajor(this.getCurrentContext());
    }

    @JRubyMethod(name={"dev_minor"})
    public IRubyObject devMinor(ThreadContext context) {
        this.checkInitialized(context);
        if (Platform.IS_WINDOWS) {
            return context.nil;
        }
        return Convert.asFixnum(context, this.stat.minor(this.stat.dev()));
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject devMinor() {
        return this.devMinor(this.getCurrentContext());
    }

    @JRubyMethod(name={"directory?"})
    public RubyBoolean directory_p(ThreadContext context) {
        this.checkInitialized(context);
        return Convert.asBoolean(context, this.stat.isDirectory());
    }

    @Deprecated(since="10.0.0.0")
    public RubyBoolean directory_p() {
        return this.directory_p(this.getCurrentContext());
    }

    @JRubyMethod(name={"executable?"})
    public IRubyObject executable_p(ThreadContext context) {
        this.checkInitialized(context);
        return Convert.asBoolean(context, this.stat.isExecutable());
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject executable_p() {
        return this.executable_p(this.getCurrentContext());
    }

    @JRubyMethod(name={"executable_real?"})
    public IRubyObject executableReal_p(ThreadContext context) {
        this.checkInitialized(context);
        return Convert.asBoolean(context, this.stat.isExecutableReal());
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject executableReal_p() {
        return this.executableReal_p(this.getCurrentContext());
    }

    @JRubyMethod(name={"file?"})
    public RubyBoolean file_p(ThreadContext context) {
        this.checkInitialized(context);
        return Convert.asBoolean(context, this.stat.isFile());
    }

    @Deprecated(since="10.0.0.0")
    public RubyBoolean file_p() {
        return this.file_p(this.getCurrentContext());
    }

    @JRubyMethod(name={"ftype"})
    public RubyString ftype(ThreadContext context) {
        this.checkInitialized(context);
        return Create.newString(context, this.stat.ftype());
    }

    @Deprecated(since="10.0.0.0")
    public RubyString ftype() {
        return this.ftype(this.getCurrentContext());
    }

    @JRubyMethod(name={"gid"})
    public IRubyObject gid(ThreadContext context) {
        this.checkInitialized(context);
        if (Platform.IS_WINDOWS) {
            return RubyFixnum.zero(context.runtime);
        }
        return Convert.asFixnum(context, this.stat.gid());
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject gid() {
        return this.gid(this.getCurrentContext());
    }

    @JRubyMethod(name={"grpowned?"})
    public IRubyObject group_owned_p(ThreadContext context) {
        this.checkInitialized(context);
        if (Platform.IS_WINDOWS) {
            return context.fals;
        }
        return Convert.asBoolean(context, this.stat.isGroupOwned());
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject group_owned_p() {
        return this.group_owned_p(this.getCurrentContext());
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(ThreadContext context, IRubyObject original) {
        if (!(original instanceof RubyFileStat)) {
            throw Error.typeError(context, "wrong argument class");
        }
        this.checkFrozen();
        RubyFileStat originalFileStat = (RubyFileStat)original;
        this.file = originalFileStat.file;
        this.stat = originalFileStat.stat;
        return this;
    }

    @JRubyMethod(name={"ino"})
    public IRubyObject ino(ThreadContext context) {
        this.checkInitialized(context);
        return Convert.asFixnum(context, this.stat.ino());
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject ino() {
        return this.ino(this.getCurrentContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext context) {
        StringBuilder buf = new StringBuilder("#<");
        buf.append(this.getMetaClass().getRealClass().getName(context));
        if (this.stat == null) {
            buf.append(": uninitialized");
        } else {
            buf.append(' ');
            try {
                buf.append("dev=0x").append(Long.toHexString(this.stat.dev()));
            }
            catch (Exception exception2) {
            }
            finally {
                buf.append(", ");
            }
            try {
                buf.append("ino=").append(this.stat.ino());
            }
            catch (Exception exception3) {
            }
            finally {
                buf.append(", ");
            }
            buf.append("mode=0").append(Integer.toOctalString(this.stat.mode())).append(", ");
            try {
                buf.append("nlink=").append(this.stat.nlink());
            }
            catch (Exception exception4) {
            }
            finally {
                buf.append(", ");
            }
            try {
                buf.append("uid=").append(this.stat.uid());
            }
            catch (Exception exception5) {
            }
            finally {
                buf.append(", ");
            }
            try {
                buf.append("gid=").append(this.stat.gid());
            }
            catch (Exception exception6) {
            }
            finally {
                buf.append(", ");
            }
            try {
                buf.append("rdev=0x").append(Long.toHexString(this.stat.rdev()));
            }
            catch (Exception exception7) {
            }
            finally {
                buf.append(", ");
            }
            buf.append("size=").append(this.sizeInternal(context)).append(", ");
            try {
                buf.append("blksize=").append(this.blockSize(context).inspect(context).toString());
            }
            catch (Exception exception8) {
            }
            finally {
                buf.append(", ");
            }
            try {
                buf.append("blocks=").append(this.blocks().inspect(context).toString());
            }
            catch (Exception exception9) {
            }
            finally {
                buf.append(", ");
            }
            buf.append("atime=").append(this.atime().inspect(context)).append(", ");
            buf.append("mtime=").append(this.mtime().inspect(context)).append(", ");
            buf.append("ctime=").append(this.ctime().inspect(context));
            if (Platform.IS_BSD || Platform.IS_MAC) {
                buf.append(", ").append("birthtime=").append(this.birthtime());
            }
        }
        buf.append('>');
        return Create.newString(context, buf.toString());
    }

    @JRubyMethod(name={"uid"})
    public IRubyObject uid(ThreadContext context) {
        this.checkInitialized(context);
        if (Platform.IS_WINDOWS) {
            return RubyFixnum.zero(context.runtime);
        }
        return Convert.asFixnum(context, this.stat.uid());
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject uid() {
        return this.uid(this.getCurrentContext());
    }

    @JRubyMethod(name={"mode"})
    public IRubyObject mode(ThreadContext context) {
        this.checkInitialized(context);
        return Convert.asFixnum(context, this.stat.mode());
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject mode() {
        return this.mode(this.getCurrentContext());
    }

    @JRubyMethod(name={"mtime"})
    public IRubyObject mtime(ThreadContext context) {
        this.checkInitialized(context);
        return this.stat instanceof NanosecondFileStat ? RubyTime.newTimeFromNanoseconds(context, this.stat.mtime() * 1000000000L + ((NanosecondFileStat)this.stat).mTimeNanoSecs()) : context.runtime.newTime(this.stat.mtime() * 1000L);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject mtime() {
        return this.mtime(this.getCurrentContext());
    }

    public IRubyObject mtimeEquals(ThreadContext context, IRubyObject other) {
        boolean equal;
        FileStat otherStat = RubyFileStat.newFileStat((Ruby)context.runtime, (String)other.convertToString().toString(), (boolean)false).stat;
        boolean bl = equal = this.stat.mtime() == otherStat.mtime();
        if (this.stat instanceof NanosecondFileStat && otherStat instanceof NanosecondFileStat) {
            equal = equal && ((NanosecondFileStat)this.stat).mTimeNanoSecs() == ((NanosecondFileStat)otherStat).mTimeNanoSecs();
        }
        return Convert.asBoolean(context, equal);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject mtimeEquals(IRubyObject other) {
        return this.mtimeEquals(this.getCurrentContext(), other);
    }

    public IRubyObject mtimeGreaterThan(ThreadContext context, IRubyObject other) {
        FileStat otherStat = RubyFileStat.newFileStat((Ruby)context.runtime, (String)other.convertToString().toString(), (boolean)false).stat;
        boolean gt = this.stat instanceof NanosecondFileStat && otherStat instanceof NanosecondFileStat ? this.stat.mtime() * 1000000000L + ((NanosecondFileStat)this.stat).mTimeNanoSecs() > otherStat.mtime() * 1000000000L + ((NanosecondFileStat)otherStat).mTimeNanoSecs() : this.stat.mtime() > otherStat.mtime();
        return Convert.asBoolean(context, gt);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject mtimeGreaterThan(IRubyObject other) {
        return this.mtimeGreaterThan(this.getCurrentContext(), other);
    }

    public IRubyObject mtimeLessThan(ThreadContext context, IRubyObject other) {
        FileStat otherStat = RubyFileStat.newFileStat((Ruby)context.runtime, (String)other.convertToString().toString(), (boolean)false).stat;
        boolean lt = this.stat instanceof NanosecondFileStat && otherStat instanceof NanosecondFileStat ? this.stat.mtime() * 1000000000L + ((NanosecondFileStat)this.stat).mTimeNanoSecs() < otherStat.mtime() * 1000000000L + ((NanosecondFileStat)otherStat).mTimeNanoSecs() : this.stat.mtime() < otherStat.mtime();
        return Convert.asBoolean(context, lt);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject mtimeLessThan(IRubyObject other) {
        return this.mtimeLessThan(this.getCurrentContext(), other);
    }

    @JRubyMethod(name={"nlink"})
    public IRubyObject nlink(ThreadContext context) {
        this.checkInitialized(context);
        return Convert.asFixnum(context, this.stat.nlink());
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject nlink() {
        return this.nlink(this.getCurrentContext());
    }

    @JRubyMethod(name={"owned?"})
    public IRubyObject owned_p(ThreadContext context) {
        this.checkInitialized(context);
        return Convert.asBoolean(context, this.stat.isOwned());
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject owned_p() {
        return this.owned_p(this.getCurrentContext());
    }

    @JRubyMethod(name={"pipe?"})
    public IRubyObject pipe_p(ThreadContext context) {
        this.checkInitialized(context);
        return Convert.asBoolean(context, this.stat.isNamedPipe());
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject pipe_p() {
        return this.pipe_p(this.getCurrentContext());
    }

    @JRubyMethod(name={"rdev"})
    public IRubyObject rdev(ThreadContext context) {
        this.checkInitialized(context);
        return Convert.asFixnum(context, this.stat.rdev());
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject rdev() {
        return this.rdev(this.getCurrentContext());
    }

    @JRubyMethod(name={"rdev_major"})
    public IRubyObject rdevMajor(ThreadContext context) {
        this.checkInitialized(context);
        if (Platform.IS_WINDOWS) {
            return context.nil;
        }
        return Convert.asFixnum(context, this.stat.major(this.stat.rdev()));
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject rdevMajor() {
        return this.rdevMajor(this.getCurrentContext());
    }

    @JRubyMethod(name={"rdev_minor"})
    public IRubyObject rdevMinor(ThreadContext context) {
        this.checkInitialized(context);
        if (Platform.IS_WINDOWS) {
            return context.nil;
        }
        return Convert.asFixnum(context, this.stat.minor(this.stat.rdev()));
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject rdevMinor() {
        return this.rdevMinor(this.getCurrentContext());
    }

    @JRubyMethod(name={"readable?"})
    public IRubyObject readable_p(ThreadContext context) {
        this.checkInitialized(context);
        return Convert.asBoolean(context, this.stat.isReadable());
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject readable_p() {
        return this.readable_p(this.getCurrentContext());
    }

    @JRubyMethod(name={"readable_real?"})
    public IRubyObject readableReal_p(ThreadContext context) {
        this.checkInitialized(context);
        return Convert.asBoolean(context, this.stat.isReadableReal());
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject readableReal_p() {
        return this.readableReal_p(this.getCurrentContext());
    }

    @JRubyMethod(name={"setgid?"})
    public IRubyObject setgid_p(ThreadContext context) {
        this.checkInitialized(context);
        return Convert.asBoolean(context, this.stat.isSetgid());
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject setgid_p() {
        return this.setgid_p(this.getCurrentContext());
    }

    @JRubyMethod(name={"setuid?"})
    public IRubyObject setuid_p(ThreadContext context) {
        this.checkInitialized(context);
        return Convert.asBoolean(context, this.stat.isSetuid());
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject setuid_p() {
        return this.setuid_p(this.getCurrentContext());
    }

    private long sizeInternal(ThreadContext context) {
        this.checkInitialized(context);
        if (Platform.IS_WINDOWS && this.file != null) {
            try {
                return this.file.length();
            }
            catch (SecurityException ex) {
                return 0L;
            }
        }
        return this.stat.st_size();
    }

    @JRubyMethod(name={"size"})
    public IRubyObject size(ThreadContext context) {
        return Convert.asFixnum(context, this.sizeInternal(context));
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject size() {
        return this.size(this.getCurrentContext());
    }

    @JRubyMethod(name={"size?"})
    public IRubyObject size_p(ThreadContext context) {
        long size2 = this.sizeInternal(context);
        if (size2 == 0L) {
            return context.nil;
        }
        return Convert.asFixnum(context, size2);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject size_p() {
        return this.size_p(this.getCurrentContext());
    }

    @JRubyMethod(name={"socket?"})
    public IRubyObject socket_p(ThreadContext context) {
        this.checkInitialized(context);
        return Convert.asBoolean(context, this.stat.isSocket());
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject socket_p() {
        return this.socket_p(this.getCurrentContext());
    }

    @JRubyMethod(name={"sticky?"})
    public IRubyObject sticky_p(ThreadContext context) {
        this.checkInitialized(context);
        return context.runtime.getPosix().isNative() ? Convert.asBoolean(context, this.stat.isSticky()) : context.nil;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject sticky_p() {
        return this.sticky_p(this.getCurrentContext());
    }

    @JRubyMethod(name={"symlink?"})
    public IRubyObject symlink_p(ThreadContext context) {
        this.checkInitialized(context);
        return Convert.asBoolean(context, this.stat.isSymlink());
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject symlink_p() {
        return this.symlink_p(this.getCurrentContext());
    }

    @JRubyMethod(name={"writable?"})
    public IRubyObject writable_p(ThreadContext context) {
        this.checkInitialized(context);
        return Convert.asBoolean(context, this.stat.isWritable());
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject writable_p() {
        return this.writable_p(this.getCurrentContext());
    }

    @JRubyMethod(name={"writable_real?"})
    public IRubyObject writableReal_p(ThreadContext context) {
        this.checkInitialized(context);
        return Convert.asBoolean(context, this.stat.isWritableReal());
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject writableReal_p() {
        return this.writableReal_p(this.getCurrentContext());
    }

    @JRubyMethod(name={"zero?"})
    public IRubyObject zero_p(ThreadContext context) {
        this.checkInitialized(context);
        return Convert.asBoolean(context, this.stat.isEmpty());
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject zero_p() {
        return this.zero_p(this.getCurrentContext());
    }

    @JRubyMethod(name={"world_readable?"})
    public IRubyObject worldReadable(ThreadContext context) {
        return this.getWorldMode(context, 4);
    }

    @JRubyMethod(name={"world_writable?"})
    public IRubyObject worldWritable(ThreadContext context) {
        return this.getWorldMode(context, 2);
    }

    private IRubyObject getWorldMode(ThreadContext context, int mode2) {
        this.checkInitialized(context);
        if ((this.stat.mode() & mode2) == mode2) {
            return Convert.asFixnum(context, this.stat.mode() & 0x1FF);
        }
        return context.nil;
    }
}

