/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import org.jruby.IncludedModuleWrapper;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Check;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Error;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.NullMethod;
import org.jruby.javasupport.Java;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ClassProvider;

@JRubyClass(name={"Java::JavaPackage"}, parent="Module")
public class JavaPackage
extends RubyModule {
    final String packageName;

    static RubyClass createJavaPackageClass(ThreadContext context, RubyModule Java2, RubyClass Module2, RubyModule Kernel2) {
        BlankSlateWrapper superClass = new BlankSlateWrapper(context.runtime, Module2, Kernel2);
        RubyClass JavaPackage2 = RubyClass.newClass(context, (RubyClass)superClass, null);
        JavaPackage2.setMetaClass(Module2);
        ((RubyModule)((RubyModule)JavaPackage2.allocator(ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR)).baseName("JavaPackage")).defineMethods(context, JavaPackage.class);
        ((MetaClass)JavaPackage2.makeMetaClass(context, superClass)).setAttached(JavaPackage2);
        JavaPackage2.setParent(Java2);
        return JavaPackage2;
    }

    static RubyModule newPackage(Ruby runtime2, CharSequence name2, RubyModule parent) {
        JavaPackage pkgModule = new JavaPackage(runtime2, name2);
        pkgModule.addClassProvider(JavaClassProvider.INSTANCE);
        return pkgModule;
    }

    static CharSequence buildPackageName(RubyModule parentPackage, String name2) {
        return ((JavaPackage)parentPackage).packageRelativeName(name2);
    }

    private JavaPackage(Ruby runtime2, CharSequence packageName) {
        super(runtime2, runtime2.getJavaSupport().getJavaPackageClass(), false);
        this.packageName = packageName.toString();
    }

    public String getPackageName() {
        return this.packageName;
    }

    @Deprecated(since="10.0.0.0")
    public RubyString package_name() {
        return this.package_name(this.getCurrentContext());
    }

    @JRubyMethod(name={"package_name"}, alias={"to_s"})
    public RubyString package_name(ThreadContext context) {
        return Create.newString(context, this.packageName);
    }

    @Override
    @Deprecated(since="10.0.0.0")
    public RubyString to_s() {
        return (RubyString)this.to_s(this.getCurrentContext());
    }

    @Override
    public IRubyObject to_s(ThreadContext context) {
        return this.package_name();
    }

    @Override
    @JRubyMethod
    public IRubyObject inspect(ThreadContext context) {
        return Create.newString(context, this.getName(context));
    }

    @Override
    @JRubyMethod(name={"==="})
    public RubyBoolean op_eqq(ThreadContext context, IRubyObject obj) {
        return Convert.asBoolean(context, obj == this || this.isInstance(obj));
    }

    @JRubyMethod(name={"const_missing"})
    public IRubyObject const_missing(ThreadContext context, IRubyObject name2) {
        return this.relativeJavaClassOrPackage(context, name2, false);
    }

    @Override
    @JRubyMethod(name={"const_get"})
    public final IRubyObject const_get(ThreadContext context, IRubyObject name2) {
        IRubyObject constant = this.getConstantNoConstMissing(context, name2.toString(), false, false);
        return constant != null ? constant : this.relativeJavaClassOrPackage(context, name2, false);
    }

    @Override
    @JRubyMethod(name={"const_get"})
    public final IRubyObject const_get(ThreadContext context, IRubyObject name2, IRubyObject inherit) {
        IRubyObject constant = this.getConstantNoConstMissing(context, name2.toString(), inherit.isTrue(), false);
        return constant != null ? constant : this.relativeJavaClassOrPackage(context, name2, false);
    }

    @Override
    public final boolean hasConstant(String name2) {
        return this.constantTableContains(name2);
    }

    @Override
    public final IRubyObject fetchConstant(ThreadContext context, String name2, boolean includePrivate) {
        RubyModule.ConstantEntry entry = this.constantEntryFetch(name2);
        if (entry == null) {
            return null;
        }
        if (entry.hidden && !includePrivate) {
            throw Error.nameError(context, "private constant " + this.getName(context) + "::" + name2 + " referenced", name2);
        }
        return entry.value;
    }

    final CharSequence packageRelativeName(CharSequence name2) {
        int length2 = this.packageName.length();
        StringBuilder fullName = new StringBuilder(length2 + 1 + name2.length());
        fullName.append(this.packageName);
        if (length2 > 0) {
            fullName.append('.');
        }
        return fullName.append(name2);
    }

    private RubyModule relativeJavaClassOrPackage(ThreadContext context, IRubyObject name2, boolean cacheMethod) {
        return Java.getProxyOrPackageUnderPackage(context, this, name2.toString(), cacheMethod);
    }

    @Deprecated(since="10.0.0.0")
    RubyModule relativeJavaProxyClass(Ruby runtime2, IRubyObject name2) {
        ThreadContext context = runtime2.getCurrentContext();
        String fullName = this.packageRelativeName(name2.toString()).toString();
        return Java.getProxyClass(context, Java.getJavaClass(context, fullName));
    }

    @JRubyMethod(name={"respond_to?"})
    public IRubyObject respond_to_p(ThreadContext context, IRubyObject name2) {
        return this.respond_to(context, name2, false);
    }

    @JRubyMethod(name={"respond_to?"})
    public IRubyObject respond_to_p(ThreadContext context, IRubyObject name2, IRubyObject includePrivate) {
        return this.respond_to(context, name2, includePrivate.isTrue());
    }

    private IRubyObject respond_to(ThreadContext context, IRubyObject mname, boolean includePrivate) {
        RubySymbol name2 = Check.checkID(context, mname);
        if (this.getMetaClass().respondsToMethod(name2.idString(), !includePrivate)) {
            return context.tru;
        }
        return context.nil;
    }

    private RubyBoolean checkMetaClassBoundMethod(ThreadContext context, String name2, boolean includePrivate) {
        DynamicMethod method2 = this.getMetaClass().searchMethod(name2);
        if (!method2.isUndefined() && !method2.isNotImplemented()) {
            if (!includePrivate && method2.getVisibility() == Visibility.PRIVATE) {
                return context.fals;
            }
            return context.tru;
        }
        return null;
    }

    @JRubyMethod(name={"respond_to_missing?"})
    public IRubyObject respond_to_missing_p(ThreadContext context, IRubyObject name2) {
        return this.respond_to_missing(context, name2, false);
    }

    @JRubyMethod(name={"respond_to_missing?"})
    public IRubyObject respond_to_missing_p(ThreadContext context, IRubyObject name2, IRubyObject includePrivate) {
        return this.respond_to_missing(context, name2, includePrivate.isTrue());
    }

    private RubyBoolean respond_to_missing(ThreadContext context, IRubyObject mname, boolean includePrivate) {
        return Convert.asBoolean(context, BlankSlateWrapper.handlesMethod(Check.checkID(context, mname).idString()) == null);
    }

    @JRubyMethod(name={"method_missing"})
    public IRubyObject method_missing(ThreadContext context, IRubyObject name2) {
        return Java.getProxyOrPackageUnderPackage(context, this, name2.toString(), true);
    }

    @JRubyMethod(name={"method_missing"}, rest=true)
    public IRubyObject method_missing(ThreadContext context, IRubyObject[] args2) {
        if (args2.length > 1) {
            throw JavaPackage.packageMethodArgumentMismatch(context, this, args2[0].toString(), args2.length - 1);
        }
        return this.method_missing(context, args2[0]);
    }

    static RaiseException packageMethodArgumentMismatch(ThreadContext context, RubyModule pkg, String method2, int argsLength) {
        String packageName = ((JavaPackage)pkg).packageName;
        return Error.argumentError(context, "Java package '" + packageName + "' does not have a method '" + method2 + "' with " + argsLength + (argsLength == 1 ? " argument" : " arguments"));
    }

    public final boolean isAvailable() {
        return this.getPackage() != null;
    }

    private Package getPackage() {
        return Package.getPackage(this.packageName);
    }

    @JRubyMethod(name={"available?"})
    public IRubyObject available_p(ThreadContext context) {
        return Convert.asBoolean(context, this.isAvailable());
    }

    @JRubyMethod(name={"sealed?"})
    public IRubyObject sealed_p(ThreadContext context) {
        Package pkg = this.getPackage();
        if (pkg == null) {
            return context.nil;
        }
        return Convert.asBoolean(context, pkg.isSealed());
    }

    @Override
    public <T> T toJava(Class<T> target2) {
        if (target2.isAssignableFrom(Package.class)) {
            return target2.cast(this.getPackage());
        }
        return super.toJava(target2);
    }

    @Override
    public int hashCode() {
        return this.id;
    }

    static final class BlankSlateWrapper
    extends IncludedModuleWrapper {
        BlankSlateWrapper(Ruby runtime2, RubyClass superClass, RubyModule delegate) {
            super(runtime2, superClass, delegate);
        }

        @Override
        protected DynamicMethod searchMethodCommon(String id) {
            if ("superclass".equals(id)) {
                return new MethodValue(id, this.superClass);
            }
            return (id = BlankSlateWrapper.handlesMethod(id)) != null ? this.superClass.searchMethodInner(id) : NullMethod.INSTANCE;
        }

        private static String handlesMethod(String name2) {
            switch (name2) {
                case "class": 
                case "singleton_class": {
                    return name2;
                }
                case "object_id": 
                case "name": {
                    return name2;
                }
                case "const_set": {
                    return name2;
                }
                case "inspect": 
                case "to_s": {
                    return name2;
                }
                case "throw": 
                case "catch": {
                    return name2;
                }
                case "singleton_method_added": 
                case "singleton_method_undefined": 
                case "singleton_method_removed": 
                case "define_singleton_method": {
                    return name2;
                }
                case "__constants__": {
                    return "constants";
                }
                case "__methods__": {
                    return "methods";
                }
            }
            int last2 = name2.length() - 1;
            if (last2 >= 0) {
                switch (name2.charAt(last2)) {
                    case '!': 
                    case '=': 
                    case '?': {
                        return name2;
                    }
                }
                switch (name2.charAt(0)) {
                    case '<': 
                    case '=': 
                    case '>': {
                        return name2;
                    }
                    case '_': {
                        if (last2 <= 0 || name2.charAt(1) != '_') break;
                        return name2;
                    }
                }
            }
            return null;
        }

        @Override
        public void addSubclass(RubyClass subclass) {
        }

        private static class MethodValue
        extends DynamicMethod {
            private final IRubyObject value;

            MethodValue(String name2, IRubyObject value2) {
                super(name2);
                this.value = value2;
            }

            @Override
            public final IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                return this.call(context, self2, clazz, name2);
            }

            @Override
            public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2) {
                return this.value;
            }

            @Override
            public DynamicMethod dup() {
                try {
                    return (DynamicMethod)super.clone();
                }
                catch (CloneNotSupportedException ex) {
                    throw new AssertionError((Object)ex);
                }
            }

            @Override
            @Deprecated(since="9.3.0.0")
            public Arity getArity() {
                return Arity.NO_ARGUMENTS;
            }

            @Override
            public Signature getSignature() {
                return Signature.NO_ARGUMENTS;
            }
        }
    }

    private static class JavaClassProvider
    implements ClassProvider {
        static final JavaClassProvider INSTANCE = new JavaClassProvider();

        private JavaClassProvider() {
        }

        @Override
        public RubyClass defineClassUnder(ThreadContext context, RubyModule pkg, String name2, RubyClass superClazz) {
            if (superClazz != null) {
                return null;
            }
            String subPackageName = JavaPackage.buildPackageName(pkg, name2).toString();
            Class javaClass = Java.getJavaClass(context, subPackageName);
            return (RubyClass)Java.getProxyClass(context, javaClass);
        }

        @Override
        public RubyModule defineModuleUnder(ThreadContext context, RubyModule pkg, String name2) {
            String subPackageName = JavaPackage.buildPackageName(pkg, name2).toString();
            Class javaClass = Java.getJavaClass(context, subPackageName);
            return Java.getInterfaceModule(context, javaClass);
        }
    }
}

