/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Map;
import java.util.function.Function;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.ProcessorStateException;
import org.apache.kafka.streams.processor.internals.SerdeGetter;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.query.KeyQuery;
import org.apache.kafka.streams.query.PositionBound;
import org.apache.kafka.streams.query.Query;
import org.apache.kafka.streams.query.QueryConfig;
import org.apache.kafka.streams.query.QueryResult;
import org.apache.kafka.streams.query.RangeQuery;
import org.apache.kafka.streams.query.ResultOrder;
import org.apache.kafka.streams.query.TimestampedKeyQuery;
import org.apache.kafka.streams.query.TimestampedRangeQuery;
import org.apache.kafka.streams.query.internals.InternalQueryResultUtil;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.internals.MeteredIterator;
import org.apache.kafka.streams.state.internals.MeteredKeyValueStore;
import org.apache.kafka.streams.state.internals.StoreQueryUtils;
import org.apache.kafka.streams.state.internals.ValueAndTimestampSerde;
import org.apache.kafka.streams.state.internals.ValueAndTimestampSerializer;

public class MeteredTimestampedKeyValueStore<K, V>
extends MeteredKeyValueStore<K, ValueAndTimestamp<V>>
implements TimestampedKeyValueStore<K, V> {
    private final Map<Class, StoreQueryUtils.QueryHandler> queryHandlers = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry(RangeQuery.class, (query, positionBound, config, store) -> this.runRangeQuery(query, positionBound, config)), Utils.mkEntry(TimestampedRangeQuery.class, (query, positionBound, config, store) -> this.runTimestampedRangeQuery(query, positionBound, config)), Utils.mkEntry(KeyQuery.class, (query, positionBound, config, store) -> this.runKeyQuery(query, positionBound, config)), Utils.mkEntry(TimestampedKeyQuery.class, (query, positionBound, config, store) -> this.runTimestampedKeyQuery(query, positionBound, config))});

    MeteredTimestampedKeyValueStore(KeyValueStore<Bytes, byte[]> inner, String metricScope, Time time, Serde<K> keySerde, Serde<ValueAndTimestamp<V>> valueSerde) {
        super(inner, metricScope, time, keySerde, valueSerde);
    }

    @Override
    protected Serde<ValueAndTimestamp<V>> prepareValueSerdeForStore(Serde<ValueAndTimestamp<V>> valueSerde, SerdeGetter getter) {
        if (valueSerde == null) {
            return new ValueAndTimestampSerde(getter.valueSerde());
        }
        return super.prepareValueSerdeForStore(valueSerde, getter);
    }

    public RawAndDeserializedValue<V> getWithBinary(K key) {
        try {
            return StreamsMetricsImpl.maybeMeasureLatency(() -> {
                byte[] serializedValue = (byte[])((KeyValueStore)this.wrapped()).get(this.keyBytes(key));
                return new RawAndDeserializedValue(serializedValue, (ValueAndTimestamp)this.outerValue(serializedValue));
            }, this.time, this.getSensor);
        }
        catch (ProcessorStateException e) {
            String message = String.format(e.getMessage(), key);
            throw new ProcessorStateException(message, (Throwable)((Object)e));
        }
    }

    public boolean putIfDifferentValues(K key, ValueAndTimestamp<V> newValue, byte[] oldSerializedValue) {
        try {
            return StreamsMetricsImpl.maybeMeasureLatency(() -> {
                byte[] newSerializedValue = this.serdes.rawValue(newValue);
                if (ValueAndTimestampSerializer.valuesAreSameAndTimeIsIncreasing(oldSerializedValue, newSerializedValue)) {
                    return false;
                }
                ((KeyValueStore)this.wrapped()).put(this.keyBytes(key), newSerializedValue);
                return true;
            }, this.time, this.putSensor);
        }
        catch (ProcessorStateException e) {
            String message = String.format(e.getMessage(), key, newValue);
            throw new ProcessorStateException(message, (Throwable)((Object)e));
        }
    }

    @Override
    public <R> QueryResult<R> query(Query<R> query, PositionBound positionBound, QueryConfig config) {
        QueryResult<Object> result;
        long start = this.time.nanoseconds();
        StoreQueryUtils.QueryHandler handler = this.queryHandlers.get(query.getClass());
        if (handler == null) {
            result = ((KeyValueStore)this.wrapped()).query(query, positionBound, config);
            if (config.isCollectExecutionInfo()) {
                result.addExecutionInfo("Handled in " + String.valueOf(this.getClass()) + " in " + (this.time.nanoseconds() - start) + "ns");
            }
        } else {
            result = handler.apply(query, positionBound, config, this);
            if (config.isCollectExecutionInfo()) {
                result.addExecutionInfo("Handled in " + String.valueOf(this.getClass()) + " with serdes " + String.valueOf(this.serdes) + " in " + (this.time.nanoseconds() - start) + "ns");
            }
        }
        return result;
    }

    private <R> QueryResult<R> runTimestampedKeyQuery(Query<R> query, PositionBound positionBound, QueryConfig config) {
        QueryResult<Object> result;
        TimestampedKeyQuery typedKeyQuery = (TimestampedKeyQuery)query;
        KeyQuery rawKeyQuery = KeyQuery.withKey(this.keyBytes(typedKeyQuery.key()));
        QueryResult rawResult = ((KeyValueStore)this.wrapped()).query(rawKeyQuery, positionBound, config);
        if (rawResult.isSuccess()) {
            Function deserializer = StoreQueryUtils.deserializeValue(this.serdes, this.wrapped());
            ValueAndTimestamp valueAndTimestamp = (ValueAndTimestamp)deserializer.apply((byte[])rawResult.getResult());
            QueryResult<ValueAndTimestamp> typedQueryResult = InternalQueryResultUtil.copyAndSubstituteDeserializedResult(rawResult, valueAndTimestamp);
            result = typedQueryResult;
        } else {
            result = rawResult;
        }
        return result;
    }

    private <R> QueryResult<R> runTimestampedRangeQuery(Query<R> query, PositionBound positionBound, QueryConfig config) {
        QueryResult<Object> result;
        QueryResult rawResult;
        TimestampedRangeQuery typedQuery = (TimestampedRangeQuery)query;
        ResultOrder order = typedQuery.resultOrder();
        RangeQuery rawRangeQuery = RangeQuery.withRange(this.keyBytes(typedQuery.lowerBound().orElse(null)), this.keyBytes(typedQuery.upperBound().orElse(null)));
        if (order.equals((Object)ResultOrder.DESCENDING)) {
            rawRangeQuery = rawRangeQuery.withDescendingKeys();
        }
        if (order.equals((Object)ResultOrder.ASCENDING)) {
            rawRangeQuery = rawRangeQuery.withAscendingKeys();
        }
        if ((rawResult = ((KeyValueStore)this.wrapped()).query(rawRangeQuery, positionBound, config)).isSuccess()) {
            KeyValueIterator iterator = (KeyValueIterator)rawResult.getResult();
            MeteredTimestampedKeyValueStoreIterator resultIterator = new MeteredTimestampedKeyValueStoreIterator(iterator, this.getSensor, StoreQueryUtils.deserializeValue(this.serdes, this.wrapped()), false);
            QueryResult<MeteredTimestampedKeyValueStoreIterator> typedQueryResult = InternalQueryResultUtil.copyAndSubstituteDeserializedResult(rawResult, resultIterator);
            result = typedQueryResult;
        } else {
            result = rawResult;
        }
        return result;
    }

    private <R> QueryResult<R> runKeyQuery(Query<R> query, PositionBound positionBound, QueryConfig config) {
        QueryResult<Object> result;
        KeyQuery typedKeyQuery = (KeyQuery)query;
        KeyQuery rawKeyQuery = KeyQuery.withKey(this.keyBytes(typedKeyQuery.getKey()));
        QueryResult rawResult = ((KeyValueStore)this.wrapped()).query(rawKeyQuery, positionBound, config);
        if (rawResult.isSuccess()) {
            Function deserializer = StoreQueryUtils.deserializeValue(this.serdes, this.wrapped());
            ValueAndTimestamp valueAndTimestamp = (ValueAndTimestamp)deserializer.apply((byte[])rawResult.getResult());
            Object plainValue = valueAndTimestamp == null ? null : (Object)valueAndTimestamp.value();
            QueryResult<Object> typedQueryResult = InternalQueryResultUtil.copyAndSubstituteDeserializedResult(rawResult, plainValue);
            result = typedQueryResult;
        } else {
            result = rawResult;
        }
        return result;
    }

    private <R> QueryResult<R> runRangeQuery(Query<R> query, PositionBound positionBound, QueryConfig config) {
        QueryResult<Object> result;
        QueryResult rawResult;
        RangeQuery typedQuery = (RangeQuery)query;
        ResultOrder order = typedQuery.resultOrder();
        RangeQuery rawRangeQuery = RangeQuery.withRange(this.keyBytes(typedQuery.getLowerBound().orElse(null)), this.keyBytes(typedQuery.getUpperBound().orElse(null)));
        if (order.equals((Object)ResultOrder.DESCENDING)) {
            rawRangeQuery = rawRangeQuery.withDescendingKeys();
        }
        if (order.equals((Object)ResultOrder.ASCENDING)) {
            rawRangeQuery = rawRangeQuery.withAscendingKeys();
        }
        if ((rawResult = ((KeyValueStore)this.wrapped()).query(rawRangeQuery, positionBound, config)).isSuccess()) {
            KeyValueIterator iterator = (KeyValueIterator)rawResult.getResult();
            MeteredTimestampedKeyValueStoreIterator resultIterator = new MeteredTimestampedKeyValueStoreIterator(iterator, this.getSensor, StoreQueryUtils.deserializeValue(this.serdes, this.wrapped()), true);
            QueryResult<MeteredTimestampedKeyValueStoreIterator> typedQueryResult = InternalQueryResultUtil.copyAndSubstituteDeserializedResult(rawResult, resultIterator);
            result = typedQueryResult;
        } else {
            result = rawResult;
        }
        return result;
    }

    static class RawAndDeserializedValue<ValueType> {
        final byte[] serializedValue;
        final ValueAndTimestamp<ValueType> value;

        RawAndDeserializedValue(byte[] serializedValue, ValueAndTimestamp<ValueType> value) {
            this.serializedValue = serializedValue;
            this.value = value;
        }
    }

    private class MeteredTimestampedKeyValueStoreIterator
    implements KeyValueIterator<K, V>,
    MeteredIterator {
        private final KeyValueIterator<Bytes, byte[]> iter;
        private final Sensor sensor;
        private final long startNs;
        private final long startTimestampMs;
        private final Function<byte[], ValueAndTimestamp<V>> valueAndTimestampDeserializer;
        private final boolean returnPlainValue;

        private MeteredTimestampedKeyValueStoreIterator(KeyValueIterator<Bytes, byte[]> iter, Sensor sensor, Function<byte[], ValueAndTimestamp<V>> valueAndTimestampDeserializer, boolean returnPlainValue) {
            this.iter = iter;
            this.sensor = sensor;
            this.valueAndTimestampDeserializer = valueAndTimestampDeserializer;
            this.startNs = MeteredTimestampedKeyValueStore.this.time.nanoseconds();
            this.startTimestampMs = MeteredTimestampedKeyValueStore.this.time.milliseconds();
            this.returnPlainValue = returnPlainValue;
            MeteredTimestampedKeyValueStore.this.openIterators.add(this);
        }

        @Override
        public long startTimestamp() {
            return this.startTimestampMs;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public KeyValue<K, V> next() {
            KeyValue keyValue = (KeyValue)this.iter.next();
            if (this.returnPlainValue) {
                Object plainValue = this.valueAndTimestampDeserializer.apply((byte[])keyValue.value).value();
                return KeyValue.pair(MeteredTimestampedKeyValueStore.this.serdes.keyFrom(((Bytes)keyValue.key).get()), plainValue);
            }
            return KeyValue.pair(MeteredTimestampedKeyValueStore.this.serdes.keyFrom(((Bytes)keyValue.key).get()), this.valueAndTimestampDeserializer.apply((byte[])keyValue.value));
        }

        @Override
        public void close() {
            try {
                this.iter.close();
            }
            finally {
                long duration = MeteredTimestampedKeyValueStore.this.time.nanoseconds() - this.startNs;
                this.sensor.record((double)duration);
                MeteredTimestampedKeyValueStore.this.iteratorDurationSensor.record((double)duration);
                MeteredTimestampedKeyValueStore.this.openIterators.remove(this);
            }
        }

        @Override
        public K peekNextKey() {
            return MeteredTimestampedKeyValueStore.this.serdes.keyFrom(this.iter.peekNextKey().get());
        }
    }
}

