/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor.bcextensions;

import io.quarkus.arc.processor.bcextensions.DotNames;
import io.quarkus.arc.processor.bcextensions.ExtensionMethod;
import jakarta.enterprise.inject.build.compatible.spi.BuildCompatibleExtension;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.JandexReflection;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

class ExtensionInvoker {
    private final Map<String, Class<?>> extensionClasses = new ConcurrentHashMap();
    private final Map<Class<?>, Object> extensionClassInstances = new ConcurrentHashMap();
    private final IndexView extensionsIndex;

    ExtensionInvoker(List<BuildCompatibleExtension> extensions) {
        Indexer extensionsIndexer = new Indexer();
        ArrayList<BuildCompatibleExtension> allExtensions = new ArrayList<BuildCompatibleExtension>(extensions);
        for (BuildCompatibleExtension extension : ServiceLoader.load(BuildCompatibleExtension.class)) {
            allExtensions.add(extension);
        }
        for (BuildCompatibleExtension extension : allExtensions) {
            Class extensionClass = extension.getClass();
            this.extensionClasses.put(extensionClass.getName(), extensionClass);
            this.extensionClassInstances.put(extensionClass, extension);
            try {
                InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(extensionClass.getName().replace('.', '/').concat(".class"));
                try {
                    extensionsIndexer.index(stream);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        this.extensionsIndex = extensionsIndexer.complete();
    }

    List<ExtensionMethod> findExtensionMethods(DotName annotation) {
        return this.extensionsIndex.getAllKnownImplementors(DotNames.BUILD_COMPATIBLE_EXTENSION).stream().flatMap(it -> it.annotationsMap().getOrDefault(annotation, Collections.emptyList()).stream().filter(ann -> ann.target().kind() == AnnotationTarget.Kind.METHOD).map(ann -> ann.target().asMethod())).sorted((m1, m2) -> {
            int p2;
            if (m1 == m2) {
                return 0;
            }
            int p1 = this.getExtensionMethodPriority((MethodInfo)m1);
            return p1 < (p2 = this.getExtensionMethodPriority((MethodInfo)m2)) ? -1 : 1;
        }).map(ExtensionMethod::new).toList();
    }

    private int getExtensionMethodPriority(MethodInfo method) {
        AnnotationInstance priority = method.declaredAnnotation(DotNames.PRIORITY);
        if (priority != null) {
            return priority.value().asInt();
        }
        return 2500;
    }

    void callExtensionMethod(ExtensionMethod method, List<Object> arguments) throws ReflectiveOperationException {
        Class[] parameterTypes = new Class[arguments.size()];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterTypes[i] = JandexReflection.loadRawType((Type)method.parameterType(i));
        }
        Class<?> extensionClass = this.extensionClasses.get(method.extensionClass.name().toString());
        Object extensionClassInstance = this.extensionClassInstances.get(extensionClass);
        Method methodReflective = extensionClass.getDeclaredMethod(method.name(), parameterTypes);
        methodReflective.setAccessible(true);
        methodReflective.invoke(extensionClassInstance, arguments.toArray());
    }

    void invalidate() {
        this.extensionClasses.clear();
        this.extensionClassInstances.clear();
    }

    boolean isEmpty() {
        return this.extensionClasses.isEmpty();
    }
}

