/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.io;

import edu.stanford.nlp.io.BZip2PipedOutputStream;
import edu.stanford.nlp.io.EncodingFileReader;
import edu.stanford.nlp.util.StreamGobbler;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtils {
    public static final String eolChar = System.getProperty("line.separator");
    private static final String defaultEnc = "utf-8";
    private static final Pattern tab = Pattern.compile("\t");

    private FileUtils() {
    }

    public static InputStream getFileInputStream(String filename) throws IOException {
        InputStream in = new FileInputStream(filename);
        if (filename.endsWith(".gz")) {
            in = new GZIPInputStream(in);
        } else if (filename.endsWith(".bz2")) {
            in = FileUtils.getBZip2PipedInputStream(filename);
        }
        return in;
    }

    public static OutputStream getFileOutputStream(String filename) throws IOException {
        OutputStream out2 = new FileOutputStream(filename);
        if (filename.endsWith(".gz")) {
            out2 = new GZIPOutputStream(out2);
        } else if (filename.endsWith(".bz2")) {
            out2 = FileUtils.getBZip2PipedOutputStream(filename);
        }
        return out2;
    }

    public static BufferedReader getBufferedFileReader(String filename) throws IOException {
        return FileUtils.getBufferedFileReader(filename, defaultEnc);
    }

    public static BufferedReader getBufferedFileReader(String filename, String encoding) throws IOException {
        InputStream in = FileUtils.getFileInputStream(filename);
        return new BufferedReader(new InputStreamReader(in, encoding));
    }

    public static PrintWriter getPrintWriter(String filename) throws IOException {
        return FileUtils.getPrintWriter(filename, defaultEnc);
    }

    public static PrintWriter getPrintWriter(String filename, String encoding) throws IOException {
        OutputStream out2 = FileUtils.getFileOutputStream(filename);
        return new PrintWriter(new BufferedWriter(new OutputStreamWriter(out2, encoding)));
    }

    public static InputStream getBZip2PipedInputStream(String filename) throws IOException {
        String bzcat = System.getProperty("bzcat", "bzcat");
        Runtime rt = Runtime.getRuntime();
        String cmd = bzcat + " " + filename;
        Process p = rt.exec(cmd);
        BufferedWriter errWriter = new BufferedWriter(new OutputStreamWriter(System.err));
        StreamGobbler errGobler = new StreamGobbler(p.getErrorStream(), errWriter);
        errGobler.start();
        return p.getInputStream();
    }

    public static OutputStream getBZip2PipedOutputStream(String filename) throws IOException {
        return new BZip2PipedOutputStream(filename);
    }

    public static Set<String> readColumnSet(String infile, int field) throws IOException {
        String line;
        BufferedReader br = FileUtils.getBufferedFileReader(infile);
        HashSet<String> set = new HashSet<String>();
        while ((line = br.readLine()) != null) {
            if ((line = line.trim()).length() <= 0) continue;
            if (field < 0) {
                set.add(line);
                continue;
            }
            String[] fields = tab.split(line);
            if (field >= fields.length) continue;
            set.add(fields[field]);
        }
        br.close();
        return set;
    }

    public static <C> List<C> readObjectFromColumns(Class objClass, String filename, String[] fieldNames, String delimiter) throws IOException, InstantiationException, IllegalAccessException, NoSuchFieldException, NoSuchMethodException, InvocationTargetException {
        String line;
        Pattern delimiterPattern = Pattern.compile(delimiter);
        ArrayList list = new ArrayList();
        BufferedReader br = FileUtils.getBufferedFileReader(filename);
        while ((line = br.readLine()) != null) {
            if ((line = line.trim()).length() <= 0) continue;
            Object item = StringUtils.columnStringToObject(objClass, line, delimiterPattern, fieldNames);
            list.add(item);
        }
        br.close();
        return list;
    }

    public static Map<String, String> readMap(String filename) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String line;
            BufferedReader br = FileUtils.getBufferedFileReader(filename);
            while ((line = br.readLine()) != null) {
                String[] fields = tab.split(line, 2);
                map.put(fields[0], fields[1]);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return map;
    }

    public static String stringFromFile(String filename) {
        return FileUtils.stringFromFile(filename, defaultEnc);
    }

    public static String stringFromFile(String filename, String encoding) {
        try {
            String line;
            StringBuilder sb = new StringBuilder();
            BufferedReader in = new BufferedReader(new EncodingFileReader(filename, encoding));
            while ((line = in.readLine()) != null) {
                sb.append(line);
                sb.append(eolChar);
            }
            in.close();
            return sb.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<String> linesFromFile(String filename) {
        return FileUtils.linesFromFile(filename, defaultEnc);
    }

    public static List<String> linesFromFile(String filename, String encoding) {
        try {
            String line;
            ArrayList<String> lines = new ArrayList<String>();
            BufferedReader in = new BufferedReader(new EncodingFileReader(filename, encoding));
            while ((line = in.readLine()) != null) {
                lines.add(line);
            }
            in.close();
            return lines;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String backupName(String filename) {
        return FileUtils.backupFile(new File(filename)).toString();
    }

    public static File backupFile(File file) {
        int max = 1000;
        String filename = file.toString();
        File backup = new File(filename + "~");
        if (!backup.exists()) {
            return backup;
        }
        for (int i = 1; i <= max; ++i) {
            backup = new File(filename + ".~" + i + ".~");
            if (backup.exists()) continue;
            return backup;
        }
        return null;
    }

    public static boolean renameToBackupName(File file) {
        return file.renameTo(FileUtils.backupFile(file));
    }

    public static File getJNLPLocalScratch() {
        try {
            String machineName = InetAddress.getLocalHost().getHostName().split("\\.")[0];
            String username = System.getProperty("user.name");
            return new File("/" + machineName + "/scr1/" + username);
        }
        catch (Exception e) {
            return new File("./scr/");
        }
    }

    public static File ensureDir(File tgtDir) throws Exception {
        if (tgtDir.exists()) {
            if (tgtDir.isDirectory()) {
                return tgtDir;
            }
            throw new Exception("Could not create directory " + tgtDir.getAbsolutePath() + ", as a file already exists at that path.");
        }
        tgtDir.mkdirs();
        return tgtDir;
    }

    public static void main(String[] args) {
        System.out.println(FileUtils.backupName(args[0]));
    }

    public static String getExtension(String fileName) {
        if (!fileName.contains(".")) {
            return null;
        }
        int idx = fileName.lastIndexOf(".");
        return fileName.substring(idx + 1);
    }
}

