/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.executor.format;

import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.sql.legacy.esdomain.LocalClusterState;
import org.opensearch.sql.legacy.esdomain.mapping.FieldMappings;
import org.opensearch.sql.legacy.executor.format.DateFormat;
import org.opensearch.sql.legacy.executor.format.Schema;
import org.opensearch.sql.legacy.utils.StringUtils;
import shaded.com.google.common.annotations.VisibleForTesting;

public class DateFieldFormatter {
    private static final Logger LOG = LogManager.getLogger(DateFieldFormatter.class);
    public static final String FORMAT_JDBC = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final String FORMAT_DELIMITER = "\\|\\|";
    private static final String FORMAT_DOT_DATE_AND_TIME = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final String FORMAT_DOT_OPENSEARCH_DASHBOARDS_SAMPLE_DATA_LOGS_EXCEPTION = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final String FORMAT_DOT_OPENSEARCH_DASHBOARDS_SAMPLE_DATA_FLIGHTS_EXCEPTION = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String FORMAT_DOT_OPENSEARCH_DASHBOARDS_SAMPLE_DATA_FLIGHTS_EXCEPTION_NO_TIME = "yyyy-MM-dd'T'";
    private static final String FORMAT_DOT_OPENSEARCH_DASHBOARDS_SAMPLE_DATA_ECOMMERCE_EXCEPTION = "yyyy-MM-dd'T'HH:mm:ssXXX";
    private static final String FORMAT_DOT_DATE = DateFormat.getFormatString("date");
    private final Map<String, List<String>> dateFieldFormatMap;
    private final Map<String, String> fieldAliasMap;
    private final Set<String> dateColumns;

    public DateFieldFormatter(String indexName, List<Schema.Column> columns, Map<String, String> fieldAliasMap) {
        this.dateFieldFormatMap = this.getDateFieldFormatMap(indexName);
        this.dateColumns = this.getDateColumns(columns);
        this.fieldAliasMap = fieldAliasMap;
    }

    @VisibleForTesting
    protected DateFieldFormatter(Map<String, List<String>> dateFieldFormatMap, List<Schema.Column> columns, Map<String, String> fieldAliasMap) {
        this.dateFieldFormatMap = dateFieldFormatMap;
        this.dateColumns = this.getDateColumns(columns);
        this.fieldAliasMap = fieldAliasMap;
    }

    public void applyJDBCDateFormat(Map<String, Object> rowSource) {
        for (String columnName : this.dateColumns) {
            Object columnOriginalDate = rowSource.get(columnName);
            if (columnOriginalDate == null) continue;
            List<String> formats = this.getFormatsForColumn(columnName);
            if (formats == null) {
                LOG.warn("Could not determine date formats for column {}; returning original value", (Object)columnName);
                continue;
            }
            Date date = this.parseDateString(formats, columnOriginalDate.toString());
            if (date != null) {
                rowSource.put(columnName, DateFormat.getFormattedDate(date, FORMAT_JDBC));
                continue;
            }
            LOG.warn("Could not parse date value; returning original value");
        }
    }

    private List<String> getFormatsForColumn(String columnName) {
        if (this.fieldAliasMap.get(columnName) != null) {
            columnName = this.fieldAliasMap.get(columnName);
        } else if (columnName.split("\\.").length == 2) {
            columnName = columnName.split("\\.")[1];
        }
        return this.dateFieldFormatMap.get(columnName);
    }

    private Set<String> getDateColumns(List<Schema.Column> columns) {
        return columns.stream().filter(column -> column.getType().equals(Schema.Type.DATE.nameLowerCase())).map(Schema.Column::getName).collect(Collectors.toSet());
    }

    private Map<String, List<String>> getDateFieldFormatMap(String indexName) {
        LocalClusterState state = LocalClusterState.state();
        HashMap<String, List<String>> formatMap = new HashMap<String, List<String>>();
        String[] indices = indexName.split("\\|");
        Collection typeProperties = state.getFieldMappings(indices).allMappings();
        for (FieldMappings fieldMappings : typeProperties) {
            for (Map.Entry<String, Map<String, Object>> field : fieldMappings.data().entrySet()) {
                String fieldName = field.getKey();
                Map<String, Object> properties = field.getValue();
                if (properties.containsKey("format")) {
                    formatMap.put(fieldName, this.getFormatsFromProperties(properties.get("format").toString()));
                    continue;
                }
                formatMap.put(fieldName, this.getFormatsFromProperties("date_optional_time"));
            }
        }
        return formatMap;
    }

    private List<String> getFormatsFromProperties(String formatProperty) {
        String[] formats = formatProperty.split(FORMAT_DELIMITER);
        return Arrays.asList(formats);
    }

    private Date parseDateString(List<String> formats, String columnOriginalDate) {
        TimeZone originalDefaultTimeZone = TimeZone.getDefault();
        Date parsedDate = null;
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        for (String columnFormat : formats) {
            try {
                switch (columnFormat) {
                    case "date_optional_time": 
                    case "strict_date_optional_time": {
                        if (StringUtils.isNumeric(columnOriginalDate)) {
                            long timestamp = Long.parseLong(columnOriginalDate);
                            if (timestamp > Integer.MAX_VALUE) {
                                parsedDate = new Date(timestamp);
                                break;
                            }
                            parsedDate = new Date(timestamp * 1000L);
                            break;
                        }
                        parsedDate = DateUtils.parseDate((String)columnOriginalDate, (String[])new String[]{FORMAT_DOT_OPENSEARCH_DASHBOARDS_SAMPLE_DATA_LOGS_EXCEPTION, FORMAT_DOT_OPENSEARCH_DASHBOARDS_SAMPLE_DATA_FLIGHTS_EXCEPTION, FORMAT_DOT_OPENSEARCH_DASHBOARDS_SAMPLE_DATA_FLIGHTS_EXCEPTION_NO_TIME, FORMAT_DOT_OPENSEARCH_DASHBOARDS_SAMPLE_DATA_ECOMMERCE_EXCEPTION, FORMAT_DOT_DATE_AND_TIME, FORMAT_DOT_DATE});
                        break;
                    }
                    case "epoch_millis": {
                        parsedDate = new Date(Long.parseLong(columnOriginalDate));
                        break;
                    }
                    case "epoch_second": {
                        parsedDate = new Date(Long.parseLong(columnOriginalDate) * 1000L);
                        break;
                    }
                    default: {
                        String formatString = DateFormat.getFormatString(columnFormat);
                        if (formatString == null) {
                            formatString = columnFormat;
                        }
                        parsedDate = DateUtils.parseDate((String)columnOriginalDate, (String[])new String[]{formatString});
                    }
                }
            }
            catch (NumberFormatException | ParseException e) {
                LOG.warn(String.format("Could not parse date string %s as %s", columnOriginalDate, columnFormat));
            }
        }
        TimeZone.setDefault(originalDefaultTimeZone);
        return parsedDate;
    }
}

