/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.typing;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.TypingModuleBuiltins;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryOp;
import com.oracle.graal.python.builtins.objects.typing.PParamSpec;
import com.oracle.graal.python.builtins.objects.typing.PParamSpecArgs;
import com.oracle.graal.python.builtins.objects.typing.PParamSpecKwargs;
import com.oracle.graal.python.builtins.objects.typing.ParamSpecBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.typing.ParamSpecBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.typing.ParamSpecBuiltinsSlotsGen;
import com.oracle.graal.python.lib.PyObjectSetAttr;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PParamSpec})
public final class ParamSpecBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = ParamSpecBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ParamSpecBuiltinsFactory.getFactories();
    }

    @Slot(value=Slot.SlotKind.nb_or, isComplex=true)
    @GenerateNodeFactory
    static abstract class OrNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        static final TruffleString T_MAKE_UNION = PythonUtils.tsLiteral("_make_union");

        OrNode() {
        }

        @Specialization
        static Object union(VirtualFrame frame, Object self, Object other, @Bind Node inliningTarget, @Cached TypingModuleBuiltins.CallTypingFuncObjectNode callTypingFuncObjectNode) {
            return callTypingFuncObjectNode.execute(frame, inliningTarget, T_MAKE_UNION, self, other);
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object reduce(PParamSpec self) {
            return self.name;
        }
    }

    @Builtin(name="__mro_entries__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class MroEntriesNode
    extends PythonBinaryBuiltinNode {
        MroEntriesNode() {
        }

        @Specialization
        static Object mro(PParamSpec self, Object bases, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.CANNOT_SUBCLASS_AN_INSTANCE_OF_PARAMSPEC);
        }
    }

    @Builtin(name="__typing_prepare_subst__", minNumOfPositionalArgs=3, parameterNames={"$self", "alias", "args"})
    @GenerateNodeFactory
    static abstract class TypingPrepareSubstNode
    extends PythonTernaryBuiltinNode {
        private static final TruffleString T_PARAMSPEC_PREPARE_SUBST = PythonUtils.tsLiteral("_paramspec_prepare_subst");

        TypingPrepareSubstNode() {
        }

        @Specialization
        static Object doTypingPrepareSubst(VirtualFrame frame, PParamSpec self, Object alias, Object args, @Bind Node inliningTarget, @Cached TypingModuleBuiltins.CallTypingFuncObjectNode callTypingFuncObjectNode) {
            return callTypingFuncObjectNode.execute(frame, inliningTarget, T_PARAMSPEC_PREPARE_SUBST, self, alias, args);
        }
    }

    @Builtin(name="__typing_subst__", minNumOfPositionalArgs=2, parameterNames={"$self", "arg"})
    @GenerateNodeFactory
    static abstract class TypingSubstNode
    extends PythonBinaryBuiltinNode {
        static final TruffleString T_PARAMSPEC_SUBST = PythonUtils.tsLiteral("_paramspec_subst");

        TypingSubstNode() {
        }

        @Specialization
        static Object doTypingSubst(VirtualFrame frame, PParamSpec self, Object arg, @Bind Node inliningTarget, @Cached TypingModuleBuiltins.CallTypingFuncObjectNode callTypingFuncObjectNode) {
            return callTypingFuncObjectNode.execute(frame, inliningTarget, T_PARAMSPEC_SUBST, self, arg);
        }
    }

    @Slot(value=Slot.SlotKind.tp_repr, isComplex=true)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        @Specialization(guards={"self.inferVariance"})
        static TruffleString reprInferVariance(PParamSpec self) {
            return self.name;
        }

        @Specialization(guards={"!self.inferVariance"})
        static TruffleString repr(PParamSpec self, @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            char variance = self.covariant ? (char)'+' : (self.contravariant ? (char)'-' : '~');
            return simpleTruffleStringFormatNode.format("%c%s", Character.valueOf(variance), self.name);
        }
    }

    @Builtin(name="kwargs", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetKwargsNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static PParamSpecKwargs doKwargs(PParamSpec self, @Bind PythonLanguage language) {
            return PFactory.createParamSpecKwargs(language, self);
        }
    }

    @Builtin(name="args", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetArgsNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static PParamSpecArgs doArgs(PParamSpec self, @Bind PythonLanguage language) {
            return PFactory.createParamSpecArgs(language, self);
        }
    }

    @Builtin(name="__bound__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetBoundNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object doBound(PParamSpec self) {
            return self.bound;
        }
    }

    @Builtin(name="__infer_variance__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetInferVarianceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static boolean doInferVariance(PParamSpec self) {
            return self.inferVariance;
        }
    }

    @Builtin(name="__contravariant__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetContravariantNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static boolean doContravariant(PParamSpec self) {
            return self.contravariant;
        }
    }

    @Builtin(name="__covariant__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetCovariantNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static boolean doCovariant(PParamSpec self) {
            return self.covariant;
        }
    }

    @Builtin(name="__name__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class GetNameNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static TruffleString doName(PParamSpec self) {
            return self.name;
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="ParamSpec", minNumOfPositionalArgs=2, parameterNames={"$cls", "name"}, keywordOnlyNames={"bound", "covariant", "contravariant", "infer_variance"}, needsFrame=true, alwaysNeedsCallerFrame=true)
    @ArgumentsClinic(value={@ArgumentClinic(name="name", conversion=ArgumentClinic.ClinicConversion.TString), @ArgumentClinic(name="covariant", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="false"), @ArgumentClinic(name="contravariant", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="false"), @ArgumentClinic(name="infer_variance", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="false")})
    @GenerateNodeFactory
    static abstract class ParamSpecNode
    extends PythonClinicBuiltinNode {
        ParamSpecNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ParamSpecBuiltinsClinicProviders.ParamSpecNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PParamSpec newParamSpec(VirtualFrame frame, Object cls, TruffleString name, Object bound, boolean covariant, boolean contravariant, boolean inferVariance, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached TypingModuleBuiltins.CheckBoundNode checkBoundNode, @Cached TypingModuleBuiltins.CallerNode callerNode, @Cached PRaiseNode raiseNode, @Cached TypeNodes.GetInstanceShape getInstanceShape, @Cached PyObjectSetAttr setAttrNode) {
            if (covariant && contravariant) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.BIVARIANT_TYPES_ARE_NOT_SUPPORTED);
            }
            if (inferVariance && (covariant || contravariant)) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.VARIANCE_CANNOT_BE_SPECIFIED_WITH_INFER_VARIANCE);
            }
            Object boundChecked = checkBoundNode.execute(frame, inliningTarget, bound);
            Object module = callerNode.execute(frame, inliningTarget);
            PParamSpec result = PFactory.createParamSpec(language, cls, getInstanceShape.execute(cls), name, boundChecked, covariant, contravariant, inferVariance);
            setAttrNode.execute((Frame)frame, inliningTarget, result, SpecialAttributeNames.T___MODULE__, module);
            return result;
        }
    }
}

