package Daje::Workflow::Observers;
use Mojo::Base -base, -signatures;

use Mojo::Loader qw(load_class);

# Daje::Workflow::Activities::Activity - Manage activities in the workflow
#
#
# METHODS
# =======
#
#    observer($self, $context, $observers);
#
#    $observers = {
#             "name": "sql",
#             "observer": "Daje::Plugin::GenerateSQL",
#             "method": "genereate"
#           }
#
#
#

has 'db';
has 'error';
has 'model';

sub observer($self, $context, $observers) {
    return 1 unless defined $observers;
    my $result = 1;

    my $length = scalar @{$observers};
    for (my $i = 0; $i < $length; $i++) {
        $self->model->insert_history('Observer', @{$observers}[$i]->{observer}, 1);
        if(my $e = load_class @{$observers}[$i]->{observer}) {
            $self->error->add_error($e)
        }
        # $class->import();
        if ($self->error->has_error() == 0) {
            my $object = @{$observers}[$i]->new(
                context => $context,
                db      => $self->db,
                error   => $self->error,
                model   => $self->model,
            )->observe();
        }
    }

    return $result;
}

1;


#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME

Daje::Workflow::Observers


=head1 DESCRIPTION

Daje::Workflow::Activities::Activity - Manage activities in the workflow




=head1 REQUIRES

L<Mojo::Loader> 

L<Mojo::Base> 


=head1 METHODS


   observer($self, $context, $observers);

   $observers = {
            "name": "sql",
            "observer": "Daje::Plugin::GenerateSQL",
            "method": "genereate"
          }





=cut

