package WARC::Index::Entry;					# -*- CPerl -*-

use strict;
use warnings;

our @ISA = qw();

require WARC; *WARC::Index::Entry::VERSION = \$WARC::VERSION;

=head1 NAME

WARC::Index::Entry - abstract base class for WARC::Index entries

=head1 SYNOPSIS

  use WARC;		# or ...
  use WARC::Index;

  # WARC::Index::Entry objects are returned from directly searching an index

=head1 DESCRIPTION

=head2 Methods

=over

=item @report = $entry-E<gt>distance( ... )

=item $distance = $entry-E<gt>distance( ... )

In list context, return a detailed report mapping each search I<key> to a
distance value.  In scalar context, return an overall summary distance,
such that sorting entries by the return values of this method in ascending
order will place the closest matches at the top of the list.

A valid distance is non-negative.  Negative distance values indicate that
the record does not match the criteria at all.  An undefined value
indicates that the entry is from an index that does not store the
information needed to evaluate distance for that search key.  Undefined
values are ignored when computing the summarized distance, but the
summarized distance will be negative if any keys do not match at all.

For details on available search keys, see the L<"Search Keys"
section|WARC::Collection/"Search Keys"> of the C<WARC::Collection> page.

=cut

sub distance {
  die __PACKAGE__." is an abstract base class and "
    .(ref shift)." must override the 'distance' method"
}

=back

=cut

1;
__END__

=head1 AUTHOR

Jacob Bachmeyer, E<lt>jcb@cpan.orgE<gt>

=head1 SEE ALSO

L<WARC>, L<WARC::Index>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2019 by Jacob Bachmeyer

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut
