# Unit tests for WARC::Index module				# -*- CPerl -*-

use strict;
use warnings;

use Test::More tests => 4;
BEGIN { use_ok('WARC::Index')
	  or BAIL_OUT "WARC::Index failed to load" }

BEGIN {
  my $fail = 0;
  eval q{use WARC::Index v9999.1.2.3; $fail = 1};
  ok($fail == 0
     && $@ =~ m/WARC.* version v9999.*required--this is only version/,
     'WARC::Index version check')
}

my $fail = 0;

eval { my $index = attach WARC::Index (); $fail = 1 };
ok($fail == 0 && $@ =~ m/abstract base class/, 'attaching base class dies');

{
  my $index = bless {}, 'WARC::Index'; # make a fake index object
  $fail = 0;

  eval { $index->search(bogus => 1); $fail = 1 };
  ok($fail == 0 && $@ =~ m/abstract base class/, 'search in base class dies');
}
