use strict;
use warnings;
use ExtUtils::MakeMaker;

WriteMakefile(
    NAME               => 'Dev::Util',
    DISTNAME           => 'Dev-Util',
    AUTHOR             => 'Matt Martini <matt@imaginarywave.com>',
    VERSION_FROM       => 'lib/Dev/Util.pm',
    ABSTRACT_FROM      => 'lib/Dev/Util.pm',
    LICENSE            => 'gpl_3',
    MIN_PERL_VERSION   => '5.018',
    PL_FILES           => {},
    BUILD_REQUIRES     => { 'ExtUtils::MakeMaker' => 0, },
    CONFIGURE_REQUIRES => { 'ExtUtils::MakeMaker' => 0, },
    PREREQ_PM          => {
                       'Archive::Tar'    => 0,
                       'Carp'            => 0,
                       'English'         => 0,
                       'Exporter'        => 0,
                       'File::Basename'  => 0,
                       'File::Copy'      => 0,
                       'File::Find'      => 0,
                       'File::Spec'      => 0,
                       'File::Temp'      => 0,
                       'IO::File'        => 0,
                       'IO::Handle'      => 0,
                       'IO::Interactive' => 0,
                       'IPC::Cmd'        => 0,
                       'Import::Into'    => 0,
                       'List::Util'      => 0,
                       'Module::Runtime' => 0,
                       'Readonly'        => 0,
                       'Term::ANSIColor' => 0,
                       'Term::ReadKey'   => 0,
                       'autodie'         => 0,
                       'strict'          => 0,
                       'utf8'            => 0,
                       'version'         => 0,
                       'warnings'        => 0,
                 },
    TEST_REQUIRES => {     'English'            => 0,
                           'ExtUtils::Manifest' => 0,
                           'File::Compare'      => 0,
                           'File::Path'         => 0,
                           'FindBin'            => 0,
                           'Socket'             => 0,
                           'Test2::V0'          => 0,
                           'Test2::Tools::Ref'  => 0,
                           'Test::More'         => 0,
                     },
    META_MERGE => {
        'meta-spec' => { version => 2 },
        resources   => {   repository => {
                                         type => 'git',
                                         url => 'https://github.com/mattmartini/Dev-Util.git',
                                         web => 'https://github.com/mattmartini/Dev-Util'
                           },
                     }
                  },
    dist  => { COMPRESS => 'gzip -9f', SUFFIX => 'gz', },
    clean => { FILES    => 'Dev-Util-*' },
    ## NOECHO => '', # make debug output if empty
);

# XT_TEST_REQUIRES => { 'Test2::Bundle::More'           => 0,
#                       'Test2::Require::AuthorTesting' => 0,
#                       'Test::Kwalitee'                => 0,
#                       'Test2::Require::Module'        => 0,
#                       'Test::Pod::Coverage'           => 0,
#                       'Pod::Coverage'                 => 0,
#                       'Test::Spelling'                => 0,
#                       'Pod::Wordlist'                 => 0,
#                     },
