#! /usr/bin/env false

use v6.d;

use Config;
use Grammar::DiceRolls;
use Grammar::DiceRolls::CountActions;
use IRC::Client;

unit class IRC::Client::Plugin::DiceRolls does IRC::Client::Plugin;

#| A Config instance to hold all configuration.
has Config $.config;

#| The calculated prefix for the dice roll command.
has Str $!prefix;

submethod TWEAK
{
	$!prefix = [~]
		$!config.get('irc.command-prefix', '.'),
		$!config.get('irc.plugins.dicerolls.command-word', 'roll'),
		;
}

multi method irc-privmsg (
	$event where { $event.text.starts-with($!prefix) }
) {
	my $roll = $event.text.substr($!prefix.chars).trim;
	my $outcome = Grammar::DiceRolls.parse(
		$roll,
		:actions(Grammar::DiceRolls::CountActions)
	).made;

	return "Invalid roll ($roll)" unless $outcome;

	"$roll = $outcome";
}

=begin pod

=NAME    IRC::Client::Plugin::DiceRolls
=VERSION 0.0.0
=AUTHOR  Patrick Spek <p.spek@tyil.nl>

=begin LICENSE
Copyright © 2020

This program is free software: you can redistribute it and/or modify it under
the terms of the GNU Affero General Public License as published by the Free
Software Foundation, either version 3 of the License, or (at your option) any
later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.  See the GNU Affero General Public License for more
details.

You should have received a copy of the GNU Affero General Public License along
with this program.  If not, see http://www.gnu.org/licenses/.
=end LICENSE

=end pod

# vim: ft=raku noet sw=8 ts=8
